/*
 * Decompiled with CFR 0.152.
 */
package com.github.zathrus_writer.commandsex.helpers;

import com.github.zathrus_writer.commandsex.CommandsEX;
import com.github.zathrus_writer.commandsex.helpers.LogHelper;
import com.github.zathrus_writer.commandsex.helpers.Permissions;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.minecraft.server.v1_5_R3.EntityPlayer;
import net.minecraft.server.v1_5_R3.MinecraftServer;
import net.minecraft.server.v1_5_R3.PlayerInteractManager;
import net.minecraft.server.v1_5_R3.World;
import org.apache.commons.lang.WordUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_5_R3.CraftServer;
import org.bukkit.craftbukkit.v1_5_R3.entity.CraftPlayer;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class Utils {
    public static transient Map<String, Integer> lastCommandUsage = new HashMap<String, Integer>();
    protected static Boolean spamCleanupStarted = false;
    private static Integer spamCleanupPeriod = 5;

    public static Integer getUnixTimestamp(Long i) {
        if (i == 0L) {
            i = System.currentTimeMillis();
        }
        return (int)(i / 1000L);
    }

    public static String implode(Object[] inputArray, String glueString) {
        String output = "";
        if (inputArray.length > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append(inputArray[0]);
            for (int i = 1; i < inputArray.length; ++i) {
                sb.append(glueString);
                sb.append(inputArray[i]);
            }
            output = sb.toString();
        }
        return output;
    }

    public static String implode(List<?> listInputArray, String glueString) {
        Object[] inputArray = listInputArray.toArray();
        return Utils.implode(inputArray, glueString);
    }

    public static Boolean checkCommandSpam(Player player, String commandName, Integer ... minTimeout) {
        if (Permissions.checkPermEx((CommandSender)player, "cex.allowspamcommands").booleanValue()) {
            return false;
        }
        if (!spamCleanupStarted.booleanValue()) {
            CommandsEX.plugin.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)CommandsEX.plugin, new Runnable(){

                @Override
                public void run() {
                    Iterator<Map.Entry<String, Integer>> it = lastCommandUsage.entrySet().iterator();
                    ArrayList<String> toRem = new ArrayList<String>();
                    while (it.hasNext()) {
                        Map.Entry<String, Integer> pairs = it.next();
                        Player p = Bukkit.getServer().getPlayer(pairs.getKey());
                        if (p != null) continue;
                        toRem.add(pairs.getKey());
                    }
                    if (toRem.size() > 0) {
                        for (String s : toRem) {
                            lastCommandUsage.remove(s);
                        }
                    }
                }
            }, (long)(20 * spamCleanupPeriod * 60), (long)(20 * spamCleanupPeriod * 60));
            spamCleanupStarted = true;
        }
        Integer t = 0;
        t = minTimeout.length == 0 ? Integer.valueOf(CommandsEX.getConf().getInt("commandCooldownTime")) : minTimeout[0];
        String playerName = player.getName();
        Boolean ret = false;
        Integer stamp = Utils.getUnixTimestamp(0L);
        if (lastCommandUsage.containsKey(playerName + "-" + commandName)) {
            ret = stamp - lastCommandUsage.get(playerName + "-" + commandName) < t;
        }
        if (ret.booleanValue()) {
            LogHelper.showInfo("dontSpamCommand", (CommandSender)player, new ChatColor[0]);
        }
        lastCommandUsage.put(playerName + "-" + commandName, stamp);
        return ret;
    }

    public static Map<String, Integer> parseTime(String[] args) throws PatternSyntaxException, Throwable {
        Boolean dateNotFound = true;
        HashMap<String, Integer> ret = new HashMap<String, Integer>();
        for (String s : args) {
            if (!s.startsWith("t:")) continue;
            dateNotFound = false;
            Pattern Regex = Pattern.compile("(\\d+)(years?|y|months?|m|weeks?|w|days?|d|hours?|hrs?|h|minutes?|mins?|m|seconds?|secs?|s)", 194);
            Matcher RegexMatcher = Regex.matcher(s.substring(2, s.length()));
            while (RegexMatcher.find()) {
                Integer v = RegexMatcher.group(1).matches("(-)?(\\d){1,10}(\\.(\\d){1,10})?") ? Integer.valueOf(Integer.parseInt(RegexMatcher.group(1))) : Integer.valueOf(0);
                if (RegexMatcher.group(2).startsWith("y")) {
                    ret.put("years", v);
                    continue;
                }
                if (RegexMatcher.group(2).startsWith("m")) {
                    ret.put("months", v);
                    continue;
                }
                if (RegexMatcher.group(2).startsWith("w")) {
                    ret.put("weeks", v);
                    continue;
                }
                if (RegexMatcher.group(2).startsWith("d")) {
                    ret.put("days", v);
                    continue;
                }
                if (RegexMatcher.group(2).startsWith("h")) {
                    ret.put("hours", v);
                    continue;
                }
                if (RegexMatcher.group(2).startsWith("m")) {
                    ret.put("minutes", v);
                    continue;
                }
                if (RegexMatcher.group(2).startsWith("s")) {
                    ret.put("seconds", v);
                    continue;
                }
                throw new Throwable("Invalid time parameter: " + RegexMatcher.group(2));
            }
        }
        if (dateNotFound.booleanValue()) {
            ret.put("not_found", 1);
        }
        if (ret.get("years") == null) {
            ret.put("years", 0);
        }
        if (ret.get("months") == null) {
            ret.put("months", 0);
        }
        if (ret.get("weeks") == null) {
            ret.put("weeks", 0);
        }
        if (ret.get("days") == null) {
            ret.put("days", 0);
        }
        if (ret.get("hours") == null) {
            ret.put("hours", 0);
        }
        if (ret.get("minutes") == null) {
            ret.put("minutes", 0);
        }
        if (ret.get("seconds") == null) {
            ret.put("seconds", 0);
        }
        return ret;
    }

    public static Map<String, Integer> parseTimeStamp(Long stamp) {
        HashMap<String, Integer> m = new HashMap<String, Integer>();
        Integer years = (int)Math.floor(stamp / 29030400L);
        Integer months = (int)Math.floor((stamp - (long)(years * 29030400)) / 2419200L);
        Integer weeks = (int)Math.floor((stamp - (long)(months * 2419200)) / 604800L);
        Integer days = (int)Math.floor((stamp - (long)(weeks * 604800)) / 86400L);
        Integer hours = (int)Math.floor((stamp - (long)(days * 86400)) / 3600L);
        Integer minutes = (int)Math.floor((stamp - (long)(days * 86400) - (long)(hours * 3600)) / 60L);
        Integer seconds = (int)(stamp - (long)(days * 86400) - (long)(hours * 3600) - (long)(minutes * 60));
        m.put("years", years);
        m.put("months", months);
        m.put("weeks", weeks);
        m.put("days", days);
        m.put("hours", hours);
        m.put("minutes", minutes);
        m.put("seconds", seconds);
        return m;
    }

    public static Map<String, Integer> parseTimeStamp(Integer stamp) {
        return Utils.parseTimeStamp(new Long(stamp.intValue()));
    }

    public static String replaceChatColors(String s) {
        for (ChatColor c : ChatColor.values()) {
            s = s.replaceAll("&" + c.getChar(), ChatColor.getByChar((char)c.getChar()) + "");
        }
        return s;
    }

    public static boolean hasChatColor(String s) {
        boolean hasChatColor = false;
        for (ChatColor c : ChatColor.values()) {
            if (!s.contains("&" + c.getChar())) continue;
            hasChatColor = true;
        }
        return hasChatColor;
    }

    public static String userFriendlyNames(String name) {
        String formattedName = WordUtils.capitalize((String)name.replaceAll("_", " ").toLowerCase());
        return formattedName;
    }

    public static String convertToHHMMSS(long currentTime, boolean seconds) {
        long hours = currentTime / 3600L;
        long remainder = currentTime % 3600L;
        long minutes = remainder / 60L;
        long seconds1 = remainder % 60L;
        String string = (hours < 10L ? "0" : "") + hours + ":" + (minutes < 10L ? "0" : "") + minutes + ":" + (seconds ? (seconds1 < 10L ? "0" : "") + seconds1 : "");
        return string;
    }

    public static String parseTime(long time) {
        long gameTime = time;
        long hours = gameTime / 1000L + 6L;
        long minutes = gameTime % 1000L * 60L / 1000L;
        String ampm = "AM";
        if (hours >= 12L) {
            hours -= 12L;
            ampm = "PM";
        }
        if (hours >= 12L) {
            hours -= 12L;
            ampm = "AM";
        }
        if (hours == 0L) {
            hours = 12L;
        }
        String mm = "0" + minutes;
        mm = mm.substring(mm.length() - 2, mm.length());
        return hours + ":" + mm + " " + ampm;
    }

    public static byte degreeToByte(float degree) {
        return (byte)((float)((int)degree) * 256.0f / 360.0f);
    }

    public static String typeOfEntity(EntityType eType) {
        String type = "none";
        EntityType[] passives = new EntityType[]{EntityType.CHICKEN, EntityType.COW, EntityType.MUSHROOM_COW, EntityType.OCELOT, EntityType.PIG, EntityType.SHEEP, EntityType.WOLF, EntityType.SQUID, EntityType.VILLAGER, EntityType.SNOWMAN, EntityType.IRON_GOLEM, EntityType.BAT};
        EntityType[] aggressives = new EntityType[]{EntityType.BLAZE, EntityType.CAVE_SPIDER, EntityType.CREEPER, EntityType.ENDER_DRAGON, EntityType.ENDERMAN, EntityType.GHAST, EntityType.GIANT, EntityType.MAGMA_CUBE, EntityType.PIG_ZOMBIE, EntityType.SILVERFISH, EntityType.SKELETON, EntityType.SLIME, EntityType.SPIDER, EntityType.ZOMBIE, EntityType.WITHER, EntityType.WITCH};
        for (EntityType et : passives) {
            if (eType != et) continue;
            type = "passive";
        }
        if (type.equals("none")) {
            for (EntityType et : aggressives) {
                if (eType != et) continue;
                type = "aggressive";
            }
        }
        return type;
    }

    public static List<String> separateCommaList(String s) {
        return Arrays.asList(s.split("\\s*,\\s*"));
    }

    public static String collectArgs(String[] args) {
        return Utils.collectArgs(args, 0);
    }

    public static String collectArgs(String[] args, int startAt) {
        StringBuilder sb = new StringBuilder();
        for (int i = startAt; i < args.length; ++i) {
            sb.append(args[i]).append(" ");
        }
        return sb.toString().trim();
    }

    public static List<Object> getKeysFromValue(Map<?, ?> hm, Object value) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object o : hm.keySet()) {
            if (!hm.get(o).equals(value)) continue;
            list.add(o);
        }
        return list;
    }

    public static String twoDecimalPlaces(double input) {
        DecimalFormat df = new DecimalFormat("####0.00");
        return df.format(input);
    }

    public static URL shortenURL(URL urlToShorten) throws IOException {
        URL vGD = new URL("http://v.gd/create.php?format=simple&url=" + urlToShorten.getPath());
        URLConnection con = vGD.openConnection();
        BufferedReader content = new BufferedReader(new InputStreamReader(con.getInputStream()));
        String shortened = content.readLine();
        if (shortened != null) {
            content.close();
            return new URL(shortened);
        }
        return null;
    }

    public static String getTime() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
        Calendar cal = Calendar.getInstance();
        return dateFormat.format(cal.getTime());
    }

    public static List<String> noGenericTypeToStringType(List list) {
        ArrayList<String> toReturn = new ArrayList<String>();
        for (Object o : list) {
            toReturn.add(o.toString());
        }
        return toReturn;
    }

    public static Player getOfflinePlayer(String player) {
        Player player2 = Bukkit.getPlayerExact((String)player);
        if (player2 == null) {
            try {
                File playerfolder = new File(((org.bukkit.World)Bukkit.getWorlds().get(0)).getWorldFolder(), "players");
                for (File playerfile : playerfolder.listFiles()) {
                    String filename = playerfile.getName();
                    String playername = filename.substring(0, filename.length() - 4);
                    if (!playername.trim().equalsIgnoreCase(player)) continue;
                    MinecraftServer server = ((CraftServer)CommandsEX.plugin.getServer()).getServer();
                    EntityPlayer entity = new EntityPlayer(server, (World)server.getWorldServer(0), playername, new PlayerInteractManager((World)server.getWorldServer(0)));
                    CraftPlayer craftPlayer = player2 = entity == null ? null : entity.getBukkitEntity();
                    if (player2 != null) {
                        player2.loadData();
                        continue;
                    }
                    return null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return player2;
    }
}

