/*
 * Decompiled with CFR 0.152.
 */
package com.github.zathrus_writer.commandsex.helpers;

import com.github.zathrus_writer.commandsex.CommandsEX;
import com.github.zathrus_writer.commandsex.helpers.LogHelper;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;

public class UpdateAlerter
implements Listener {
    private Plugin plugin;
    private UpdateType type;
    private String versionTitle;
    private String versionLink;
    private long totalSize;
    private int sizeLine;
    private int multiplier;
    private boolean announce;
    private URL url;
    private static final String DBOUrl = "http://dev.bukkit.org/server-mods/";
    private String[] noUpdateTag = new String[]{"-DEV", "-PRE"};
    private static final int BYTE_SIZE = 1024;
    private String updateFolder = YamlConfiguration.loadConfiguration((File)new File("bukkit.yml")).getString("settings.update-folder");
    private UpdateResult result = UpdateResult.SUCCESS;
    private static final String TITLE = "title";
    private static final String LINK = "link";
    private static final String ITEM = "item";

    public static void init(CommandsEX plugin) {
        if (CommandsEX.getConf().getBoolean("updateAlerter")) {
            UpdateAlerter update = new UpdateAlerter((Plugin)CommandsEX.plugin, "commandsex", CommandsEX.file, UpdateType.NO_DOWNLOAD, true);
            CommandsEX.plugin.getServer().getPluginManager().registerEvents((Listener)update, (Plugin)CommandsEX.plugin);
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent e) {
        Player player = e.getPlayer();
        if (this.result.equals((Object)UpdateResult.UPDATE_AVAILABLE) && player.hasPermission("cex.update.alert")) {
            player.sendMessage(ChatColor.AQUA + "A new version of CommandsEX is available!");
            player.sendMessage(ChatColor.AQUA + "http://http://dev.bukkit.org/server-mods/commandsex/");
        }
    }

    public UpdateAlerter(Plugin plugin, String slug, File file, UpdateType type, boolean announce) {
        this.plugin = plugin;
        this.type = type;
        this.announce = announce;
        try {
            this.url = new URL(DBOUrl + slug + "/files.rss");
        }
        catch (MalformedURLException ex) {
            plugin.getLogger().warning("The author of this plugin has misconfigured their Auto Update system");
            plugin.getLogger().warning("The project slug added ('" + slug + "') is invalid, and does not exist on dev.bukkit.org");
            this.result = UpdateResult.FAIL_BADSLUG;
        }
        if (this.url != null) {
            this.readFeed();
            if (this.versionCheck(this.versionTitle)) {
                String fileLink = this.getFile(this.versionLink);
                if (fileLink != null && type != UpdateType.NO_DOWNLOAD) {
                    String name = file.getName();
                    if (fileLink.endsWith(".zip")) {
                        String[] split = fileLink.split("/");
                        name = split[split.length - 1];
                    }
                    this.saveFile(new File("plugins/" + this.updateFolder), name, fileLink);
                } else {
                    this.result = UpdateResult.UPDATE_AVAILABLE;
                }
            }
        }
        if (this.result.equals((Object)UpdateResult.UPDATE_AVAILABLE)) {
            LogHelper.logInfo("A new version of CommandsEX is available!");
            LogHelper.logInfo("http://dev.bukkit.org/server-mods/commandsex/");
        }
    }

    public UpdateResult getResult() {
        return this.result;
    }

    public long getFileSize() {
        return this.totalSize;
    }

    public String getLatestVersionString() {
        return this.versionTitle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveFile(File folder, String file, String u) {
        if (!folder.exists()) {
            folder.mkdir();
        }
        BufferedInputStream in = null;
        FileOutputStream fout = null;
        try {
            int count;
            URL url = new URL(u);
            int fileLength = url.openConnection().getContentLength();
            in = new BufferedInputStream(url.openStream());
            fout = new FileOutputStream(folder.getAbsolutePath() + "/" + file);
            byte[] data = new byte[1024];
            if (this.announce) {
                this.plugin.getLogger().info("About to download a new update: " + this.versionTitle);
            }
            long downloaded = 0L;
            while ((count = in.read(data, 0, 1024)) != -1) {
                fout.write(data, 0, count);
                int percent = (int)((downloaded += (long)count) * 100L / (long)fileLength);
                if (!(this.announce & percent % 10 == 0)) continue;
                this.plugin.getLogger().info("Downloading update: " + percent + "% of " + fileLength + " bytes.");
            }
            for (File xFile : new File("plugins/" + this.updateFolder).listFiles()) {
                if (!xFile.getName().endsWith(".zip")) continue;
                xFile.delete();
            }
            File dFile = new File(folder.getAbsolutePath() + "/" + file);
            if (dFile.getName().endsWith(".zip")) {
                this.unzip(dFile.getCanonicalPath());
            }
            if (this.announce) {
                this.plugin.getLogger().info("Finished updating.");
            }
        }
        catch (Exception ex) {
            this.plugin.getLogger().warning("The auto-updater tried to download a new update, but was unsuccessful.");
            this.result = UpdateResult.FAIL_DOWNLOAD;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (fout != null) {
                    fout.close();
                }
            }
            catch (Exception ex) {}
        }
    }

    private void unzip(String file) {
        try {
            File fSourceZip = new File(file);
            String zipPath = file.substring(0, file.length() - 4);
            ZipFile zipFile = new ZipFile(fSourceZip);
            Enumeration<? extends ZipEntry> e = zipFile.entries();
            while (e.hasMoreElements()) {
                int b;
                ZipEntry entry = e.nextElement();
                File destinationFilePath = new File(zipPath, entry.getName());
                destinationFilePath.getParentFile().mkdirs();
                if (entry.isDirectory()) continue;
                BufferedInputStream bis = new BufferedInputStream(zipFile.getInputStream(entry));
                byte[] buffer = new byte[1024];
                FileOutputStream fos = new FileOutputStream(destinationFilePath);
                BufferedOutputStream bos = new BufferedOutputStream(fos, 1024);
                while ((b = bis.read(buffer, 0, 1024)) != -1) {
                    bos.write(buffer, 0, b);
                }
                bos.flush();
                bos.close();
                bis.close();
                String name = destinationFilePath.getName();
                if (name.endsWith(".jar") && this.pluginFile(name)) {
                    destinationFilePath.renameTo(new File("plugins/" + this.updateFolder + "/" + name));
                }
                entry = null;
                destinationFilePath = null;
            }
            e = null;
            zipFile.close();
            zipFile = null;
            for (File dFile : new File(zipPath).listFiles()) {
                if (dFile.isDirectory() && this.pluginFile(dFile.getName())) {
                    File oFile = new File("plugins/" + dFile.getName());
                    File[] contents = oFile.listFiles();
                    for (File cFile : dFile.listFiles()) {
                        boolean found = false;
                        for (File xFile : contents) {
                            if (!xFile.getName().equals(cFile.getName())) continue;
                            found = true;
                            break;
                        }
                        if (!found) {
                            cFile.renameTo(new File(oFile.getCanonicalFile() + "/" + cFile.getName()));
                            continue;
                        }
                        cFile.delete();
                    }
                }
                dFile.delete();
            }
            new File(zipPath).delete();
            fSourceZip.delete();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            this.plugin.getLogger().warning("The auto-updater tried to unzip a new update file, but was unsuccessful.");
            this.result = UpdateResult.FAIL_DOWNLOAD;
        }
        new File(file).delete();
    }

    public boolean pluginFile(String name) {
        for (File file : new File("plugins").listFiles()) {
            if (!file.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    private String getFile(String link) {
        String download = null;
        try {
            String line;
            URL url = new URL(link);
            URLConnection urlConn = url.openConnection();
            InputStreamReader inStream = new InputStreamReader(urlConn.getInputStream());
            BufferedReader buff = new BufferedReader(inStream);
            int counter = 0;
            while ((line = buff.readLine()) != null) {
                ++counter;
                if (line.contains("<li class=\"user-action user-action-download\">")) {
                    download = line.split("<a href=\"")[1].split("\">Download</a>")[0];
                    continue;
                }
                if (line.contains("<dt>Size</dt>")) {
                    this.sizeLine = counter + 1;
                    continue;
                }
                if (counter != this.sizeLine) continue;
                String size = line.replaceAll("<dd>", "").replaceAll("</dd>", "");
                this.multiplier = size.contains("MiB") ? 0x100000 : 1024;
                size = size.replace(" KiB", "").replace(" MiB", "");
                this.totalSize = (long)(Double.parseDouble(size) * (double)this.multiplier);
            }
            urlConn = null;
            inStream = null;
            buff.close();
            buff = null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.plugin.getLogger().warning("The auto-updater tried to contact dev.bukkit.org, but was unsuccessful.");
            this.result = UpdateResult.FAIL_DBO;
            return null;
        }
        return download;
    }

    private boolean versionCheck(String title) {
        if (this.type != UpdateType.NO_VERSION_CHECK) {
            String version = this.plugin.getDescription().getVersion();
            if (title.split("v").length == 2) {
                String remoteVersion = title.split("v")[1].split(" ")[0];
                if (this.hasTag(version) || version.equalsIgnoreCase(remoteVersion)) {
                    this.result = UpdateResult.NO_UPDATE;
                    return false;
                }
            } else {
                this.plugin.getLogger().warning("The author of this plugin has misconfigured their Auto Update system");
                this.plugin.getLogger().warning("Files uploaded to BukkitDev should contain the version number, seperated from the name by a 'v', such as PluginName v1.0");
                this.plugin.getLogger().warning("Please notify the author (" + (String)this.plugin.getDescription().getAuthors().get(0) + ") of this error.");
                this.result = UpdateResult.FAIL_NOVERSION;
                return false;
            }
        }
        return true;
    }

    private boolean hasTag(String version) {
        for (String string : this.noUpdateTag) {
            if (!version.contains(string)) continue;
            return true;
        }
        return false;
    }

    private void readFeed() {
        try {
            String title = "";
            String link = "";
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            InputStream in = this.read();
            XMLEventReader eventReader = inputFactory.createXMLEventReader(in);
            while (eventReader.hasNext()) {
                XMLEvent event = eventReader.nextEvent();
                if (event.isStartElement()) {
                    if (event.asStartElement().getName().getLocalPart().equals(TITLE)) {
                        event = eventReader.nextEvent();
                        title = event.asCharacters().getData();
                        continue;
                    }
                    if (!event.asStartElement().getName().getLocalPart().equals(LINK)) continue;
                    event = eventReader.nextEvent();
                    link = event.asCharacters().getData();
                    continue;
                }
                if (!event.isEndElement() || !event.asEndElement().getName().getLocalPart().equals(ITEM)) continue;
                this.versionTitle = title;
                this.versionLink = link;
                break;
            }
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    private InputStream read() {
        try {
            return this.url.openStream();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static enum UpdateType {
        DEFAULT(1),
        NO_VERSION_CHECK(2),
        NO_DOWNLOAD(3);

        private static final Map<Integer, UpdateType> valueList;
        private final int value;

        private UpdateType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static UpdateType getResult(int value) {
            return valueList.get(value);
        }

        static {
            valueList = new HashMap<Integer, UpdateType>();
            for (UpdateType result : UpdateType.values()) {
                valueList.put(result.value, result);
            }
        }
    }

    public static enum UpdateResult {
        SUCCESS(1),
        NO_UPDATE(2),
        FAIL_DOWNLOAD(3),
        FAIL_DBO(4),
        FAIL_NOVERSION(5),
        FAIL_BADSLUG(6),
        UPDATE_AVAILABLE(7);

        private static final Map<Integer, UpdateResult> valueList;
        private final int value;

        private UpdateResult(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static UpdateResult getResult(int value) {
            return valueList.get(value);
        }

        static {
            valueList = new HashMap<Integer, UpdateResult>();
            for (UpdateResult result : UpdateResult.values()) {
                valueList.put(result.value, result);
            }
        }
    }
}

