/*
 * Decompiled with CFR 0.152.
 */
package com.github.zathrus_writer.commandsex.helpers;

import com.github.zathrus_writer.commandsex.CommandsEX;
import com.github.zathrus_writer.commandsex.helpers.Commands;
import com.github.zathrus_writer.commandsex.helpers.LogHelper;
import com.github.zathrus_writer.commandsex.helpers.Nicknames;
import com.github.zathrus_writer.commandsex.helpers.Utils;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class Teleportation {
    public static List<String> tpaallRequests = new ArrayList<String>();
    public static List<String> tpaRequests = new ArrayList<String>();
    public static List<String> tpahereRequests = new ArrayList<String>();

    public static Boolean tp_common(CommandSender sender, String[] args, String command, String alias) {
        Player player = (Player)sender;
        if (!Utils.checkCommandSpam(player, "tp-" + command, new Integer[0]).booleanValue()) {
            int aLength = args.length;
            if (aLength > 2) {
                LogHelper.showWarning("pTooManyArguments", sender);
                return true;
            }
            if (aLength == 0) {
                Commands.showCommandHelpAndUsage(sender, "cex_" + command, alias);
                return true;
            }
            Player player1 = Bukkit.getServer().getPlayer(args[0]);
            Player player2 = aLength > 1 ? Bukkit.getServer().getPlayer(args[1]) : player;
            if (player1 == null || player2 == null) {
                LogHelper.showWarning("invalidPlayer", sender);
                return true;
            }
            if (player1.getName().equals(player2.getName())) {
                LogHelper.showWarning("tpCannotTeleportSelf", sender);
                return true;
            }
            if (command.equals("tp") && aLength == 1 || command.equals("tpto")) {
                Teleportation.delayedTeleport(player2, player1.getLocation(), new Runnable[0]);
                LogHelper.showInfo("tpTeleport#####[ " + Nicknames.getNick(player1.getName()), sender, new ChatColor[0]);
            } else if (command.equals("tphere") || command.equals("tp") && aLength > 1) {
                Teleportation.delayedTeleport(player1, player2.getLocation(), new Runnable[0]);
                LogHelper.showInfo("[" + Nicknames.getNick(player1.getName()) + " #####tpHereTeleport", sender, new ChatColor[0]);
            }
        }
        return true;
    }

    public static void refreshMapChunk(Location l) {
        World world = l.getWorld();
        Chunk chunk = world.getChunkAt(l);
        int chunkx = chunk.getX();
        int chunkz = chunk.getZ();
        world.refreshChunk(chunkx, chunkz);
    }

    public static void delayedTeleport(Player p, Location l, Runnable ... r) {
        Teleportation.refreshMapChunk(l);
        CommandsEX.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)CommandsEX.plugin, (Runnable)new DelayedTeleport(p, l, r), 2L);
    }

    public static class DelayedTeleport
    implements Runnable {
        private Player p;
        private Location l;
        private Runnable r;

        public DelayedTeleport(Player p, Location l, Runnable ... r) {
            this.p = p;
            this.l = l;
            this.r = r.length > 0 ? r[0] : null;
        }

        @Override
        public void run() {
            this.p.getWorld().playEffect(this.p.getLocation(), Effect.SMOKE, 20);
            this.p.teleport(this.l);
            this.p.getWorld().playEffect(this.p.getLocation(), Effect.SMOKE, 20);
            if (this.r != null) {
                CommandsEX.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)CommandsEX.plugin, this.r, 40L);
            }
        }
    }
}

