/*
 * Decompiled with CFR 0.152.
 */
package com.github.zathrus_writer.commandsex.helpers;

import com.github.zathrus_writer.commandsex.CommandsEX;
import com.github.zathrus_writer.commandsex.Vault;
import com.github.zathrus_writer.commandsex.helpers.LogHelper;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class Permissions {
    public static Boolean checkPermEx(CommandSender sender, String perm) {
        if (CommandsEX.vaultPresent.booleanValue() && sender instanceof Player) {
            return Vault.checkPerm((Player)sender, perm);
        }
        return sender.hasPermission(perm);
    }

    public static Boolean checkPerms(CommandSender sender, String ... customPerm) {
        Boolean hasPerms = false;
        int cLength = customPerm.length;
        if (cLength == 1) {
            hasPerms = Permissions.checkPermEx(sender, customPerm[0]);
        } else if (cLength > 1) {
            if (customPerm[0].equals("OR") || customPerm[0].equals("AND")) {
                for (int i = 1; i < cLength; ++i) {
                    hasPerms = Permissions.checkPermEx(sender, customPerm[i]);
                    if (customPerm[0].equals("OR") && hasPerms.booleanValue()) {
                        return true;
                    }
                    if (!customPerm[0].equals("AND") || hasPerms.booleanValue()) continue;
                    LogHelper.showWarning("insufficientPerms", sender);
                    return false;
                }
            } else {
                hasPerms = false;
                LogHelper.logSevere("[CommandsEX] Custom permissions check failed.");
                LogHelper.logDebug("Method: '" + Thread.currentThread().getStackTrace()[3].getMethodName() + "' (first parameter is not one of: AND/OR - it was '" + customPerm[0] + "')");
            }
        } else {
            hasPerms = false;
            LogHelper.logSevere("[CommandsEX] Permissions check failed.");
            LogHelper.logDebug("Method: '" + Thread.currentThread().getStackTrace()[3].getMethodName() + "' (no paramaters seem to be present)");
        }
        if (!hasPerms.booleanValue()) {
            LogHelper.showWarning("insufficientPerms", sender);
        }
        return hasPerms;
    }

    public static Boolean addPerm(Player p, String perm) {
        if (CommandsEX.vaultPresent.booleanValue() && Vault.permsEnabled().booleanValue()) {
            Vault.perms.playerAdd(p, perm);
        }
        Permissions.checkPerms((CommandSender)p, perm);
        return true;
    }

    public static Boolean addPerm(String world, String player, String perm) {
        if (CommandsEX.vaultPresent.booleanValue() && Vault.permsEnabled().booleanValue()) {
            Vault.perms.playerAdd(world, player, perm);
        }
        return true;
    }
}

