/*
 * Decompiled with CFR 0.152.
 */
package com.github.zathrus_writer.commandsex.helpers;

import com.github.zathrus_writer.commandsex.CommandsEX;
import com.github.zathrus_writer.commandsex.SQLManager;
import com.github.zathrus_writer.commandsex.helpers.LogHelper;
import com.github.zathrus_writer.commandsex.helpers.Utils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;

public class Nicknames
implements Listener {
    public static HashMap<String, String> nicknames = new HashMap();

    public Nicknames() {
        CommandsEX.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)CommandsEX.plugin);
    }

    public static void init(CommandsEX plugin) {
        block4: {
            new Nicknames();
            if (!CommandsEX.sqlEnabled.booleanValue()) {
                return;
            }
            SQLManager.query((SQLManager.sqlType.equals("mysql") ? "" : "BEGIN; ") + "CREATE TABLE IF NOT EXISTS " + SQLManager.prefix + "nicknames (player_name varchar(32) NOT NULL, nickname varchar(32) NOT NULL)" + (SQLManager.sqlType.equals("mysql") ? " ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='stores players nicknames'" : "; COMMIT;"), new Object[0]);
            try {
                ResultSet res = SQLManager.query_res("SELECT player_name, nickname FROM " + SQLManager.prefix + "nicknames", new Object[0]);
                while (res.next()) {
                    nicknames.put(res.getString("player_name"), res.getString("nickname"));
                }
                res.close();
            }
            catch (SQLException ex) {
                if (!CommandsEX.getConf().getBoolean("debugMode")) break block4;
                ex.printStackTrace();
            }
        }
        CommandsEX.onDisableFunctions.add("com.github.zathrus_writer.commandsex.helpers.Nicknames#####onDisable");
    }

    public static void onDisable(CommandsEX p) {
        Nicknames.saveNicks();
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent e) {
        Player player = e.getPlayer();
        Nicknames.showNick(player);
    }

    public static boolean setNick(String pName, String nickname) {
        if (nicknames.containsValue(nickname)) {
            return false;
        }
        if (nicknames.containsKey(pName)) {
            nicknames.remove(pName);
        }
        nicknames.put(pName, nickname);
        Player player = Bukkit.getPlayerExact((String)pName);
        if (player != null) {
            Nicknames.showNick(player);
        }
        return true;
    }

    public static boolean showNick(Player player) {
        String pName = player.getName();
        String rNick = Nicknames.getRealNick(pName);
        int count = 0;
        for (String n : nicknames.values()) {
            if (!n.equals(rNick)) continue;
            ++count;
        }
        if (count > 1) {
            LogHelper.logWarning("Could not set nickname for " + pName);
            LogHelper.logWarning("Another player is already using that nickname");
            return false;
        }
        String nickname = Nicknames.getNick(pName);
        player.setDisplayName(nickname + ChatColor.RESET);
        player.setPlayerListName(nickname.length() > 16 ? nickname.substring(0, 15) : nickname);
        return true;
    }

    public static void resetNick(Player player) {
        String pName = player.getName();
        if (nicknames.containsKey(pName)) {
            nicknames.remove(pName);
        }
        player.setDisplayName(pName);
        player.setPlayerListName(pName);
    }

    public static void resetNick(String pName) {
        if (nicknames.containsKey(pName)) {
            nicknames.remove(pName);
        }
    }

    public static String getNick(Player player) {
        return Nicknames.getNick(player.getName());
    }

    public static String getNick(String pName) {
        String nickname = pName;
        if (nicknames.containsKey(pName)) {
            nickname = Utils.replaceChatColors(CommandsEX.getConf().getString("nicknamePrefix")) + Nicknames.getRealNick(pName) + ChatColor.RESET;
        }
        return nickname;
    }

    public static String getRealNick(String pName) {
        String nickname = pName;
        if (nicknames.containsKey(pName)) {
            nickname = Utils.replaceChatColors(nicknames.get(pName));
        }
        return nickname;
    }

    public static void saveNicks() {
        if (CommandsEX.sqlEnabled.booleanValue()) {
            block10: {
                try {
                    ResultSet rs = SQLManager.query_res("SELECT player_name FROM " + SQLManager.prefix + "nicknames ", new Object[0]);
                    if (rs != null) {
                        while (rs.next()) {
                            String rsName = rs.getString("player_name");
                            if (nicknames.containsKey(rsName)) continue;
                            SQLManager.query("DELETE FROM " + SQLManager.prefix + "nicknames WHERE player_name = ?", rsName);
                        }
                    }
                    rs.close();
                }
                catch (SQLException ex) {
                    if (!CommandsEX.getConf().getBoolean("debugMode")) break block10;
                    ex.printStackTrace();
                }
            }
            for (String pName : nicknames.keySet()) {
                String nickname = nicknames.get(pName);
                try {
                    ResultSet res = SQLManager.query_res("SELECT player_name, nickname FROM " + SQLManager.prefix + "nicknames WHERE player_name = ?", pName);
                    if (!res.next()) {
                        SQLManager.query("INSERT " + (SQLManager.sqlType.equals("mysql") ? "" : "OR REPLACE ") + "INTO " + SQLManager.prefix + "nicknames (player_name, nickname) SELECT ? AS player_name, ? AS nickname", pName, nickname);
                    } else {
                        SQLManager.query("UPDATE " + SQLManager.prefix + "nicknames SET player_name = ?, nickname = ? WHERE player_name = ?", pName, nickname, pName);
                    }
                    res.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }
}

