/*
 * Decompiled with CFR 0.152.
 */
package com.github.zathrus_writer.commandsex.helpers;

import com.github.zathrus_writer.commandsex.CommandsEX;
import com.github.zathrus_writer.commandsex.Language;
import java.util.logging.Logger;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;

public class LogHelper {
    public static final Logger LOGGER = Logger.getLogger("Minecraft");

    public static void logWarning(String msg) {
        LOGGER.warning(msg);
    }

    public static void logSevere(String msg) {
        LOGGER.severe(msg);
    }

    public static void logInfo(String msg) {
        LOGGER.info(msg);
    }

    public static void logDebug(String msg) {
        if (CommandsEX.getConf().getBoolean("debugMode")) {
            LOGGER.info(msg);
        }
    }

    public static void showInfo(String msg, CommandSender sender, ChatColor ... altColor) {
        if (msg.contains("#####")) {
            String[] s;
            String buildup = "";
            for (String sx : s = msg.split("#####")) {
                buildup = sx.startsWith("[") ? buildup + sx.substring(1) : buildup + Language._(sx, sender.getName());
            }
            sender.sendMessage((altColor.length > 0 ? altColor[0] : ChatColor.AQUA) + buildup);
        } else {
            sender.sendMessage((altColor.length > 0 ? altColor[0] : ChatColor.AQUA) + (msg.startsWith("[") ? msg.substring(1) : Language._(msg, sender.getName())));
        }
    }

    public static void showInfos(CommandSender sender, String ... msg) {
        for (String s : msg) {
            LogHelper.showInfo(s, sender, new ChatColor[0]);
        }
    }

    public static void showWarning(String msg, CommandSender sender) {
        if (msg.contains("#####")) {
            String[] s;
            String buildup = "";
            for (String sx : s = msg.split("#####")) {
                buildup = sx.startsWith("[") ? buildup + sx.substring(1) : buildup + Language._(sx, sender.getName());
            }
            sender.sendMessage(ChatColor.RED + buildup);
        } else {
            sender.sendMessage(ChatColor.RED + (msg.startsWith("[") ? msg.substring(1) : Language._(msg, sender.getName())));
        }
    }

    public static void showWarnings(CommandSender sender, String ... msg) {
        for (String s : msg) {
            LogHelper.showWarning(s, sender);
        }
    }
}

