/*
 * Decompiled with CFR 0.152.
 */
package com.github.zathrus_writer.commandsex.helpers;

import com.github.zathrus_writer.commandsex.CommandsEX;
import com.github.zathrus_writer.commandsex.Language;
import com.github.zathrus_writer.commandsex.helpers.LogHelper;
import com.github.zathrus_writer.commandsex.helpers.scripting.BadScriptException;
import com.github.zathrus_writer.commandsex.helpers.scripting.EchoControl;
import com.github.zathrus_writer.commandsex.helpers.scripting.ReplacementCommand;
import com.github.zathrus_writer.commandsex.helpers.scripting.ReplacementPair;
import com.github.zathrus_writer.commandsex.helpers.scripting.ReplacementRandom;
import com.github.zathrus_writer.commandsex.helpers.scripting.ReplacementScript;
import com.github.zathrus_writer.commandsex.helpers.scripting.ReplacementString;
import com.github.zathrus_writer.commandsex.helpers.scripting.ScriptBlock;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;

public class FileListHelper {
    public static HashMap<String, ScriptBlock> aliasedScripts = null;

    public static void checkListFile(File listfile, String defresource) {
        if (!listfile.exists()) {
            LogHelper.logInfo("[CommandsEX] " + Language._("fileListHelperCouldNotFind", "") + " " + listfile.getName() + ", " + Language._("fileListHelperCreatingDefaultFile", "") + ".");
            try {
                int len;
                InputStream in = CommandsEX.plugin.getResource(defresource);
                FileOutputStream out = new FileOutputStream(listfile);
                byte[] buf = new byte[1024];
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
                in.close();
                out.close();
            }
            catch (IOException e) {
                LogHelper.logWarning("[CommandsEX] " + Language._("fileListHelperIOException", ""));
                LogHelper.logDebug("Message: " + e.getMessage() + ", cause: " + e.getCause());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ReplacementPair> loadListFromFile(File listfile, MatchingContext mc) {
        BufferedReader br = null;
        ArrayList<ReplacementPair> ret = new ArrayList<ReplacementPair>();
        try {
            String line;
            if (!listfile.canRead()) {
                throw new FileNotFoundException();
            }
            br = new BufferedReader(new FileReader(listfile));
            Pattern p = Pattern.compile("\\/(.+)\\/(\\w*)\\s*=(\\w?)=([>{])\\s*(?:\\[([^\\]]+)\\])?\\s*(.*)");
            int success = 0;
            int lineno = 0;
            block25: while ((line = br.readLine()) != null) {
                Matcher m;
                ++lineno;
                if (line.isEmpty() || line.startsWith("#")) continue;
                Boolean sameOutputCase = false;
                if (line.contains("{cc}")) {
                    line = line.replace("{cc}", "");
                    sameOutputCase = true;
                }
                Boolean caseSensitive = true;
                if (line.contains("{ci}")) {
                    line = line.replace("{ci}", "");
                    caseSensitive = false;
                }
                if ((m = p.matcher(line)).matches()) {
                    ReplacementCommand rp = null;
                    ++success;
                    String regex = m.group(1);
                    String opts = m.group(2);
                    String methodstr = m.group(3);
                    String scriptmode = m.group(4);
                    String replopts = m.group(5);
                    String repl = m.group(6);
                    if (scriptmode.equals(">")) {
                        int method = 32;
                        if (!methodstr.isEmpty()) {
                            method = methodstr.charAt(0);
                        }
                        block8 : switch (method) {
                            case 99: {
                                rp = new ReplacementCommand(regex, repl, replopts, caseSensitive, sameOutputCase);
                                break;
                            }
                            case 114: {
                                if (mc != MatchingContext.Chat) {
                                    LogHelper.logWarning(Language._("cmdRandomReplacementNotAllowed", "") + lineno);
                                    continue block25;
                                }
                                rp = new ReplacementRandom(regex, repl, caseSensitive, sameOutputCase);
                                break;
                            }
                            default: {
                                switch (mc) {
                                    case Command: {
                                        rp = new ReplacementCommand(regex, repl, replopts, caseSensitive, sameOutputCase);
                                        break block8;
                                    }
                                    case Chat: {
                                        rp = new ReplacementString(regex, repl, replopts, caseSensitive, sameOutputCase);
                                    }
                                }
                                break;
                            }
                        }
                    } else if (scriptmode.equals("{")) {
                        try {
                            int blockDepth = 1;
                            ArrayList<String> scriptblock = new ArrayList<String>();
                            while ((line = br.readLine()) != null) {
                                ++lineno;
                                if (line.isEmpty() || line.startsWith("#")) continue;
                                if (line.trim().equals("{")) {
                                    ++blockDepth;
                                } else if (line.trim().equals("}")) {
                                    --blockDepth;
                                }
                                if (blockDepth == 0) {
                                    ScriptBlock block = new ScriptBlock(scriptblock, repl);
                                    rp = new ReplacementScript(regex, block, replopts, caseSensitive, sameOutputCase);
                                    FileListHelper.setScriptForAlias(repl, block);
                                    break;
                                }
                                scriptblock.add(line);
                            }
                            if (blockDepth != 0) {
                                throw new BadScriptException("EOF reached before end of script reached! Please re-balance braces!");
                            }
                        }
                        catch (BadScriptException e) {
                            LogHelper.logWarning("[CommandsEX] " + Language._("fileListHelperBadScript", "") + lineno);
                            LogHelper.logDebug("Message: " + e.getMessage() + ", cause: " + e.getCause());
                        }
                    }
                    rp.setRegexOptions(opts);
                    ret.add((ReplacementPair)rp);
                    continue;
                }
                LogHelper.logWarning("[CommandsEX] " + Language._("line", "") + " " + lineno + " " + Language._("fileListHelperLineBadFormat", ""));
            }
            LogHelper.logDebug("[CommandsEX] Successfully imported " + success + " patterns from " + listfile.getName());
        }
        catch (FileNotFoundException ex) {
            LogHelper.logWarning("[CommandsEX] " + Language._("fileListHelperCouldNotOpenRepl", "") + ": " + listfile.getName());
            LogHelper.logDebug("Message: " + ex.getMessage() + ", cause: " + ex.getCause());
        }
        catch (IOException e) {
            LogHelper.logWarning("[CommandsEX] " + Language._("fileListHelperIOException2", "") + listfile.getName());
            LogHelper.logDebug("Message: " + e.getMessage() + ", cause: " + e.getCause());
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException e) {}
        }
        return ret;
    }

    public static void setScriptForAlias(String alias, ScriptBlock script) {
        if (alias == null || alias.isEmpty()) {
            return;
        }
        aliasedScripts.put(alias, script);
    }

    public static ScriptBlock getScript(String alias) {
        return aliasedScripts.get(alias);
    }

    public class EchoCommand
    implements CommandExecutor {
        public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
            if (args.length == 0) {
                return false;
            }
            StringBuffer sb = new StringBuffer(args[0]);
            for (int i = 1; i < args.length; ++i) {
                sb.append(' ').append(args[i]);
            }
            ((EchoControl)sender).getWrappedSender().sendMessage(sb.toString());
            return true;
        }
    }

    public static enum MatchingContext {
        Chat,
        Command;

    }
}

