/*
 * Decompiled with CFR 0.152.
 */
package com.github.zathrus_writer.commandsex.helpers;

import java.util.Arrays;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class ExperienceManager {
    private static int hardMaxLevel = 100000;
    private static int[] xpRequiredForNextLevel;
    private static int[] xpTotalToReachLevel;
    private final String playerName;

    public static int getHardMaxLevel() {
        return hardMaxLevel;
    }

    public static void setHardMaxLevel(int hardMaxLevel) {
        ExperienceManager.hardMaxLevel = hardMaxLevel;
    }

    private static void initLookupTables(int maxLevel) {
        xpRequiredForNextLevel = new int[maxLevel];
        xpTotalToReachLevel = new int[maxLevel];
        ExperienceManager.xpTotalToReachLevel[0] = 0;
        int incr = 17;
        for (int i = 1; i < xpTotalToReachLevel.length; ++i) {
            ExperienceManager.xpRequiredForNextLevel[i - 1] = incr;
            ExperienceManager.xpTotalToReachLevel[i] = xpTotalToReachLevel[i - 1] + incr;
            if (i >= 30) {
                incr += 7;
                continue;
            }
            if (i < 16) continue;
            incr += 3;
        }
        ExperienceManager.xpRequiredForNextLevel[ExperienceManager.xpRequiredForNextLevel.length - 1] = incr;
    }

    private static int calculateLevelForExp(int exp) {
        int level = 0;
        int curExp = 7;
        int incr = 10;
        while (curExp <= exp) {
            curExp += incr;
            incr += ++level % 2 == 0 ? 3 : 4;
        }
        return level;
    }

    public ExperienceManager(Player player) {
        this.playerName = player.getName();
        this.getPlayer();
    }

    public Player getPlayer() {
        Player p = Bukkit.getPlayer((String)this.playerName);
        if (p == null) {
            throw new IllegalStateException("Player " + this.playerName + " is not online");
        }
        return p;
    }

    public void changeExp(int amt) {
        this.setExp(this.getCurrentExp(), amt);
    }

    public void setExp(int amt) {
        this.setExp(0, amt);
    }

    private void setExp(int base, int amt) {
        int newLvl;
        Player player;
        int curLvl;
        int xp = base + amt;
        if (xp < 0) {
            xp = 0;
        }
        if ((curLvl = (player = this.getPlayer()).getLevel()) != (newLvl = this.getLevelForExp(xp))) {
            player.setLevel(newLvl);
        }
        float pct = (float)(xp - this.getXpForLevel(newLvl)) / (float)xpRequiredForNextLevel[newLvl];
        player.setExp(pct);
    }

    public int getCurrentExp() {
        Player player = this.getPlayer();
        int lvl = player.getLevel();
        int cur = this.getXpForLevel(lvl) + Math.round((float)xpRequiredForNextLevel[lvl] * player.getExp());
        return cur;
    }

    public boolean hasExp(int amt) {
        return this.getCurrentExp() >= amt;
    }

    public int getLevelForExp(int exp) {
        int pos;
        if (exp <= 0) {
            return 0;
        }
        if (exp > xpTotalToReachLevel[xpTotalToReachLevel.length - 1]) {
            int newMax = ExperienceManager.calculateLevelForExp(exp) * 2;
            if (newMax > hardMaxLevel) {
                throw new IllegalArgumentException("Level for exp " + exp + " > hard max level " + hardMaxLevel);
            }
            ExperienceManager.initLookupTables(newMax);
        }
        return (pos = Arrays.binarySearch(xpTotalToReachLevel, exp)) < 0 ? -pos - 2 : pos;
    }

    public int getXpForLevel(int level) {
        if (level > hardMaxLevel) {
            throw new IllegalArgumentException("Level " + level + " > hard max level " + hardMaxLevel);
        }
        if (level >= xpTotalToReachLevel.length) {
            ExperienceManager.initLookupTables(level * 2);
        }
        return xpTotalToReachLevel[level];
    }

    static {
        ExperienceManager.initLookupTables(25);
    }
}

