/*
 * Decompiled with CFR 0.152.
 */
package com.github.zathrus_writer.commandsex.helpers;

import com.github.zathrus_writer.commandsex.CommandsEX;
import com.github.zathrus_writer.commandsex.helpers.LogHelper;
import com.github.zathrus_writer.commandsex.helpers.Utils;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.mail.EmailAttachment;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.HtmlEmail;
import org.apache.commons.mail.MultiPartEmail;
import org.apache.commons.mail.SimpleEmail;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;

public class Email {
    static HashMap<String, SimpleEmail> simpleEmail = new HashMap();
    static HashMap<String, MultiPartEmail> multiEmail = new HashMap();
    static HashMap<String, HtmlEmail> htmlEmail = new HashMap();

    public static void compose(CommandSender sender, String type) {
        if (Email.inProgress(sender.getName())) {
            LogHelper.showWarning("emailAlreadyInProgress", sender);
            return;
        }
        if (type.equalsIgnoreCase("simple")) {
            SimpleEmail email = new SimpleEmail();
            email.setHostName(CommandsEX.getConf().getString("Email.Host"));
            try {
                email.setFrom(CommandsEX.getConf().getString("Email.From"));
            }
            catch (EmailException e) {
                Email.sendErrorMessage(sender, (Exception)((Object)e));
                return;
            }
            email = Email.setAuthentication(email);
            simpleEmail.put(sender.getName(), email);
        } else if (type.equalsIgnoreCase("attachment")) {
            MultiPartEmail email = new MultiPartEmail();
            email.setHostName(CommandsEX.getConf().getString("Email.Host"));
            try {
                email.setFrom(CommandsEX.getConf().getString("Email.From"));
            }
            catch (EmailException e) {
                Email.sendErrorMessage(sender, (Exception)((Object)e));
                return;
            }
            email = Email.setAuthentication(email);
            multiEmail.put(sender.getName(), email);
        } else if (type.equalsIgnoreCase("html")) {
            HtmlEmail email = new HtmlEmail();
            email.setHostName(CommandsEX.getConf().getString("Email.Host"));
            try {
                email.setFrom(CommandsEX.getConf().getString("Email.From"));
            }
            catch (EmailException e) {
                Email.sendErrorMessage(sender, (Exception)((Object)e));
                return;
            }
            email = Email.setAuthentication(email);
            htmlEmail.put(sender.getName(), email);
        }
        LogHelper.showInfo("emailCreated", sender, new ChatColor[0]);
    }

    public static void delete(CommandSender sender) {
        if (Email.inProgress(sender.getName())) {
            LogHelper.showWarning("emailNotInProgressDelete", sender);
        } else {
            switch (Email.getCurrentEmail(sender.getName())) {
                case "simple": {
                    simpleEmail.remove(sender.getName());
                    LogHelper.showInfo("emailDeleted", sender, new ChatColor[0]);
                }
                case "multi": {
                    multiEmail.remove(sender.getName());
                    LogHelper.showInfo("emailDeleted", sender, new ChatColor[0]);
                }
                case "html": {
                    multiEmail.remove(sender.getName());
                    LogHelper.showInfo("emailDeleted", sender, new ChatColor[0]);
                }
            }
            LogHelper.showWarning("emailNotInProgressDelete", sender);
        }
    }

    public static void edit(CommandSender sender) {
        if (Email.inProgress(sender.getName())) {
            LogHelper.showInfo("emailEditOptions", sender, new ChatColor[0]);
        } else {
            LogHelper.showWarning("emailNotInProgressEdit", sender);
        }
    }

    public static void editSubject(CommandSender sender, String[] args) {
        if (Email.inProgress(sender.getName())) {
            if (args.length == 1) {
                LogHelper.showWarning("emailValueMissing", sender);
            } else {
                switch (Email.getCurrentEmail(sender.getName())) {
                    case "simple": {
                        Email.editSubjectSimple(sender, args);
                    }
                    case "multi": {
                        Email.editSubjectMulti(sender, args);
                    }
                    case "html": {
                        Email.editSubjectHTML(sender, args);
                    }
                }
                LogHelper.showWarning("emailNotInProgressEdit", sender);
            }
        } else {
            LogHelper.showWarning("emailNotInProgressEdit", sender);
        }
    }

    static void editSubjectSimple(CommandSender sender, String[] args) {
        SimpleEmail email = simpleEmail.get(sender.getName());
        email.setSubject(Utils.implode(args, " "));
        LogHelper.showInfo("emailSubjectSet", sender, new ChatColor[0]);
        simpleEmail.put(sender.getName(), email);
    }

    static void editSubjectMulti(CommandSender sender, String[] args) {
        MultiPartEmail email = multiEmail.get(sender.getName());
        email.setSubject(Utils.implode(args, " "));
        LogHelper.showInfo("emailSubjectSet", sender, new ChatColor[0]);
        multiEmail.put(sender.getName(), email);
    }

    static void editSubjectHTML(CommandSender sender, String[] args) {
        HtmlEmail email = htmlEmail.get(sender.getName());
        email.setSubject(Utils.implode(args, " "));
        LogHelper.showInfo("emailSubjectSet", sender, new ChatColor[0]);
        htmlEmail.put(sender.getName(), email);
    }

    public static void editMessage(CommandSender sender, String[] args) {
        if (Email.inProgress(sender.getName())) {
            if (args.length == 1) {
                LogHelper.showWarning("emailValueMissing", sender);
            } else {
                switch (Email.getCurrentEmail(sender.getName())) {
                    case "simple": {
                        Email.editMessageSimple(sender, args);
                    }
                    case "multi": {
                        Email.editMessageMulti(sender, args);
                    }
                    case "html": {
                        LogHelper.showWarning("emailEditErrorMessage", sender);
                    }
                }
                LogHelper.showWarning("emailNotInProgressEdit", sender);
            }
        } else {
            LogHelper.showWarning("emailNotInProgressEdit", sender);
        }
    }

    static void editMessageSimple(CommandSender sender, String[] args) {
        SimpleEmail email = simpleEmail.get(sender.getName());
        try {
            email.setMsg(Utils.implode(args, " "));
        }
        catch (EmailException e) {
            Email.sendErrorMessage(sender, (Exception)((Object)e));
            return;
        }
        LogHelper.showInfo("emailMessageSet", sender, new ChatColor[0]);
        simpleEmail.put(sender.getName(), email);
    }

    static void editMessageMulti(CommandSender sender, String[] args) {
        MultiPartEmail email = multiEmail.get(sender.getName());
        try {
            email.setMsg(Utils.implode(args, " "));
        }
        catch (EmailException e) {
            Email.sendErrorMessage(sender, (Exception)((Object)e));
            return;
        }
        LogHelper.showInfo("emailMessageSet", sender, new ChatColor[0]);
        multiEmail.put(sender.getName(), email);
    }

    public static void recipient(CommandSender sender, String email, RecipientAction action) {
        if (Email.inProgress(sender.getName())) {
            if (email == null || email.isEmpty()) {
                LogHelper.showWarning("emailValueMissing", sender);
            } else {
                switch (Email.getCurrentEmail(sender.getName())) {
                    case "simple": {
                        Email.editRecipientSimple(sender, email, action);
                    }
                    case "multi": {
                        Email.editRecipientMulti(sender, email, action);
                    }
                    case "html": {
                        Email.editRecipientHtml(sender, email, action);
                    }
                }
                LogHelper.showWarning("emailNotInProgressEdit", sender);
            }
        } else {
            LogHelper.showWarning("emailNotInProgressEdit", sender);
        }
    }

    static void editRecipientSimple(CommandSender sender, String emailString, RecipientAction action) {
        SimpleEmail email = simpleEmail.get(sender.getName());
        switch (action) {
            case ADD: {
                try {
                    email.addTo(emailString);
                }
                catch (EmailException e) {
                    Email.sendErrorMessage(sender, (Exception)((Object)e));
                    return;
                }
                LogHelper.showInfo("emailRecipientAdd", sender, new ChatColor[0]);
            }
            case ADD_BCC: {
                try {
                    email.addBcc(emailString);
                }
                catch (EmailException e) {
                    Email.sendErrorMessage(sender, (Exception)((Object)e));
                    return;
                }
                LogHelper.showInfo("emailRecipientAdd", sender, new ChatColor[0]);
            }
            case ADD_CC: {
                try {
                    email.addCc(emailString);
                }
                catch (EmailException e) {
                    Email.sendErrorMessage(sender, (Exception)((Object)e));
                    return;
                }
                LogHelper.showInfo("emailRecipientAdd", sender, new ChatColor[0]);
            }
            case DELETE: {
                try {
                    email = Email.removeRecipient(email, emailString);
                }
                catch (EmailException e) {
                    Email.sendErrorMessage(sender, (Exception)((Object)e));
                    return;
                }
                LogHelper.showInfo("emailRecipientDeleted", sender, new ChatColor[0]);
            }
            case LIST: {
                sender.sendMessage(Email.composeReadableRecipientList(email));
            }
        }
        simpleEmail.put(sender.getName(), email);
    }

    static void editRecipientMulti(CommandSender sender, String emailString, RecipientAction action) {
        MultiPartEmail email = multiEmail.get(sender.getName());
        switch (action) {
            case ADD: {
                try {
                    email.addTo(emailString);
                }
                catch (EmailException e) {
                    Email.sendErrorMessage(sender, (Exception)((Object)e));
                    return;
                }
                LogHelper.showInfo("emailRecipientAdd", sender, new ChatColor[0]);
                return;
            }
            case ADD_BCC: {
                try {
                    email.addBcc(emailString);
                }
                catch (EmailException e) {
                    Email.sendErrorMessage(sender, (Exception)((Object)e));
                    return;
                }
                LogHelper.showInfo("emailRecipientAdd", sender, new ChatColor[0]);
                return;
            }
            case ADD_CC: {
                try {
                    email.addCc(emailString);
                }
                catch (EmailException e) {
                    Email.sendErrorMessage(sender, (Exception)((Object)e));
                    return;
                }
                LogHelper.showInfo("emailRecipientAdd", sender, new ChatColor[0]);
                return;
            }
            case DELETE: {
                try {
                    email = Email.removeRecipient(email, emailString);
                }
                catch (EmailException e) {
                    Email.sendErrorMessage(sender, (Exception)((Object)e));
                    return;
                }
                LogHelper.showInfo("emailRecipientDeleted", sender, new ChatColor[0]);
                return;
            }
            case LIST: {
                sender.sendMessage(Email.composeReadableRecipientList(email));
            }
        }
        multiEmail.put(sender.getName(), email);
    }

    static void editRecipientHtml(CommandSender sender, String emailString, RecipientAction action) {
        HtmlEmail email = htmlEmail.get(sender.getName());
        switch (action) {
            case ADD: {
                try {
                    email.addTo(emailString);
                }
                catch (EmailException e) {
                    Email.sendErrorMessage(sender, (Exception)((Object)e));
                    return;
                }
                LogHelper.showInfo("emailRecipientAdd", sender, new ChatColor[0]);
                return;
            }
            case ADD_BCC: {
                try {
                    email.addBcc(emailString);
                }
                catch (EmailException e) {
                    Email.sendErrorMessage(sender, (Exception)((Object)e));
                    return;
                }
                LogHelper.showInfo("emailRecipientAdd", sender, new ChatColor[0]);
                return;
            }
            case ADD_CC: {
                try {
                    email.addCc(emailString);
                }
                catch (EmailException e) {
                    Email.sendErrorMessage(sender, (Exception)((Object)e));
                    return;
                }
                LogHelper.showInfo("emailRecipientAdd", sender, new ChatColor[0]);
                return;
            }
            case DELETE: {
                try {
                    email = Email.removeRecipient(email, emailString);
                }
                catch (EmailException e) {
                    Email.sendErrorMessage(sender, (Exception)((Object)e));
                    return;
                }
                LogHelper.showInfo("emailRecipientDeleted", sender, new ChatColor[0]);
                return;
            }
            case LIST: {
                sender.sendMessage(Email.composeReadableRecipientList(email));
            }
        }
        htmlEmail.put(sender.getName(), email);
    }

    public static void send(CommandSender sender, String[] args) {
        if (Email.inProgress(sender.getName())) {
            switch (Email.getCurrentEmail(sender.getName())) {
                case "simple": {
                    LogHelper.showInfo("emailMessageSending", sender, new ChatColor[0]);
                    try {
                        simpleEmail.get(sender.getName()).send();
                    }
                    catch (EmailException e) {
                        Email.sendErrorMessage(sender, (Exception)((Object)e));
                        return;
                    }
                    LogHelper.showInfo("emailMessageSent", sender, new ChatColor[0]);
                    simpleEmail.remove(sender.getName());
                }
                case "multi": {
                    LogHelper.showInfo("emailMessageSending", sender, new ChatColor[0]);
                    try {
                        multiEmail.get(sender.getName()).send();
                    }
                    catch (EmailException e) {
                        Email.sendErrorMessage(sender, (Exception)((Object)e));
                        return;
                    }
                    LogHelper.showInfo("emailMessageSent", sender, new ChatColor[0]);
                    multiEmail.remove(sender.getName());
                }
                case "html": {
                    LogHelper.showInfo("emailMessageSending", sender, new ChatColor[0]);
                    try {
                        htmlEmail.get(sender.getName()).send();
                    }
                    catch (EmailException e) {
                        Email.sendErrorMessage(sender, (Exception)((Object)e));
                        return;
                    }
                    LogHelper.showInfo("emailMessageSent", sender, new ChatColor[0]);
                    htmlEmail.remove(sender.getName());
                }
            }
            LogHelper.showWarning("emailNotInProgressEdit", sender);
        } else {
            LogHelper.showWarning("emailNotInProgressEdit", sender);
        }
    }

    public static void setBounceback(CommandSender sender, String bounceback) {
        if (Email.inProgress(sender.getName())) {
            if (bounceback == null || bounceback.isEmpty()) {
                LogHelper.showWarning("emailValueMissing", sender);
            } else {
                switch (Email.getCurrentEmail(sender.getName())) {
                    case "simple": {
                        Email.setBouncebackSimple(sender, bounceback);
                    }
                    case "multi": {
                        Email.setBouncebackMulti(sender, bounceback);
                    }
                    case "html": {
                        Email.setBouncebackHtml(sender, bounceback);
                    }
                }
                LogHelper.showWarning("emailNotInProgressEdit", sender);
            }
        } else {
            LogHelper.showWarning("emailNotInProgressEdit", sender);
        }
    }

    static void setBouncebackSimple(CommandSender sender, String bounceback) {
        SimpleEmail email = simpleEmail.get(sender.getName());
        email.setBounceAddress(bounceback);
        LogHelper.showInfo("emailBouncebackSet", sender, new ChatColor[0]);
        simpleEmail.put(sender.getName(), email);
    }

    static void setBouncebackMulti(CommandSender sender, String bounceback) {
        MultiPartEmail email = multiEmail.get(sender.getName());
        email.setBounceAddress(bounceback);
        LogHelper.showInfo("emailBouncebackSet", sender, new ChatColor[0]);
        multiEmail.put(sender.getName(), email);
    }

    static void setBouncebackHtml(CommandSender sender, String bounceback) {
        HtmlEmail email = htmlEmail.get(sender.getName());
        email.setBounceAddress(bounceback);
        LogHelper.showInfo("emailBouncebackSet", sender, new ChatColor[0]);
        htmlEmail.put(sender.getName(), email);
    }

    public static void addAttachment(CommandSender sender, String fileName, String name, String description) {
        if (Email.inProgress(sender.getName())) {
            switch (Email.getCurrentEmail(sender.getName())) {
                case "simple": {
                    LogHelper.showWarning("emailAttachmentNotAllowed", sender);
                    return;
                }
                case "multi": {
                    break;
                }
                case "html": {
                    LogHelper.showWarning("emailAttachmentNotAllowed", sender);
                    return;
                }
                default: {
                    LogHelper.showWarning("emailNotInProgressEdit", sender);
                    return;
                }
            }
            MultiPartEmail email = multiEmail.get(sender.getName());
            EmailAttachment attachment = new EmailAttachment();
            attachment.setPath(CommandsEX.plugin.getDataFolder() + "Email Attachments" + File.separator + fileName);
            attachment.setName(name);
            attachment.setDescription(description);
            try {
                email.attach(attachment);
            }
            catch (EmailException e) {
                Email.sendErrorMessage(sender, (Exception)((Object)e));
                return;
            }
            LogHelper.showInfo("emailAttachmentSet", sender, new ChatColor[0]);
            multiEmail.put(sender.getName(), email);
        } else {
            LogHelper.showWarning("emailNotInProgressEdit", sender);
        }
    }

    public static void setHtmlMessage(CommandSender sender, String[] args) {
        if (Email.inProgress(sender.getName())) {
            switch (Email.getCurrentEmail(sender.getName())) {
                case "simple": {
                    LogHelper.showWarning("emailHtmlNotAllowed", sender);
                    return;
                }
                case "multi": {
                    LogHelper.showWarning("emailHtmlNotAllowed", sender);
                    return;
                }
                case "html": {
                    break;
                }
                default: {
                    LogHelper.showWarning("emailNotInProgressEdit", sender);
                    return;
                }
            }
            HtmlEmail email = htmlEmail.get(sender.getName());
            try {
                email.setHtmlMsg(Utils.implode(args, " "));
            }
            catch (EmailException e) {
                Email.sendErrorMessage(sender, (Exception)((Object)e));
                return;
            }
            LogHelper.showWarning("emailHtmlMessageSet", sender);
            htmlEmail.put(sender.getName(), email);
        } else {
            LogHelper.showWarning("emailNotInProgressEdit", sender);
        }
    }

    public static void setNonHtmlMessage(CommandSender sender, String[] args) {
        if (Email.inProgress(sender.getName())) {
            switch (Email.getCurrentEmail(sender.getName())) {
                case "simple": {
                    LogHelper.showWarning("emailNonHtmlNotAllowed", sender);
                    return;
                }
                case "multi": {
                    LogHelper.showWarning("emailNonHtmlNotAllowed", sender);
                    return;
                }
                case "html": {
                    break;
                }
                default: {
                    LogHelper.showWarning("emailNotInProgressEdit", sender);
                    return;
                }
            }
            HtmlEmail email = htmlEmail.get(sender.getName());
            try {
                email.setMsg(Utils.implode(args, " "));
            }
            catch (EmailException e) {
                Email.sendErrorMessage(sender, (Exception)((Object)e));
                return;
            }
            LogHelper.showWarning("emailNonHtmlMessageSet", sender);
            htmlEmail.put(sender.getName(), email);
        } else {
            LogHelper.showWarning("emailNotInProgressEdit", sender);
        }
    }

    static SimpleEmail setAuthentication(SimpleEmail email) {
        if (!CommandsEX.getConf().getString("Email.Username").isEmpty() || !CommandsEX.getConf().getString("Email.Password").isEmpty()) {
            email.setAuthentication(CommandsEX.getConf().getString("Email.Username"), CommandsEX.getConf().getString("Email.Password"));
        }
        return email;
    }

    static MultiPartEmail setAuthentication(MultiPartEmail email) {
        if (!CommandsEX.getConf().getString("Email.Username").isEmpty() || !CommandsEX.getConf().getString("Email.Password").isEmpty()) {
            email.setAuthentication(CommandsEX.getConf().getString("Email.Username"), CommandsEX.getConf().getString("Email.Password"));
        }
        return email;
    }

    static HtmlEmail setAuthentication(HtmlEmail email) {
        if (!CommandsEX.getConf().getString("Email.Username").isEmpty() || !CommandsEX.getConf().getString("Email.Password").isEmpty()) {
            email.setAuthentication(CommandsEX.getConf().getString("Email.Username"), CommandsEX.getConf().getString("Email.Password"));
        }
        return email;
    }

    static boolean inProgress(String senderName) {
        if (simpleEmail.containsKey(senderName)) {
            return true;
        }
        if (multiEmail.containsKey(senderName)) {
            return true;
        }
        return htmlEmail.containsKey(senderName);
    }

    static String getCurrentEmail(String senderName) {
        if (simpleEmail.containsKey(senderName)) {
            return "simple";
        }
        if (multiEmail.containsKey(senderName)) {
            return "multi";
        }
        if (htmlEmail.containsKey(senderName)) {
            return "html";
        }
        return null;
    }

    static void sendErrorMessage(CommandSender sender, Exception e) {
        LogHelper.showWarning("emailException#####" + e.getMessage(), sender);
    }

    static SimpleEmail removeRecipient(SimpleEmail email, String emailToRemove) throws EmailException {
        List<String> to = Utils.noGenericTypeToStringType(email.getToAddresses());
        List<String> cc = Utils.noGenericTypeToStringType(email.getCcAddresses());
        List<String> bcc = Utils.noGenericTypeToStringType(email.getBccAddresses());
        if (to.contains(emailToRemove)) {
            to.remove(emailToRemove);
            email.setTo(to);
        } else if (cc.contains(emailToRemove)) {
            cc.remove(emailToRemove);
            email.setCc(cc);
        } else if (bcc.contains(emailToRemove)) {
            bcc.remove(emailToRemove);
            email.setBcc(bcc);
        }
        return email;
    }

    static MultiPartEmail removeRecipient(MultiPartEmail email, String emailToRemove) throws EmailException {
        List<String> to = Utils.noGenericTypeToStringType(email.getToAddresses());
        List<String> cc = Utils.noGenericTypeToStringType(email.getCcAddresses());
        List<String> bcc = Utils.noGenericTypeToStringType(email.getBccAddresses());
        if (to.contains(emailToRemove)) {
            to.remove(emailToRemove);
            email.setTo(to);
        } else if (cc.contains(emailToRemove)) {
            cc.remove(emailToRemove);
            email.setCc(cc);
        } else if (bcc.contains(emailToRemove)) {
            bcc.remove(emailToRemove);
            email.setBcc(bcc);
        }
        return email;
    }

    static HtmlEmail removeRecipient(HtmlEmail email, String emailToRemove) throws EmailException {
        List<String> to = Utils.noGenericTypeToStringType(email.getToAddresses());
        List<String> cc = Utils.noGenericTypeToStringType(email.getCcAddresses());
        List<String> bcc = Utils.noGenericTypeToStringType(email.getBccAddresses());
        if (to.contains(emailToRemove)) {
            to.remove(emailToRemove);
            email.setTo(to);
        } else if (cc.contains(emailToRemove)) {
            cc.remove(emailToRemove);
            email.setCc(cc);
        } else if (bcc.contains(emailToRemove)) {
            bcc.remove(emailToRemove);
            email.setBcc(bcc);
        }
        return email;
    }

    static String[] composeReadableRecipientList(SimpleEmail email) {
        String[] RRL = new String[]{"To: ", "Cc: ", "Bcc: "};
        Iterator<String> toIT = Utils.noGenericTypeToStringType(email.getToAddresses()).iterator();
        Iterator<String> ccIT = Utils.noGenericTypeToStringType(email.getCcAddresses()).iterator();
        Iterator<String> bccIT = Utils.noGenericTypeToStringType(email.getBccAddresses()).iterator();
        while (toIT.hasNext()) {
            RRL[0] = RRL[0] + toIT.next() + ", ";
        }
        while (ccIT.hasNext()) {
            RRL[1] = RRL[1] + ccIT.next() + ", ";
        }
        while (bccIT.hasNext()) {
            RRL[2] = RRL[2] + bccIT.next() + ", ";
        }
        return RRL;
    }

    static String[] composeReadableRecipientList(MultiPartEmail email) {
        String[] RRL = new String[]{"To: ", "Cc: ", "Bcc: "};
        Iterator<String> toIT = Utils.noGenericTypeToStringType(email.getToAddresses()).iterator();
        Iterator<String> ccIT = Utils.noGenericTypeToStringType(email.getCcAddresses()).iterator();
        Iterator<String> bccIT = Utils.noGenericTypeToStringType(email.getBccAddresses()).iterator();
        while (toIT.hasNext()) {
            RRL[0] = RRL[0] + toIT.next() + ", ";
        }
        while (ccIT.hasNext()) {
            RRL[1] = RRL[1] + ccIT.next() + ", ";
        }
        while (bccIT.hasNext()) {
            RRL[2] = RRL[2] + bccIT.next() + ", ";
        }
        return RRL;
    }

    static String[] composeReadableRecipientList(HtmlEmail email) {
        String[] RRL = new String[]{"To: ", "Cc: ", "Bcc: "};
        Iterator toIT = email.getToAddresses().iterator();
        Iterator ccIT = email.getCcAddresses().iterator();
        Iterator bccIT = email.getBccAddresses().iterator();
        while (toIT.hasNext()) {
            RRL[0] = RRL[0] + (String)toIT.next() + ", ";
        }
        while (ccIT.hasNext()) {
            RRL[1] = RRL[1] + (String)ccIT.next() + ", ";
        }
        while (bccIT.hasNext()) {
            RRL[2] = RRL[2] + (String)bccIT.next() + ", ";
        }
        return RRL;
    }

    public static enum RecipientAction {
        ADD,
        ADD_CC,
        ADD_BCC,
        LIST,
        DELETE;

    }
}

