/*
 * Decompiled with CFR 0.152.
 */
package com.github.zathrus_writer.commandsex.helpers;

import com.github.zathrus_writer.commandsex.CommandsEX;
import com.github.zathrus_writer.commandsex.SQLManager;
import com.github.zathrus_writer.commandsex.helpers.LogHelper;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;

public class Econ {
    public static HashMap<String, Double> balances = new HashMap();
    public static double defaultBalance = CommandsEX.getConf().getDouble("economy.defaultBalance");

    public static void init(CommandsEX plugin) {
        if (!CommandsEX.sqlEnabled.booleanValue()) {
            return;
        }
        SQLManager.query((SQLManager.sqlType.equals("mysql") ? "" : "BEGIN; ") + "CREATE TABLE IF NOT EXISTS " + SQLManager.prefix + "economy (player_name varchar(32), balance double precision)" + (SQLManager.sqlType.equals("mysql") ? " ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='stores player balances'" : "; COMMIT;"), new Object[0]);
        ResultSet rs = SQLManager.query_res("SELECT * FROM " + SQLManager.prefix + "economy", new Object[0]);
        try {
            while (rs.next()) {
                balances.put(rs.getString("player_name"), rs.getDouble("balance"));
            }
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        CommandsEX.onDisableFunctions.add("com.github.zathrus_writer.commandsex.helpers.Econ#####onDisable");
    }

    public static void onDisable(CommandsEX p) {
        Econ.saveDatabase();
    }

    public static void saveDatabase() {
        Econ.purgeAccounts();
        for (String account : balances.keySet()) {
            ResultSet rs;
            double balance = balances.get(account);
            if (balance != defaultBalance) {
                try {
                    rs = SQLManager.query_res("SELECT * FROM " + SQLManager.prefix + "economy WHERE player_name = ?", account);
                    if (!rs.next()) {
                        SQLManager.query("INSERT " + (SQLManager.sqlType.equals("mysql") ? "" : "OR REPLACE ") + "INTO " + SQLManager.prefix + "economy (player_name, balance) SELECT ? AS player_name, ? AS balance", account, balance);
                    }
                    rs.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            try {
                rs = SQLManager.query_res("SELECT player_name FROM " + SQLManager.prefix + "economy WHERE player_name = ? AND balance <> ?", account, balance);
                if (rs.next()) {
                    SQLManager.query("UPDATE " + SQLManager.prefix + "economy SET balance = ? WHERE player_name = ?", balance, account);
                }
                rs.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        try {
            ResultSet rs = SQLManager.query_res("SELECT player_name FROM " + SQLManager.prefix + "economy", new Object[0]);
            while (rs.next()) {
                String player = rs.getString("player_name");
                if (balances.containsKey(player)) continue;
                SQLManager.query("DELETE FROM " + SQLManager.prefix + "economy WHERE player_name = ?", player);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        SQLManager.query("DELETE FROM " + SQLManager.prefix + "economy WHERE balance = ?", defaultBalance);
    }

    public static int purgeAccounts() {
        int count = 0;
        for (String account : balances.keySet()) {
            double balance = balances.get(account);
            if (balance != defaultBalance) continue;
            balances.remove(account);
            ++count;
        }
        LogHelper.logInfo("Successfully purged " + count + " economy accounts with default balance");
        return count;
    }
}

