/*
 * Decompiled with CFR 0.152.
 */
package com.github.zathrus_writer.commandsex.helpers;

import com.github.zathrus_writer.commandsex.CexCommands;
import com.github.zathrus_writer.commandsex.CommandsEX;
import com.github.zathrus_writer.commandsex.Language;
import com.github.zathrus_writer.commandsex.helpers.LogHelper;
import java.lang.reflect.Method;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommandYamlParser;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class Commands
implements CommandExecutor {
    private CommandsEX plugin;

    public Commands(CommandsEX plug) {
        this.plugin = plug;
    }

    public boolean onCommand(CommandSender sender, Command command, String cmdAlias, String[] args) {
        String cmd = command.getName().toLowerCase();
        String alias = cmdAlias.toLowerCase();
        if (CommandsEX.getConf().getBoolean("pluginMetrics")) {
            int value = 1;
            if (CommandsEX.commandUses.containsKey(cmd)) {
                value = CommandsEX.commandUses.get(cmd);
                CommandsEX.commandUses.remove(cmd);
            }
            CommandsEX.commandUses.put(cmd, value);
        }
        if (sender instanceof Player && this.plugin.getConfig().getBoolean("logCommands")) {
            String arguments = " ";
            if (args.length > 0) {
                for (String a : args) {
                    arguments = arguments + a + " ";
                }
            }
            LogHelper.logInfo("[" + sender.getName() + "] /" + (!alias.equals("") ? alias : cmd) + arguments);
        }
        try {
            if (cmd.equals("cex")) {
                return this.command_cex(sender, cmdAlias, args);
            }
            Class[] proto = new Class[]{CommandSender.class, String.class, String[].class};
            Object[] params = new Object[]{sender, cmdAlias, args};
            Class<?> c = Class.forName("com.github.zathrus_writer.commandsex.commands.Command_" + cmd);
            Method method = c.getDeclaredMethod("run", proto);
            Object ret = method.invoke(null, params);
            return Boolean.TRUE.equals(ret);
        }
        catch (Throwable e) {
            LogHelper.showWarning("internalError", sender);
            LogHelper.logSevere("[CommandsEX] Couldn't handle function call '" + cmd + "'");
            LogHelper.logDebug("Message: " + e.getMessage() + ", cause: " + e.getCause());
            if (CommandsEX.getConf().getBoolean("debugMode")) {
                e.printStackTrace();
            }
            return true;
        }
    }

    public Boolean command_cex(CommandSender sender, String alias, String[] args) {
        return CexCommands.handle_cex(this.plugin, sender, alias, args);
    }

    public static void showCommandHelpAndUsage(CommandSender sender, String commandName, String alias) {
        List cmdList = PluginCommandYamlParser.parse((Plugin)CommandsEX.plugin);
        Boolean cmdFound = false;
        for (int i = 0; i <= cmdList.size() - 1; ++i) {
            if (!((Command)cmdList.get(i)).getLabel().equals(commandName)) continue;
            cmdFound = true;
            String usage = "";
            Language.noMissingLangWarning = true;
            String description = Language._("cmdDesc_" + alias, sender.getName());
            if (description.equals("cmdDesc_" + alias)) {
                description = Language._("cmdDesc_" + commandName, sender.getName());
                if (description.equals("cmdDesc_" + commandName)) {
                    sender.sendMessage(ChatColor.WHITE + ((Command)cmdList.get(i)).getDescription());
                    usage = Language._("cmdDesc_" + commandName + "_usage", sender.getName());
                    if (usage.equals("cmdDesc_" + commandName + "_usage")) {
                        usage = "";
                    }
                } else {
                    sender.sendMessage(ChatColor.WHITE + description);
                    usage = Language._("cmdDesc_" + commandName + "_usage", sender.getName());
                    if (usage.equals("cmdDesc_" + commandName + "_usage")) {
                        usage = "";
                    }
                }
            } else {
                sender.sendMessage(ChatColor.WHITE + description);
                usage = Language._("cmdDesc_" + alias + "_usage", sender.getName());
                if (usage.equals("cmdDesc_" + alias + "_usage")) {
                    usage = "";
                }
            }
            Language.noMissingLangWarning = false;
            if (usage.equals("")) {
                usage = ((Command)cmdList.get(i)).getUsage();
            }
            if ((usage = usage.replaceAll("<command>", alias)).contains("\n") || usage.contains("\r")) {
                usage = usage.replaceAll("\r", "\n").replaceAll("\n\n", "");
                String[] splitted = usage.split("\n");
                sender.sendMessage(ChatColor.RED + Language._("usage", sender.getName()) + ":");
                for (String rVal : splitted) {
                    sender.sendMessage(ChatColor.RED + rVal);
                }
                continue;
            }
            sender.sendMessage(ChatColor.RED + Language._("usage", sender.getName()) + ": " + usage);
        }
        if (!cmdFound.booleanValue()) {
            LogHelper.showWarning("commandDescriptionNotFound", sender);
            LogHelper.logWarning(Language._("commandDescriptionNotFound", "") + ": " + commandName + ", alias = " + alias);
        }
    }
}

