/*
 * Decompiled with CFR 0.152.
 */
package com.github.zathrus_writer.commandsex.helpers;

import com.github.zathrus_writer.commandsex.CommandsEX;
import com.github.zathrus_writer.commandsex.helpers.Home;
import com.github.zathrus_writer.commandsex.helpers.LogHelper;
import com.github.zathrus_writer.commandsex.helpers.Warps;
import com.google.common.io.Files;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Calendar;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;

public class CommandBookConverter {
    public static void init(CommandsEX plugin) {
        File cmdBkWarps;
        File oldConversionsFolder = new File(plugin.getDataFolder() + "/old-conversions");
        if (!oldConversionsFolder.exists()) {
            oldConversionsFolder.mkdir();
        }
        Calendar cal = Calendar.getInstance();
        String dateString = cal.get(1) + "" + cal.get(2) + "" + cal.get(5) + "" + cal.get(11) + "" + cal.get(12) + "" + cal.get(13) + "" + cal.get(14);
        File cmdBkHomes = new File(plugin.getDataFolder() + "/convert/CommandBookHomes.csv");
        if (cmdBkHomes.exists()) {
            if (CommandsEX.sqlEnabled.booleanValue()) {
                try {
                    LogHelper.logInfo("Started CommandBook Home Conversion");
                    File oldConversion = new File(plugin.getDataFolder() + "/old-conversions/CommandBookHomes" + dateString + ".csv");
                    BufferedReader CSVFile = new BufferedReader(new FileReader(cmdBkHomes.getAbsolutePath()));
                    String dataRow = CSVFile.readLine();
                    while (dataRow != null) {
                        String[] dataArray = dataRow.split(",");
                        for (int i = 0; i < dataArray.length; ++i) {
                            dataArray[i] = dataArray[i].substring(1, dataArray[i].length() - 1);
                        }
                        String homeName = dataArray[0];
                        String ownerName = dataArray[2];
                        String worldName = dataArray[1];
                        World world = Bukkit.getWorld((String)worldName);
                        if (world == null) {
                            LogHelper.logWarning("Home for " + ownerName + " could not be converted from CommandBook -> CommandsEX");
                            LogHelper.logWarning("ERROR: World " + worldName + " does not exist, skipping...");
                        } else {
                            double x = Double.parseDouble(dataArray[3]);
                            double y = Double.parseDouble(dataArray[4]);
                            double z = Double.parseDouble(dataArray[5]);
                            float yaw = Float.parseFloat(dataArray[6]);
                            float pitch = Float.parseFloat(dataArray[7]);
                            Location l = new Location(world, x, y, z, yaw, pitch);
                            if (homeName.equals(ownerName)) {
                                Home.setHome((String)ownerName, (Location)l);
                                LogHelper.logInfo("Set home for " + ownerName + " successfully!");
                            } else {
                                LogHelper.logInfo("Home named " + homeName + " is not the primary home of " + ownerName);
                                if (CommandsEX.loadedClasses.contains("Command_cex_warp")) {
                                    LogHelper.logInfo("Instead we will convert this home to a warp, owned by " + ownerName);
                                    Warps.createWarp((String)ownerName, (String)homeName, (boolean)false, (Location)l);
                                    LogHelper.logInfo("Successfully created private warp called " + homeName + " for " + ownerName);
                                } else {
                                    LogHelper.logInfo("Warps have not been enabled, therefore we cannot convert this home to a warp");
                                }
                            }
                        }
                        dataRow = CSVFile.readLine();
                    }
                    CSVFile.close();
                    Files.copy((File)cmdBkHomes, (File)oldConversion);
                    cmdBkHomes.delete();
                    LogHelper.logInfo("CommandBook Home Conversion Finished, CommandBookHomes.csv moved to old-conversions");
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                LogHelper.logWarning("Cannot convert CommandBook warps because the SQL database is disabled");
                LogHelper.logWarning("Please enable it in the config");
            }
        }
        if ((cmdBkWarps = new File(plugin.getDataFolder() + "/convert/CommandBookWarps.csv")).exists()) {
            if (CommandsEX.sqlEnabled.booleanValue()) {
                try {
                    LogHelper.logInfo("Started CommandBook Warp Conversion");
                    File oldConversion = new File(plugin.getDataFolder() + "/old-conversions/CommandBookWarps" + dateString + ".csv");
                    BufferedReader CSVFile = new BufferedReader(new FileReader(cmdBkWarps.getAbsolutePath()));
                    String dataRow = CSVFile.readLine();
                    while (dataRow != null) {
                        String[] dataArray = dataRow.split(",");
                        for (int i = 0; i < dataArray.length; ++i) {
                            dataArray[i] = dataArray[i].substring(1, dataArray[i].length() - 1);
                        }
                        String warpName = dataArray[0];
                        String ownerName = dataArray[2];
                        String worldName = dataArray[1];
                        World world = Bukkit.getWorld((String)worldName);
                        if (world == null) {
                            LogHelper.logWarning("Warp named " + warpName + " could not be converted from CommandBook -> CommandsEX");
                            LogHelper.logWarning("ERROR: World " + worldName + " does not exist, skipping...");
                        } else {
                            double x = Double.parseDouble(dataArray[3]);
                            double y = Double.parseDouble(dataArray[4]);
                            double z = Double.parseDouble(dataArray[5]);
                            float yaw = Float.parseFloat(dataArray[6]);
                            float pitch = Float.parseFloat(dataArray[7]);
                            Location l = new Location(world, x, y, z, yaw, pitch);
                            Warps.createWarp((String)ownerName, (String)warpName, (boolean)true, (Location)l);
                            LogHelper.logInfo("Created warp " + warpName + " successfully!");
                        }
                        dataRow = CSVFile.readLine();
                    }
                    CSVFile.close();
                    Files.copy((File)cmdBkWarps, (File)oldConversion);
                    cmdBkWarps.delete();
                    LogHelper.logInfo("CommandBook Warp Conversion Finished, CommandBookWarps.csv moved to old-conversions");
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                LogHelper.logWarning("Cannot convert CommandBook warps because the SQL database is disabled");
                LogHelper.logWarning("Please enable it in the config");
            }
        }
    }
}

