/*
 * Decompiled with CFR 0.152.
 */
package com.github.zathrus_writer.commandsex.helpers;

import com.github.zathrus_writer.commandsex.CommandsEX;
import com.github.zathrus_writer.commandsex.SQLManager;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;

public class Authentication {
    private static final int ITERATION_NUMBER = 1000;
    private static final char[] ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
    private static int[] toInt = new int[128];

    public static void init(CommandsEX plugin) {
        SQLManager.query((SQLManager.sqlType.equals("mysql") ? "" : "BEGIN; ") + "CREATE TABLE IF NOT EXISTS " + SQLManager.prefix + "userinfo (id_user integer " + (SQLManager.sqlType.equals("mysql") ? "unsigned " : "") + "NOT NULL" + (SQLManager.sqlType.equals("mysql") ? " AUTO_INCREMENT" : "") + ", player_name varchar(32) NOT NULL" + (SQLManager.sqlType.equals("mysql") ? "" : " COLLATE 'NOCASE'") + ", creation_date " + (SQLManager.sqlType.equals("mysql") ? "TIMESTAMP" : "DATETIME") + " NOT NULL DEFAULT CURRENT_TIMESTAMP, expiration_date " + (SQLManager.sqlType.equals("mysql") ? "TIMESTAMP" : "DATETIME") + " NOT NULL DEFAULT '0000-00-00 00:00:00', creator VARCHAR(32) NOT NULL, reason VARCHAR(120) DEFAULT NULL, active BOOLEAN NOT NULL DEFAULT '1', PRIMARY KEY (id_ban)" + (SQLManager.sqlType.equals("mysql") ? ", KEY player_name (player_name), KEY expiration_date (expiration_date), KEY active (active)" : "") + ")" + (SQLManager.sqlType.equals("mysql") ? " ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='holds ban records for players along with reasons and ban expiration times' AUTO_INCREMENT=1" : "") + (SQLManager.sqlType.equals("mysql") ? "" : "; CREATE INDEX IF NOT EXISTS player_name ON " + SQLManager.prefix + "bans (player_name); CREATE INDEX IF NOT EXISTS expiration_date ON " + SQLManager.prefix + "bans (expiration_date); CREATE INDEX IF NOT EXISTS active ON " + SQLManager.prefix + "bans (active); COMMIT;"), new Object[0]);
        for (int i = 0; i < ALPHABET.length; ++i) {
            Authentication.toInt[Authentication.ALPHABET[i]] = i;
        }
    }

    public boolean authenticate(Connection con, String login, String password) throws SQLException, NoSuchAlgorithmException {
        boolean authenticated = false;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            String salt;
            String digest;
            boolean userExist = true;
            if (login == null || password == null) {
                userExist = false;
                login = "";
                password = "";
            }
            ps = con.prepareStatement("SELECT PASSWORD, SALT FROM CREDENTIAL WHERE LOGIN = ?");
            ps.setString(1, login);
            rs = ps.executeQuery();
            if (rs.next()) {
                digest = rs.getString("PASSWORD");
                salt = rs.getString("SALT");
                if (digest == null || salt == null) {
                    throw new SQLException("Database inconsistant Salt or Digested Password altered");
                }
                if (rs.next()) {
                    throw new SQLException("Database inconsistent two CREDENTIALS with the same LOGIN");
                }
            } else {
                digest = "000000000000000000000000000=";
                salt = "00000000000=";
                userExist = false;
            }
            byte[] bDigest = Authentication.base64ToByte(digest);
            byte[] bSalt = Authentication.base64ToByte(salt);
            byte[] proposedDigest = this.getHash(1000, password, bSalt);
            boolean bl = Arrays.equals(proposedDigest, bDigest) && userExist;
            this.close(rs);
            this.close(ps);
            return bl;
        }
        catch (IOException ex) {
            try {
                throw new SQLException("Database inconsistant Salt or Digested Password altered");
            }
            catch (Throwable throwable) {
                this.close(rs);
                this.close(ps);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createUser(Connection con, String login, String password) throws SQLException, NoSuchAlgorithmException, UnsupportedEncodingException {
        PreparedStatement ps;
        block4: {
            ps = null;
            if (login == null || password == null || login.length() > 100) break block4;
            SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
            byte[] bSalt = new byte[8];
            random.nextBytes(bSalt);
            byte[] bDigest = this.getHash(1000, password, bSalt);
            String sDigest = Authentication.byteToBase64(bDigest);
            String sSalt = Authentication.byteToBase64(bSalt);
            ps = con.prepareStatement("INSERT INTO CREDENTIAL (LOGIN, PASSWORD, SALT) VALUES (?,?,?)");
            ps.setString(1, login);
            ps.setString(2, sDigest);
            ps.setString(3, sSalt);
            ps.executeUpdate();
            boolean bl = true;
            this.close(ps);
            return bl;
        }
        try {
            boolean bl = false;
            return bl;
        }
        finally {
            this.close(ps);
        }
    }

    public byte[] getHash(int iterationNb, String password, byte[] salt) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest digest = MessageDigest.getInstance("SHA-1");
        digest.reset();
        digest.update(salt);
        byte[] input = digest.digest(password.getBytes("UTF-8"));
        for (int i = 0; i < iterationNb; ++i) {
            digest.reset();
            input = digest.digest(input);
        }
        return input;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void creerTable(Connection con) throws SQLException {
        Statement st = null;
        try {
            st = con.createStatement();
            st.execute((SQLManager.sqlType.equals("mysql") ? "" : "BEGIN;") + "CREATE TABLE CREDENTIAL (LOGIN VARCHAR(100) PRIMARY KEY, PASSWORD VARCHAR(32) NOT NULL, SALT VARCHAR(32) NOT NULL)");
        }
        finally {
            this.close(st);
        }
    }

    public void close(Statement ps) {
        if (ps != null) {
            try {
                ps.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public void close(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static byte[] base64ToByte(String data) throws IOException {
        int delta = data.endsWith("==") ? 2 : (data.endsWith("=") ? 1 : 0);
        byte[] buffer = new byte[data.length() * 3 / 4 - delta];
        int mask = 255;
        int index = 0;
        for (int i = 0; i < data.length(); i += 4) {
            int c0 = toInt[data.charAt(i)];
            int c1 = toInt[data.charAt(i + 1)];
            buffer[index++] = (byte)((c0 << 2 | c1 >> 4) & mask);
            if (index >= buffer.length) {
                return buffer;
            }
            int c2 = toInt[data.charAt(i + 2)];
            buffer[index++] = (byte)((c1 << 4 | c2 >> 2) & mask);
            if (index >= buffer.length) {
                return buffer;
            }
            int c3 = toInt[data.charAt(i + 3)];
            buffer[index++] = (byte)((c2 << 6 | c3) & mask);
        }
        return buffer;
    }

    public static String byteToBase64(byte[] data) {
        int size = data.length;
        char[] ar = new char[(size + 2) / 3 * 4];
        int a = 0;
        int i = 0;
        while (i < size) {
            byte b0 = data[i++];
            byte b1 = i < size ? data[i++] : (byte)0;
            byte b2 = i < size ? data[i++] : (byte)0;
            int mask = 63;
            ar[a++] = ALPHABET[b0 >> 2 & mask];
            ar[a++] = ALPHABET[(b0 << 4 | (b1 & 0xFF) >> 4) & mask];
            ar[a++] = ALPHABET[(b1 << 2 | (b2 & 0xFF) >> 6) & mask];
            ar[a++] = ALPHABET[b2 & mask];
        }
        switch (size % 3) {
            case 1: {
                ar[--a] = 61;
            }
            case 2: {
                ar[--a] = 61;
            }
        }
        return new String(ar);
    }
}

