/*
 * Decompiled with CFR 0.152.
 */
package com.github.zathrus_writer.commandsex.handlers;

import com.github.zathrus_writer.commandsex.CommandsEX;
import com.github.zathrus_writer.commandsex.SQLManager;
import com.github.zathrus_writer.commandsex.helpers.BlockLogging;
import com.github.zathrus_writer.commandsex.helpers.LogHelper;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockFadeEvent;
import org.bukkit.event.block.BlockFormEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.LeavesDecayEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.painting.PaintingBreakByEntityEvent;
import org.bukkit.event.painting.PaintingPlaceEvent;
import org.bukkit.plugin.Plugin;

public class Handler_blocklogging
implements Listener {
    public Handler_blocklogging() {
        if (CommandsEX.getConf().getBoolean("BlockloggingEnabled")) {
            CommandsEX.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)CommandsEX.plugin);
            SQLManager.query("CREATE TABLE IF NOT EXISTS " + SQLManager.prefix + "BlockLogging (ID int NOT NULL AUTO_INCREMENT, PlayerName varchar(255) NOT_NULL, Action varchar(255) NOT_NULL, Time varchar(255) NOT_NULL, Block int NOT_NULL, World varchar(255) NOT_NULL, Location varchar(255) NOT_NULL, PRIMARY KEY (ID) )", new Object[0]);
            LogHelper.logInfo("loggingEnabled");
            BlockLogging.enabled = true;
            BlockLogging.table = SQLManager.prefix + "BlockLogging";
        }
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent e) {
        BlockLogging.logEvent(e.getPlayer().getName(), BlockLogging.BlockLoggingAction.BLOCK_BREAK, e.getBlock(), e.getBlock().getWorld(), e.getBlock().getLocation());
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent e) {
        BlockLogging.logEvent(e.getPlayer().getName(), BlockLogging.BlockLoggingAction.BLOCK_PLACE, e.getBlockPlaced(), e.getBlock().getWorld(), e.getBlock().getLocation());
    }

    @EventHandler
    public void onSignChange(SignChangeEvent e) {
        BlockLogging.logEvent(e.getPlayer().getName(), BlockLogging.BlockLoggingAction.SIGN_CHANGE, e.getBlock(), e.getBlock().getWorld(), e.getBlock().getLocation());
    }

    @EventHandler
    public void onBlockForm(BlockFormEvent e) {
        BlockLogging.logEvent("ENVIROMENTAL_CHANGE", BlockLogging.BlockLoggingAction.BLOCK_FORM, e.getBlock(), e.getBlock().getWorld(), e.getBlock().getLocation());
    }

    @EventHandler
    public void onBlockFade(BlockFadeEvent e) {
        BlockLogging.logEvent("ENVIROMENTAL_CHANGE", BlockLogging.BlockLoggingAction.BLOCK_FADE, e.getBlock(), e.getBlock().getWorld(), e.getBlock().getLocation());
    }

    @EventHandler
    public void onBlockBurn(BlockBurnEvent e) {
        BlockLogging.logEvent("ENVIROMENTAL_CHANGE", BlockLogging.BlockLoggingAction.BLOCK_BURN, e.getBlock(), e.getBlock().getWorld(), e.getBlock().getLocation());
    }

    @EventHandler
    public void onLeafDecay(LeavesDecayEvent e) {
        BlockLogging.logEvent("ENVIROMENTAL_CHANGE", BlockLogging.BlockLoggingAction.LEAF_DECAY, e.getBlock(), e.getBlock().getWorld(), e.getBlock().getLocation());
    }

    @EventHandler
    public void onEntityExplode(EntityExplodeEvent e) {
        for (Block b : e.blockList().toArray(new Block[0])) {
            BlockLogging.logEvent("ENVIROMENTAL_CHANGE", BlockLogging.BlockLoggingAction.ENTITY_EXPLOSION, b, b.getWorld(), b.getLocation());
        }
    }

    @EventHandler
    public void onPaintingBreak(PaintingBreakByEntityEvent e) {
        BlockLogging.logEvent(((Player)e.getRemover()).getName(), BlockLogging.BlockLoggingAction.PAINTING_BREAK, e.getPainting(), e.getPainting().getWorld(), e.getPainting().getLocation());
    }

    @EventHandler
    public void onPaintingPlace(PaintingPlaceEvent e) {
        BlockLogging.logEvent(e.getPlayer().getName(), BlockLogging.BlockLoggingAction.PAINTING_PLACE, e.getPainting(), e.getPainting().getWorld(), e.getPainting().getLocation());
    }

    @EventHandler
    public void onEntityChangeBlock(EntityChangeBlockEvent e) {
        if (e.getTo() == Material.AIR) {
            BlockLogging.logEvent("ENVIROMENTAL_CHANGE", BlockLogging.BlockLoggingAction.ENDERMAN_PICKUP, e.getBlock(), e.getBlock().getWorld(), e.getBlock().getLocation());
        } else {
            BlockLogging.logEvent("ENVIROMENTAL_CHANGE", BlockLogging.BlockLoggingAction.ENDERMAN_PLACE, e.getBlock(), e.getBlock().getWorld(), e.getBlock().getLocation());
        }
    }
}

