/*
 * Decompiled with CFR 0.152.
 */
package com.github.zathrus_writer.commandsex.commands;

import com.github.zathrus_writer.commandsex.CombatTag;
import com.github.zathrus_writer.commandsex.helpers.ClosestMatches;
import com.github.zathrus_writer.commandsex.helpers.Commands;
import com.github.zathrus_writer.commandsex.helpers.LogHelper;
import com.github.zathrus_writer.commandsex.helpers.Nicknames;
import com.github.zathrus_writer.commandsex.helpers.Spawning;
import com.github.zathrus_writer.commandsex.helpers.Teleportation;
import com.github.zathrus_writer.commandsex.helpers.Utils;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class Command_cex_tpworld {
    public static Boolean run(CommandSender sender, String alias, String[] args) {
        List<World> matches;
        Player target;
        if (sender instanceof Player && Utils.checkCommandSpam((Player)sender, "cex_tpworld", new Integer[0]).booleanValue()) {
            return true;
        }
        if (args.length < 1 || args.length > 2) {
            Commands.showCommandHelpAndUsage(sender, "cex_tpworld", alias);
            return true;
        }
        if (args.length == 2) {
            target = Bukkit.getPlayer((String)args[1]);
            if (target != sender && !sender.hasPermission("cex.tpworld.others")) {
                LogHelper.showWarning("tpWorldOthersNoPerm", sender);
                return true;
            }
            if (target == null) {
                LogHelper.showWarning("invalidPlayer", sender);
            }
        } else if (sender instanceof Player) {
            target = (Player)sender;
            if (CombatTag.isInCombat(target)) {
                LogHelper.showWarning("combatTagCannotDo", (CommandSender)target);
                return true;
            }
        } else {
            Commands.showCommandHelpAndUsage(sender, "cex_tpworld", alias);
            return true;
        }
        if ((matches = ClosestMatches.intellWorld(args[0], target.getWorld())).size() < 1) {
            LogHelper.showWarning("invalidWorld", sender);
            return true;
        }
        World world = matches.get(0);
        Teleportation.delayedTeleport(target, Spawning.getWorldSpawn((World)world), new Runnable[0]);
        if (sender == target) {
            LogHelper.showInfo("tpWorldSelf#####[" + world.getName(), sender, new ChatColor[0]);
        } else {
            LogHelper.showInfo("tpLocSuccess#####[" + Nicknames.getNick(target.getName()) + " #####to#####[" + world.getName(), sender, new ChatColor[0]);
            LogHelper.showInfo("[" + Nicknames.getNick(sender.getName()) + " #####tpWorldOtherNotify#####[" + world.getName(), (CommandSender)target, new ChatColor[0]);
        }
        return true;
    }
}

