/*
 * Decompiled with CFR 0.152.
 */
package com.github.zathrus_writer.commandsex.commands;

import com.github.zathrus_writer.commandsex.CombatTag;
import com.github.zathrus_writer.commandsex.helpers.Commands;
import com.github.zathrus_writer.commandsex.helpers.LogHelper;
import com.github.zathrus_writer.commandsex.helpers.PlayerHelper;
import com.github.zathrus_writer.commandsex.helpers.Teleportation;
import com.github.zathrus_writer.commandsex.helpers.Utils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class Command_cex_tploc
extends Teleportation {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Boolean run(CommandSender sender, String alias, String[] args) {
        if (PlayerHelper.checkIsPlayer(sender) == false) return true;
        Player player = (Player)sender;
        if (Utils.checkCommandSpam(player, "tp-tploc", new Integer[0]) != false) return true;
        if (CombatTag.isInCombat(player)) {
            LogHelper.showWarning("combatTagCannotDo", (CommandSender)player);
            return true;
        }
        if (args.length == 1) {
            if (!args[0].contains(",")) {
                Commands.showCommandHelpAndUsage(sender, "cex_tploc", alias);
                return true;
            }
            args = args[0].split(",");
        }
        if (args.length <= 0) {
            Commands.showCommandHelpAndUsage(sender, "cex_tploc", alias);
            return true;
        }
        if (args.length != 3 && args.length != 4) {
            LogHelper.showWarning("tpMissingCoords", sender);
            return false;
        }
        if (!(args[0].matches("(-)?(\\d){1,10}(\\.(\\d){1,10})?") && args[1].matches("(-)?(\\d){1,10}(\\.(\\d){1,10})?") && args[2].matches("(-)?(\\d){1,10}(\\.(\\d){1,10})?"))) {
            LogHelper.showWarning("tpCoordsMustBeNumeric", sender);
            return true;
        }
        try {
            Player target = null;
            if (args.length == 4) {
                if (Bukkit.getPlayer((String)args[3]) == null) {
                    LogHelper.showInfo("invalidPlayer", (CommandSender)player, ChatColor.RED);
                    return true;
                }
                target = Bukkit.getPlayer((String)args[3]);
            } else {
                target = player;
            }
            Command_cex_tploc.delayedTeleport(target, new Location(player.getWorld(), new Double(args[0]).doubleValue(), new Double(args[1]).doubleValue(), new Double(args[2]).doubleValue()), new Runnable[0]);
            LogHelper.showInfo("tpLocMsgToTarget#####[" + args[0].toString() + " " + args[1].toString() + " " + args[2].toString(), sender, ChatColor.AQUA);
            if (player == target) return true;
            LogHelper.showInfo("tpLocSuccess#####[" + target.getName() + " #####tpLocToCoords#####[" + args[0].toString() + " " + args[1].toString() + " " + args[2].toString(), sender, ChatColor.GREEN);
            return true;
        }
        catch (Throwable e) {
            LogHelper.showWarning("internalError", sender);
            LogHelper.logSevere("[CommandsEX]: TPLOC returned an unexpected error for player " + player.getName() + ".");
            LogHelper.logDebug("Message: " + e.getMessage() + ", cause: " + e.getCause());
            e.printStackTrace();
            return false;
        }
    }
}

