/*
 * Decompiled with CFR 0.152.
 */
package com.github.zathrus_writer.commandsex.api.messaging;

import com.github.zathrus_writer.commandsex.api.messaging.PlayerRecievePrivateMessageEvent;
import com.github.zathrus_writer.commandsex.helpers.Nicknames;
import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class Messaging {
    private static HashMap<String, String> lastMessageFrom = new HashMap();

    public static boolean sendMessage(CommandSender sender, Player target, String message, boolean isReply) {
        PlayerRecievePrivateMessageEvent event = new PlayerRecievePrivateMessageEvent(sender, target, message, isReply);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        target.sendMessage(ChatColor.GRAY + "(" + Nicknames.getNick(sender.getName()) + ChatColor.GRAY + " -> " + Nicknames.getNick(target.getName()) + ChatColor.GRAY + ") " + ChatColor.AQUA + event.getMessage());
        sender.sendMessage(ChatColor.GRAY + "(" + Nicknames.getNick(sender.getName()) + ChatColor.GRAY + " -> " + Nicknames.getNick(target.getName()) + ChatColor.GRAY + ") " + ChatColor.AQUA + event.getMessage());
        if (sender instanceof Player) {
            if (lastMessageFrom.containsKey(target.getName())) {
                lastMessageFrom.remove(target.getName());
            }
            lastMessageFrom.put(target.getName(), sender.getName());
        }
        return true;
    }

    public static String getLastMessageFrom(Player player) {
        if (!Messaging.hasLastMessageFrom(player)) {
            return null;
        }
        return lastMessageFrom.get(player.getName());
    }

    public static boolean hasLastMessageFrom(Player player) {
        return lastMessageFrom.containsKey(player.getName());
    }

    public static void setLastMessageFrom(Player player, Player from) {
        Messaging.removeLastMessageFrom(player);
        lastMessageFrom.put(player.getName(), from.getName());
    }

    public static void removeLastMessageFrom(Player player) {
        if (lastMessageFrom.containsKey(player.getName())) {
            lastMessageFrom.remove(player.getName());
        }
    }
}

