/*
 * Decompiled with CFR 0.152.
 */
package com.github.zathrus_writer.commandsex.api.economy;

import com.github.zathrus_writer.commandsex.CommandsEX;
import com.github.zathrus_writer.commandsex.Vault;
import com.github.zathrus_writer.commandsex.api.economy.PlayerEconomyBalanceChangeEvent;
import com.github.zathrus_writer.commandsex.helpers.Econ;
import com.github.zathrus_writer.commandsex.helpers.LogHelper;
import com.github.zathrus_writer.commandsex.helpers.Utils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class Economy {
    public static boolean isEnabled() {
        return CommandsEX.loadedClasses.contains("Init_Econ");
    }

    public static String getCurrencySymbol() {
        return CommandsEX.getConf().getString("economy.currencySymbol");
    }

    public static String getCurrencyPlural() {
        return CommandsEX.getConf().getString("economy.currencyPlural");
    }

    public static String getCurrencySingular() {
        return CommandsEX.getConf().getString("economy.currencySingular");
    }

    public static boolean hasAccount(String player) {
        return Econ.balances.containsKey(player);
    }

    public static double getBalance(String player) {
        if (Economy.hasAccount(player)) {
            return Econ.balances.get(player);
        }
        return Econ.defaultBalance;
    }

    public static String getBalanceWithSymbol(String player) {
        return Economy.getCurrencySymbol() + Economy.getBalance(player);
    }

    public static String getAmountWithSuffix(double amount) {
        return amount + " " + (amount == 1.0 ? Economy.getCurrencySingular() : Economy.getCurrencyPlural());
    }

    public static String getBalanceWithSuffix(String player) {
        return Economy.getAmountWithSuffix(Economy.getBalance(player));
    }

    public static boolean has(String player, double amount) {
        return Economy.getBalance(player) >= amount;
    }

    public static void createAccount(String player) {
        Economy.createAccount(player, Econ.defaultBalance);
    }

    public static void createAccount(String player, double initialAmount) {
        if (!Economy.hasAccount(player)) {
            Econ.balances.put(player, initialAmount);
        }
    }

    public static void setBalance(String player, double amount) {
        PlayerEconomyBalanceChangeEvent event = new PlayerEconomyBalanceChangeEvent(player, amount);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        amount = event.getAmount();
        if (Economy.hasAccount(player)) {
            Econ.balances.remove(player);
            Econ.balances.put(player, amount);
        } else {
            Economy.createAccount(player, amount);
        }
    }

    public static void withdraw(String player, double amount) {
        if (Economy.hasAccount(player)) {
            Economy.setBalance(player, Economy.getBalance(player) - amount);
        } else {
            Economy.createAccount(player, Econ.defaultBalance - amount);
        }
    }

    public static void deposit(String player, double amount) {
        if (Economy.hasAccount(player)) {
            Economy.setBalance(player, Economy.getBalance(player) + amount);
        } else {
            Economy.createAccount(player, Econ.defaultBalance + amount);
        }
    }

    public static void transfer(String sender, String reciever, double amount) {
        if (!CommandsEX.vaultPresent.booleanValue() || !Vault.ecoEnabled().booleanValue()) {
            return;
        }
        Vault.econ.withdrawPlayer(sender, amount);
        Vault.econ.depositPlayer(reciever, amount);
        Player s = Bukkit.getPlayerExact((String)sender);
        Player r = Bukkit.getPlayerExact((String)reciever);
        String a = Vault.econ.format(amount).replaceFirst(String.valueOf(amount), Economy.fixDecimals(amount));
        if (s != null) {
            LogHelper.showInfo("economyPay#####[" + a + " #####to#####[" + reciever, (CommandSender)s, new ChatColor[0]);
        }
        if (r != null) {
            LogHelper.showInfo("[" + sender + " #####economyPayNotify1#####[" + a + " #####economyPayNotify2", (CommandSender)r, new ChatColor[0]);
        }
    }

    public static String fixDecimals(double input) {
        return Utils.twoDecimalPlaces(input);
    }
}

