/*
 * Decompiled with CFR 0.152.
 */
package com.github.zathrus_writer.commandsex.api.afk;

import com.github.zathrus_writer.commandsex.CommandsEX;
import com.github.zathrus_writer.commandsex.api.afk.PlayerAfkToggleEvent;
import com.github.zathrus_writer.commandsex.helpers.LogHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class Afk {
    private static int idleTime = CommandsEX.getConf().getInt("afk.idleTime");
    private static boolean kickEnabled = CommandsEX.getConf().getBoolean("afk.kick.enabled");
    private static int kickTime = CommandsEX.getConf().getInt("afk.kick.time");
    private static String kickMessage = ChatColor.translateAlternateColorCodes((char)"&".charAt(0), (String)CommandsEX.getConf().getString("afk.kick.message"));
    private static HashMap<String, Long> playerIdleTime = new HashMap();
    private static List<String> afkPlayers = new ArrayList<String>();

    public static void toggleAfk(Player player) {
        if (afkPlayers.contains(player)) {
            Afk.setNotAfk(player, false);
        } else {
            Afk.setAfk(player, false);
        }
    }

    public static void setAfk(Player player, boolean silent) {
        if (!afkPlayers.contains(player)) {
            PlayerAfkToggleEvent e = new PlayerAfkToggleEvent(player, true);
            Bukkit.getServer().getPluginManager().callEvent((Event)e);
            String pName = player.getName();
            if (!e.isCancelled()) {
                afkPlayers.add(pName);
                if (!silent) {
                    for (Player p : Bukkit.getOnlinePlayers()) {
                        LogHelper.showInfo("[" + pName + " #####afkIsNowAfk", (CommandSender)p, new ChatColor[0]);
                    }
                }
            }
        }
    }

    public static void setNotAfk(Player player, boolean silent) {
        String pName = player.getName();
        if (afkPlayers.contains(pName)) {
            PlayerAfkToggleEvent e = new PlayerAfkToggleEvent(player, false);
            Bukkit.getServer().getPluginManager().callEvent((Event)e);
            if (!e.isCancelled()) {
                afkPlayers.remove(pName);
                Afk.resetPlayerIdleTime(pName);
                if (!silent) {
                    for (Player p : Bukkit.getOnlinePlayers()) {
                        LogHelper.showInfo("[" + pName + " #####afkIsNoLongerAfk", (CommandSender)p, new ChatColor[0]);
                    }
                }
            }
        }
    }

    public static boolean getAfkStatus(String player) {
        return afkPlayers.contains(player);
    }

    public static long getPlayerAfkTimeInMillis(String player) {
        return playerIdleTime.containsKey(player) ? playerIdleTime.get(player) : -1L;
    }

    public static void checkPlayerIdleTimes() {
        for (String player : playerIdleTime.keySet()) {
            Player p = Bukkit.getPlayerExact((String)player);
            if (p == null) continue;
            if (kickEnabled && p.hasPermission("cex.afk.kick") && (System.currentTimeMillis() - playerIdleTime.get(player)) / 1000L >= (long)kickTime) {
                p.kickPlayer(kickMessage);
                for (Player pl : Bukkit.getOnlinePlayers()) {
                    LogHelper.showWarning("[" + ChatColor.RED + player + " #####afkKickNotify", (CommandSender)pl);
                }
                continue;
            }
            if ((System.currentTimeMillis() - playerIdleTime.get(player)) / 1000L < (long)idleTime) continue;
            Afk.setAfk(p, false);
        }
    }

    public static void resetPlayerIdleTime(String player) {
        Player p = Bukkit.getPlayerExact((String)player);
        if (p != null && p.hasPermission("cex.afk.auto")) {
            if (playerIdleTime.containsKey(player)) {
                playerIdleTime.remove(player);
            }
            if (afkPlayers.contains(player)) {
                Afk.setNotAfk(p, false);
            }
            playerIdleTime.put(player, System.currentTimeMillis());
        }
    }

    public static void removeAfkRecords(String player) {
        if (afkPlayers.contains(player)) {
            afkPlayers.remove(player);
        }
        if (playerIdleTime.containsKey(player)) {
            playerIdleTime.remove(player);
        }
    }

    public static int getIdleTimeToAfk() {
        return idleTime;
    }

    public static int getTimeToKick() {
        return kickTime;
    }

    public static boolean isKickEnabled() {
        return kickEnabled;
    }

    public static String getKickMessage() {
        return kickMessage;
    }
}

