/*
 * Decompiled with CFR 0.152.
 */
package com.github.zathrus_writer.commandsex.api;

import com.github.zathrus_writer.commandsex.CommandsEX;
import com.github.zathrus_writer.commandsex.helpers.LogHelper;
import com.github.zathrus_writer.commandsex.helpers.Spawning;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;

public class SpawnAPI {
    public static boolean isGlobalSpawnEnabled() {
        return CommandsEX.getConf().getBoolean("perWorldSpawn");
    }

    public static void setGlobalSpawn(boolean set) {
        CommandsEX.getConf().set("perWorldSpawn", (Object)(!set ? 1 : 0));
    }

    public static void setGlobalSpawnWorld(String world) {
        World w = Bukkit.getWorld((String)world);
        if (w == null) {
            LogHelper.logDebug("Plugin tried to set default spawn world to " + world + " but that world does not exist");
            return;
        }
        CommandsEX.getConf().set("globalSpawnWorld", (Object)world);
    }

    public static String getGlobalSpawnWorld() {
        return CommandsEX.getConf().getString("globalSpawnWorld");
    }

    public static Location getSpawn(String world) {
        return Spawning.getWorldSpawn((World)Bukkit.getWorld((String)world));
    }

    public static void setSpawn(String world, Location loc) {
        if (Spawning.worldSpawns.containsKey(world)) {
            Spawning.worldSpawns.remove(world);
        }
        Spawning.worldSpawns.put(world, loc);
    }

    public static void saveDatabase() {
        Spawning.saveDatabase();
    }
}

