/*
 * Decompiled with CFR 0.152.
 */
package com.github.zathrus_writer.commandsex;

import com.github.zathrus_writer.commandsex.CommandsEX;
import com.github.zathrus_writer.commandsex.Language;
import com.github.zathrus_writer.commandsex.helpers.LogHelper;
import com.github.zathrus_writer.commandsex.helpers.Utils;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class SQLManager {
    public static CommandsEX plugin;
    public static transient Connection conn;
    public static transient Connection altConn;
    public static String prefix;
    public static String sqlType;
    public static Boolean omitErrorLogs;

    public static void init(CommandsEX p) {
        plugin = p;
        String v = p.getConfig().getString("sqlType").toLowerCase();
        if (v.equals("sqlite")) {
            try {
                Class.forName("org.sqlite.JDBC");
                conn = DriverManager.getConnection("jdbc:sqlite:" + p.getDataFolder() + File.separatorChar + (p.getConfig().getString("database") != null ? p.getConfig().getString("database") : "data") + ".db");
                CommandsEX.sqlEnabled = true;
                sqlType = "sqlite";
            }
            catch (Throwable e) {
                LogHelper.logSevere("[CommandsEX] " + Language._("dbSQLiteNotUsable", ""));
                LogHelper.logDebug("Message: " + e.getMessage() + ", cause: " + e.getCause());
            }
        } else if (v.equals("mysql")) {
            try {
                Class.forName("com.mysql.jdbc.Driver");
                conn = DriverManager.getConnection("jdbc:mysql://" + (p.getConfig().getString("host") != null ? p.getConfig().getString("host") : "localhost") + ":" + (p.getConfig().getString("port") != null ? p.getConfig().getString("port") : "3306") + "/" + (p.getConfig().getString("database") != null ? p.getConfig().getString("database") : "minecraft"), p.getConfig().getString("name") != null ? p.getConfig().getString("name") : "root", p.getConfig().getString("password") != null ? p.getConfig().getString("password") : "");
                prefix = p.getConfig().getString("prefix") != null ? p.getConfig().getString("prefix") : "";
                CommandsEX.sqlEnabled = true;
                sqlType = "mysql";
            }
            catch (Throwable e) {
                LogHelper.logSevere("[CommandsEX] " + Language._("dbMySQLNotUsable", ""));
                LogHelper.logDebug("Message: " + e.getMessage() + ", cause: " + e.getCause());
            }
        }
        SQLManager.query("CREATE TABLE IF NOT EXISTS " + prefix + "playtime (player_name varchar(32) NOT NULL, seconds_played int(10) " + (sqlType.equals("mysql") ? "unsigned " : "") + "NOT NULL DEFAULT '0', PRIMARY KEY (player_name))" + (sqlType.equals("mysql") ? " ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='holds playtime of each player on the server'" : ""), new Object[0]);
        SQLManager.query("CREATE TABLE IF NOT EXISTS " + prefix + "user2lang (username varchar(50) NOT NULL, lang varchar(5) NOT NULL, PRIMARY KEY (`username`))" + (sqlType.equals("mysql") ? " ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='stores per-user selected plugin language'" : ""), new Object[0]);
    }

    public static void onDisable(CommandsEX p) {
        SQLManager.close();
    }

    public static Boolean init_alt(String v, String altFileName) {
        v = v.toLowerCase();
        if (altFileName.equals("")) {
            altFileName = (plugin.getConfig().getString("database") != null ? plugin.getConfig().getString("database") : "data") + ".db";
        }
        if (v.equals("sqlite")) {
            try {
                Class.forName("org.sqlite.JDBC");
                altConn = DriverManager.getConnection("jdbc:sqlite:" + plugin.getDataFolder() + File.separatorChar + altFileName);
            }
            catch (Throwable e) {
                LogHelper.logSevere("[CommandsEX] " + Language._("dbSQLiteNotUsable", ""));
                LogHelper.logDebug("Message: " + e.getMessage() + ", cause: " + e.getCause());
                return false;
            }
        }
        if (v.equals("mysql")) {
            try {
                Class.forName("com.mysql.jdbc.Driver");
                altConn = DriverManager.getConnection("jdbc:mysql://" + (plugin.getConfig().getString("host") != null ? plugin.getConfig().getString("host") : "localhost") + ":" + (plugin.getConfig().getString("port") != null ? plugin.getConfig().getString("port") : "3306") + "/" + (plugin.getConfig().getString("database") != null ? plugin.getConfig().getString("database") : "minecraft"), plugin.getConfig().getString("name") != null ? plugin.getConfig().getString("name") : "root", plugin.getConfig().getString("password") != null ? plugin.getConfig().getString("password") : "");
            }
            catch (Throwable e) {
                LogHelper.logSevere("[CommandsEX] " + Language._("dbMySQLNotUsable", ""));
                LogHelper.logDebug("Message: " + e.getMessage() + ", cause: " + e.getCause());
                return false;
            }
        }
        return true;
    }

    public static Boolean query(String query, Object ... params) {
        if (!CommandsEX.sqlEnabled.booleanValue()) {
            return false;
        }
        if (params.length == 0) {
            try {
                Statement stat = conn.createStatement();
                stat.executeUpdate(query);
                stat.close();
            }
            catch (Throwable e) {
                LogHelper.logSevere("[CommandsEX] " + Language._("dbWriteError", ""));
                LogHelper.logDebug("Query: " + query);
                LogHelper.logDebug("Message: " + e.getMessage() + ", cause: " + e.getCause());
                return false;
            }
        }
        if (params.length == 1 && (params[0] instanceof List || params[0] instanceof ArrayList)) {
            params = ((List)params[0]).toArray();
        }
        try {
            PreparedStatement prep = conn.prepareStatement(query);
            Integer i = 1;
            for (Object o : params) {
                if (o instanceof Integer) {
                    prep.setInt(i, (Integer)o);
                } else if (o instanceof String) {
                    prep.setString(i, (String)o);
                } else if (o instanceof Double) {
                    prep.setDouble(i, (Double)o);
                } else if (o instanceof Float) {
                    prep.setFloat(i, ((Float)o).floatValue());
                } else if (o instanceof Long) {
                    prep.setLong(i, (Long)o);
                } else if (o instanceof Boolean) {
                    prep.setBoolean(i, (Boolean)o);
                } else if (o instanceof Date) {
                    prep.setTimestamp(i, new Timestamp(((Date)o).getTime()));
                } else if (o instanceof Timestamp) {
                    prep.setTimestamp(i, (Timestamp)o);
                } else if (o == null) {
                    prep.setNull(i, 0);
                } else {
                    LogHelper.logSevere("[CommandsEX]" + Language._("dbQueryParamError", ""));
                    LogHelper.logDebug("Query: " + query + ", variable: " + o.toString());
                    prep.clearBatch();
                    prep.close();
                    return false;
                }
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            prep.addBatch();
            conn.setAutoCommit(false);
            prep.executeBatch();
            conn.commit();
            prep.close();
            prep = null;
        }
        catch (Throwable e) {
            if (!omitErrorLogs.booleanValue()) {
                LogHelper.logSevere("[CommandsEX] " + Language._("dbWriteError", ""));
                LogHelper.logDebug("Query: " + query + ", parameters: " + Utils.implode(params, ", "));
                LogHelper.logDebug("Message: " + e.getMessage() + ", cause: " + e.getCause());
            }
            return false;
        }
        return true;
    }

    public static Boolean query_alt(String query, Object ... params) {
        Connection c = conn;
        conn = altConn;
        Boolean ret = SQLManager.query(query, params);
        conn = c;
        return ret;
    }

    public static ResultSet query_res(String query, Object ... params) {
        block21: {
            if (!CommandsEX.sqlEnabled.booleanValue()) {
                return null;
            }
            if (params.length == 0) {
                try {
                    Statement stat = conn.createStatement();
                    ResultSet res = stat.executeQuery(query);
                    return res;
                }
                catch (Throwable e) {
                    LogHelper.logSevere("[CommandsEX] " + Language._("dbWriteError", ""));
                    LogHelper.logDebug("Query: " + query);
                    LogHelper.logDebug("Message: " + e.getMessage() + ", cause: " + e.getCause());
                }
            } else {
                if (params.length == 1 && (params[0] instanceof List || params[0] instanceof ArrayList)) {
                    params = ((List)params[0]).toArray();
                }
                try {
                    PreparedStatement prep = conn.prepareStatement(query);
                    Integer i = 1;
                    for (Object o : params) {
                        if (o instanceof Integer) {
                            prep.setInt(i, (Integer)o);
                        } else if (o instanceof String) {
                            prep.setString(i, (String)o);
                        } else if (o instanceof Double) {
                            prep.setDouble(i, (Double)o);
                        } else if (o instanceof Float) {
                            prep.setFloat(i, ((Float)o).floatValue());
                        } else if (o instanceof Long) {
                            prep.setLong(i, (Long)o);
                        } else if (o == null) {
                            prep.setNull(i, 0);
                        } else {
                            LogHelper.logSevere("[CommandsEX] " + Language._("dbQueryParamError", ""));
                            LogHelper.logDebug("Query: " + query + ", variable: " + o.toString());
                            prep.close();
                            return null;
                        }
                        Integer n = i;
                        Integer n2 = i = Integer.valueOf(i + 1);
                    }
                    return prep.executeQuery();
                }
                catch (Throwable e) {
                    if (omitErrorLogs.booleanValue()) break block21;
                    LogHelper.logSevere("[CommandsEX] " + Language._("dbWriteError", ""));
                    LogHelper.logDebug("Query: " + query);
                    LogHelper.logDebug("Message: " + e.getMessage() + ", cause: " + e.getCause());
                }
            }
        }
        return null;
    }

    public static ResultSet query_res_alt(String query, Object ... params) {
        Connection c = conn;
        conn = altConn;
        ResultSet ret = SQLManager.query_res(query, params);
        conn = c;
        return ret;
    }

    public static void close() {
        if (CommandsEX.sqlEnabled.booleanValue()) {
            try {
                conn.close();
                altConn.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void close_alt() {
        if (CommandsEX.sqlEnabled.booleanValue()) {
            try {
                altConn.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static {
        prefix = "cex_";
        omitErrorLogs = false;
    }
}

