/*
 * Decompiled with CFR 0.152.
 */
package com.github.zathrus_writer.commandsex;

import com.github.zathrus_writer.commandsex.CommandsEX;
import com.github.zathrus_writer.commandsex.FileResClassLoader;
import com.github.zathrus_writer.commandsex.SQLManager;
import com.github.zathrus_writer.commandsex.helpers.LogHelper;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Language {
    public static transient String defaultLocale;
    public static Map<String, ResourceBundle> langs;
    public static Map<String, String> perUserLocale;
    private static Boolean perUserDataLoaded;
    private static CommandsEX plugin;
    public static Boolean noMissingLangWarning;

    public static void init(CommandsEX plug) {
        plugin = plug;
        defaultLocale = plugin.getConfig().getString("defaultLang").toLowerCase();
        try {
            if (defaultLocale.contains("_")) {
                String[] localeSplit = defaultLocale.split("_");
                langs.put(defaultLocale, ResourceBundle.getBundle("lang", new Locale(localeSplit[0], localeSplit[1]), new FileResClassLoader(CommandsEX.class.getClassLoader(), plugin)));
            } else {
                langs.put(defaultLocale, ResourceBundle.getBundle("lang", new Locale(defaultLocale), new FileResClassLoader(CommandsEX.class.getClassLoader(), plugin)));
            }
        }
        catch (MissingResourceException r) {
            try {
                if (defaultLocale.contains("_")) {
                    String[] localeSplit = defaultLocale.split("_");
                    langs.put(defaultLocale, ResourceBundle.getBundle("lang", new Locale(localeSplit[0], localeSplit[1])));
                }
                langs.put(defaultLocale, ResourceBundle.getBundle("lang", new Locale(defaultLocale)));
            }
            catch (Throwable e) {
                plugin.getConfig().set("defaultLang", (Object)"en");
                plugin.saveConfig();
                LogHelper.logWarning("Unable to load locale " + defaultLocale + ", trying English");
                LogHelper.logDebug("Message: " + e.getMessage() + ", cause: " + e.getCause());
                defaultLocale = "en";
                langs.put(defaultLocale, ResourceBundle.getBundle("lang", Locale.ENGLISH));
            }
        }
        catch (Throwable e) {
            plugin.getConfig().set("defaultLang", (Object)"en");
            plugin.saveConfig();
            LogHelper.logSevere("[CommandsEX] Unable to load locale " + defaultLocale + ", trying English");
            LogHelper.logDebug("Message: " + e.getMessage() + ", cause: " + e.getCause());
            defaultLocale = "en";
            langs.put(defaultLocale, ResourceBundle.getBundle("lang", Locale.ENGLISH));
        }
    }

    public static String _(String s, String playerName) {
        String loc = defaultLocale;
        if (!perUserDataLoaded.booleanValue() && !CommandsEX.avoidDB.booleanValue() && CommandsEX.sqlEnabled.booleanValue()) {
            try {
                ResultSet res = SQLManager.query_res("SELECT * FROM " + SQLManager.prefix + "user2lang", new Object[0]);
                while (res.next()) {
                    perUserLocale.put(res.getString("username"), res.getString("lang"));
                }
                res.close();
            }
            catch (Throwable e) {
                CommandsEX.avoidDB = true;
                LogHelper.logSevere("[CommandsEX] " + Language._("dbReadError", ""));
                LogHelper.logDebug("SQL: SELECT * FROM " + SQLManager.prefix + "user2lang");
                LogHelper.logDebug("Message: " + e.getMessage() + ", cause: " + e.getCause());
            }
            perUserDataLoaded = true;
        }
        if (!playerName.equals("") && !playerName.toLowerCase().equals("console") && perUserLocale.containsKey(playerName)) {
            loc = perUserLocale.get(playerName);
        }
        try {
            if (!langs.containsKey(loc)) {
                try {
                    if (loc.contains("_")) {
                        String[] localeSplit = loc.split("_");
                        langs.put(loc, ResourceBundle.getBundle("lang", new Locale(localeSplit[0], localeSplit[1]), new FileResClassLoader(CommandsEX.class.getClassLoader(), plugin)));
                    } else {
                        langs.put(loc, ResourceBundle.getBundle("lang", new Locale(loc), new FileResClassLoader(CommandsEX.class.getClassLoader(), plugin)));
                    }
                }
                catch (MissingResourceException r) {
                    try {
                        if (loc.contains("_")) {
                            String[] localeSplit = loc.split("_");
                            langs.put(loc, ResourceBundle.getBundle("lang", new Locale(localeSplit[0], localeSplit[1])));
                        }
                        langs.put(loc, ResourceBundle.getBundle("lang", new Locale(loc)));
                    }
                    catch (Throwable e) {
                        LogHelper.logWarning("Unable to load locale " + loc + ", trying English");
                        LogHelper.logDebug("Message: " + e.getMessage() + ", cause: " + e.getCause());
                        loc = "en";
                        langs.put(defaultLocale, ResourceBundle.getBundle("lang", Locale.ENGLISH));
                    }
                }
                catch (Throwable e) {
                    LogHelper.logWarning("Unable to load locale " + loc + ", trying English");
                    LogHelper.logDebug("Message: " + e.getMessage() + ", cause: " + e.getCause());
                    loc = "en";
                    langs.put(defaultLocale, ResourceBundle.getBundle("lang", Locale.ENGLISH));
                }
            }
            s = langs.get(loc).getString(s);
        }
        catch (MissingResourceException ex) {
            if (!noMissingLangWarning.booleanValue()) {
                LogHelper.logWarning("Missing translation of '" + s + "' for language '" + loc + "'");
            }
        }
        catch (Throwable e) {
            plugin.getConfig().set("defaultLang", (Object)"en");
            plugin.saveConfig();
            defaultLocale = "en";
            LogHelper.logSevere("[CommandsEX] Translation failed for message '" + s + "', language '" + loc + "'");
            LogHelper.logDebug("Message: " + e.getMessage() + ", cause: " + e.getCause());
        }
        return s;
    }

    static {
        langs = new HashMap<String, ResourceBundle>();
        perUserLocale = new HashMap<String, String>();
        perUserDataLoaded = false;
        noMissingLangWarning = false;
    }
}

