/*
 * Decompiled with CFR 0.152.
 */
package com.github.zathrus_writer.commandsex;

import com.github.zathrus_writer.commandsex.CommandsEX;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;

public class FileResClassLoader
extends ClassLoader {
    private final transient File dataFolder;

    public FileResClassLoader(ClassLoader classLoader, CommandsEX c) {
        super(classLoader);
        this.dataFolder = c.getDataFolder();
    }

    @Override
    public URL getResource(String string) {
        File file = new File(this.dataFolder, string);
        if (file.exists()) {
            try {
                return file.toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return super.getResource(string);
    }

    @Override
    public InputStream getResourceAsStream(String string) {
        File file = new File(this.dataFolder, string);
        if (file.exists()) {
            try {
                return new FileInputStream(file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return super.getResourceAsStream(string);
    }
}

