/*
 * Decompiled with CFR 0.152.
 */
package com.github.zathrus_writer.commandsex;

import com.github.zathrus_writer.commandsex.CombatTag;
import com.github.zathrus_writer.commandsex.Language;
import com.github.zathrus_writer.commandsex.SQLManager;
import com.github.zathrus_writer.commandsex.Vault;
import com.github.zathrus_writer.commandsex.helpers.Commands;
import com.github.zathrus_writer.commandsex.helpers.Jails;
import com.github.zathrus_writer.commandsex.helpers.LogHelper;
import com.github.zathrus_writer.commandsex.helpers.Metrics;
import com.github.zathrus_writer.commandsex.helpers.Utils;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.permissions.Permission;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPlugin;
import org.kitteh.vanish.staticaccess.VanishNoPacket;

public class CommandsEX
extends JavaPlugin
implements Listener {
    public static CommandsEX plugin;
    public static final String intRegex = "(-)?(\\d){1,10}(\\.(\\d){1,10})?";
    public static transient PluginDescriptionFile pdfFile;
    public static Boolean avoidDB;
    private Commands cListener;
    public static Boolean sqlEnabled;
    public static Map<String, Integer> playTimes;
    public static Map<String, Integer> joinTimes;
    public static Map<String, String> playerIPs;
    protected Map<String, Integer> playTimeLoadTasks = new HashMap<String, Integer>();
    public static Integer minTimeFromLogout;
    public static Integer playTimesFlushTime;
    protected Integer minTimeToSavePlayTime = 45;
    public static List<String> onDisableFunctions;
    public static Boolean vaultPresent;
    public static Boolean vanishNoPacketPresent;
    private long startTime;
    private long stopTime;
    private long finalTime;
    public static File file;
    public static List<String> loadedClasses;
    public static Metrics metrics;
    public static HashMap<String, Integer> commandUses;

    public CommandsEX() {
        plugin = this;
    }

    public void onEnable() {
        this.startTimer();
        file = this.getFile();
        this.getConfig().options().copyDefaults(true);
        this.saveConfig();
        try {
            new Vault();
            vaultPresent = true;
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            new VanishNoPacket();
            vanishNoPacketPresent = true;
        }
        catch (Throwable e) {
            // empty catch block
        }
        new CombatTag();
        this.cListener = new Commands(this);
        Language.init(this);
        pdfFile = this.getDescription();
        LogHelper.logInfo("[" + pdfFile.getName() + "] " + Language._("startupMessage", "") + " " + Language.defaultLocale);
        LogHelper.logInfo("[" + pdfFile.getName() + "] " + Language._("version", "") + " " + pdfFile.getVersion() + " " + Language._("enableMsg", ""));
        Class[] proto = new Class[]{((Object)((Object)this)).getClass()};
        Object[] params = new Object[]{this};
        if (CommandsEX.getConf().getBoolean("enableDatabase")) {
            try {
                Class<?> c = Class.forName("com.github.zathrus_writer.commandsex.SQLManager");
                Method method = c.getDeclaredMethod("init", proto);
                method.invoke(null, params);
            }
            catch (ClassNotFoundException e) {
            }
            catch (Throwable e) {
                LogHelper.logSevere(Language._("dbError", ""));
                LogHelper.logDebug("Message: " + e.getMessage() + ", cause: " + e.getCause());
            }
        }
        for (String cmd : pdfFile.getCommands().keySet()) {
            loadedClasses.add("Command_" + cmd);
        }
        List perms = pdfFile.getPermissions();
        for (int i = 0; i <= perms.size() - 1; ++i) {
            String[] s;
            String pName = ((Permission)perms.get(i)).getName();
            if (pName.startsWith("Listener")) {
                s = pName.split("\\.");
                if (s.length == 0) continue;
                try {
                    Class.forName("com.github.zathrus_writer.commandsex.handlers.Handler_" + s[1]).newInstance();
                    loadedClasses.add("Handler_" + s[1]);
                }
                catch (ClassNotFoundException e) {
                }
                catch (Throwable e) {
                    LogHelper.logSevere(Language._("loadTimeError", ""));
                    LogHelper.logDebug("Message: " + e.getMessage() + ", cause: " + e.getCause());
                    e.printStackTrace();
                }
                continue;
            }
            if (!pName.startsWith("Init") || (s = pName.split("\\.")).length == 0) continue;
            try {
                Class<?> c = Class.forName("com.github.zathrus_writer.commandsex.helpers." + s[1]);
                Method method = c.getDeclaredMethod("init", proto);
                method.invoke(null, params);
                loadedClasses.add("Init_" + s[1]);
                continue;
            }
            catch (ClassNotFoundException e) {
                continue;
            }
            catch (Throwable e) {
                LogHelper.logSevere(Language._("loadTimeError", ""));
                LogHelper.logDebug("Message: " + e.getMessage() + ", cause: " + e.getCause());
                e.printStackTrace();
            }
        }
        if (sqlEnabled.booleanValue()) {
            this.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this, new Runnable(){

                @Override
                public void run() {
                    Integer stamp = Utils.getUnixTimestamp(0L);
                    Iterator<Map.Entry<String, Integer>> it = playTimes.entrySet().iterator();
                    ArrayList<String> insertParts = new ArrayList<String>();
                    ArrayList<Object> insertValues = new ArrayList<Object>();
                    while (it.hasNext()) {
                        Map.Entry<String, Integer> pairs = it.next();
                        if (pairs.getValue() <= -1) continue;
                        String pName = pairs.getKey();
                        Integer played = pairs.getValue() + (stamp - joinTimes.get(pName));
                        playTimes.put(pName, played);
                        joinTimes.put(pName, Utils.getUnixTimestamp(0L));
                        insertParts.add("SELECT ? AS 'player_name', ? AS 'seconds_played'");
                        insertValues.add(pName);
                        insertValues.add(played);
                    }
                    if (insertParts.size() > 0) {
                        SQLManager.query("INSERT " + (SQLManager.sqlType.equals("mysql") ? "" : "OR REPLACE ") + "INTO " + SQLManager.prefix + "playtime " + Utils.implode(insertParts, " UNION ") + (SQLManager.sqlType.equals("mysql") ? " ON DUPLICATE KEY UPDATE seconds_played = VALUES(seconds_played)" : ""), insertValues);
                    }
                }
            }, (long)(20 * playTimesFlushTime), (long)(20 * playTimesFlushTime));
            this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        }
        if (CommandsEX.getConf().getBoolean("pluginMetrics")) {
            try {
                metrics = new Metrics((Plugin)plugin);
                Metrics.Graph featureGraph = metrics.createGraph("Feature Statistics");
                if (loadedClasses.contains("Init_Home")) {
                    featureGraph.addPlotter(new Metrics.Plotter("Homes Set"){

                        @Override
                        public int getValue() {
                            int count = 0;
                            try {
                                ResultSet rs = SQLManager.query_res("SELECT player_name FROM " + SQLManager.prefix + "homes", new Object[0]);
                                while (rs.next()) {
                                    ++count;
                                }
                                rs.close();
                            }
                            catch (SQLException e) {
                                e.printStackTrace();
                            }
                            return count;
                        }
                    });
                }
                if (loadedClasses.contains("Init_Warps")) {
                    featureGraph.addPlotter(new Metrics.Plotter("Warps Set"){

                        @Override
                        public int getValue() {
                            int count = 0;
                            try {
                                ResultSet rs = SQLManager.query_res("SELECT owner_name FROM " + SQLManager.prefix + "warps", new Object[0]);
                                while (rs.next()) {
                                    ++count;
                                }
                                rs.close();
                            }
                            catch (SQLException e) {
                                e.printStackTrace();
                            }
                            return count;
                        }
                    });
                }
                if (loadedClasses.contains("Init_Nicknames")) {
                    featureGraph.addPlotter(new Metrics.Plotter("Nicknames Set"){

                        @Override
                        public int getValue() {
                            int count = 0;
                            try {
                                ResultSet rs = SQLManager.query_res("SELECT player_name FROM " + SQLManager.prefix + "nicknames", new Object[0]);
                                while (rs.next()) {
                                    ++count;
                                }
                                rs.close();
                            }
                            catch (SQLException e) {
                                e.printStackTrace();
                            }
                            return count;
                        }
                    });
                }
                if (loadedClasses.contains("Init_Nametags")) {
                    featureGraph.addPlotter(new Metrics.Plotter("Nametags Set"){

                        @Override
                        public int getValue() {
                            int count = 0;
                            try {
                                ResultSet rs = SQLManager.query_res("SELECT player_name FROM " + SQLManager.prefix + "nametags", new Object[0]);
                                while (rs.next()) {
                                    ++count;
                                }
                                rs.close();
                            }
                            catch (SQLException e) {
                                e.printStackTrace();
                            }
                            return count;
                        }
                    });
                }
                if (loadedClasses.contains("Init_Kits")) {
                    featureGraph.addPlotter(new Metrics.Plotter("Kits Set"){

                        @Override
                        public int getValue() {
                            int count = 0;
                            FileConfiguration f = CommandsEX.getConf();
                            ConfigurationSection configGroups = f.getConfigurationSection("kits");
                            if (configGroups != null) {
                                Set kitGroups = configGroups.getKeys(false);
                                for (String group : kitGroups) {
                                    ConfigurationSection kits = f.getConfigurationSection("kits." + group);
                                    Set kitNames = kits.getKeys(false);
                                    count += kitNames.size();
                                }
                            }
                            return count;
                        }
                    });
                }
                Metrics.Graph commandUsesGraph = metrics.createGraph("Command Uses");
                for (final String s : loadedClasses) {
                    if (!s.startsWith("Command_cex_")) continue;
                    String key = s.replaceAll("Command_cex_", "/");
                    commandUsesGraph.addPlotter(new Metrics.Plotter(key){

                        @Override
                        public int getValue() {
                            return commandUses.containsKey(s) ? commandUses.get(s) : 0;
                        }
                    });
                }
                metrics.start();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.stopTimer();
    }

    public void startTimer() {
        this.startTime = System.currentTimeMillis();
    }

    public void stopTimer() {
        this.stopTime = System.currentTimeMillis();
        this.finalTime = this.stopTime - this.startTime;
        if (CommandsEX.getConf().getBoolean("startupTimer")) {
            LogHelper.logInfo("[CommandsEx] " + Language._("startupTime", "") + this.finalTime + "ms");
        }
    }

    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String[] args) {
        return this.cListener.onCommand(sender, cmd, commandLabel, args);
    }

    public void onDisable() {
        Object[] params;
        Class[] proto;
        avoidDB = true;
        if (onDisableFunctions.size() > 0) {
            proto = new Class[]{((Object)((Object)this)).getClass()};
            params = new Object[]{this};
            for (String s : onDisableFunctions) {
                try {
                    String[] ss = s.split("#####");
                    Class<?> c = Class.forName(ss[0]);
                    Method method = c.getDeclaredMethod(ss[1], proto);
                    method.invoke(null, params);
                }
                catch (Throwable e) {
                    LogHelper.logSevere("[CommandsEX] " + Language._("errorFunctionOnDisableExecute", "") + s);
                    LogHelper.logDebug("Message: " + e.getMessage() + ", cause: " + e.getCause());
                }
            }
        }
        if (CommandsEX.getConf().getBoolean("enableDatabase")) {
            proto = new Class[]{((Object)((Object)this)).getClass()};
            params = new Object[]{this};
            try {
                Class<?> c = Class.forName("com.github.zathrus_writer.commandsex.SQLManager");
                Method method = c.getDeclaredMethod("onDisable", proto);
                method.invoke(null, params);
            }
            catch (ClassNotFoundException e) {
            }
            catch (Throwable e) {
                LogHelper.logSevere(Language._("dbError", ""));
                LogHelper.logDebug("Message: " + e.getMessage() + ", cause: " + e.getCause());
            }
        }
        LogHelper.logInfo("[" + this.getDescription().getName() + "] " + Language._("disableMsg", ""));
    }

    public static FileConfiguration getConf() {
        return plugin.getConfig();
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void pJoin(PlayerJoinEvent e) {
        String pName = e.getPlayer().getName();
        playerIPs.put(pName.toLowerCase(), e.getPlayer().getAddress().getAddress().getHostAddress());
        try {
            if (Jails.jailedPlayers.containsKey(pName)) {
                LogHelper.showInfo("jailsStillJailed", (CommandSender)e.getPlayer(), new ChatColor[0]);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (sqlEnabled.booleanValue()) {
            playTimes.put(pName, -1);
            joinTimes.put(pName, Utils.getUnixTimestamp(0L));
            if (this.playTimeLoadTasks.containsKey(pName)) {
                this.getServer().getScheduler().cancelTask(this.playTimeLoadTasks.get(pName).intValue());
            }
            this.playTimeLoadTasks.put(pName, this.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this, new Runnable(){

                @Override
                public void run() {
                    Iterator<Map.Entry<String, Integer>> it = playTimes.entrySet().iterator();
                    ArrayList<String> playerNames = new ArrayList<String>();
                    Integer stamp = Utils.getUnixTimestamp(0L);
                    while (it.hasNext()) {
                        Map.Entry<String, Integer> pairs = it.next();
                        if (pairs.getValue() > -1) continue;
                        String pName = pairs.getKey();
                        OfflinePlayer o = plugin.getServer().getOfflinePlayer(pName);
                        if (o != null && o.getLastPlayed() > 0L) {
                            Integer lastPlay = Utils.getUnixTimestamp(o.getLastPlayed());
                            if (stamp - lastPlay < minTimeFromLogout - 5) continue;
                            playerNames.add(pName);
                            continue;
                        }
                        playTimes.put(pName, 0);
                    }
                    Integer pSize = playerNames.size();
                    if (pSize > 0) {
                        try {
                            Object[] qMarks = new String[pSize.intValue()];
                            Arrays.fill(qMarks, "?");
                            ResultSet res = SQLManager.query_res("SELECT * FROM " + SQLManager.prefix + "playtime WHERE player_name IN (" + Utils.implode(qMarks, ", ") + ")", playerNames);
                            while (res.next()) {
                                playTimes.put(res.getString("player_name"), res.getInt("seconds_played"));
                            }
                            res.close();
                        }
                        catch (Throwable e) {
                            LogHelper.logSevere("[CommandsEX] " + Language._("dbTotalPlayTimeGetError", ""));
                            LogHelper.logDebug("Message: " + e.getMessage() + ", cause: " + e.getCause());
                            return;
                        }
                    }
                }
            }, (long)(20 * minTimeFromLogout)));
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void pQuit(PlayerQuitEvent e) {
        String pName = e.getPlayer().getName();
        Integer stamp = Utils.getUnixTimestamp(0L);
        plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)plugin, (Runnable)new DelayedIpRemoval(pName), (long)(20 * CommandsEX.getConf().getInt("maxIPholdTime")));
        if (sqlEnabled.booleanValue() && joinTimes.containsKey(pName)) {
            Integer played = stamp - joinTimes.get(pName);
            if (played >= this.minTimeToSavePlayTime) {
                if (playTimes.containsKey(pName) && playTimes.get(pName) > -1) {
                    playTimes.put(pName, playTimes.get(pName) + played);
                } else {
                    try {
                        Integer pTime = 0;
                        ResultSet res = SQLManager.query_res("SELECT seconds_played FROM " + SQLManager.prefix + "playtime WHERE player_name = ?", pName);
                        while (res.next()) {
                            pTime = res.getInt("seconds_played");
                        }
                        res.close();
                        playTimes.put(pName, pTime + played);
                    }
                    catch (Throwable ex) {
                        LogHelper.logSevere("[CommandsEX] " + Language._("dbTotalPlayTimeGetError", ""));
                        LogHelper.logDebug("Message: " + ex.getMessage() + ", cause: " + ex.getCause());
                    }
                }
                played = playTimes.get(pName);
                SQLManager.query("INSERT " + (SQLManager.sqlType.equals("mysql") ? "" : "OR REPLACE ") + "INTO " + SQLManager.prefix + "playtime VALUES (?, ?)" + (SQLManager.sqlType.equals("mysql") ? " ON DUPLICATE KEY UPDATE seconds_played = VALUES(seconds_played)" : ""), pName, played);
            }
            joinTimes.remove(pName);
            playTimes.remove(pName);
        }
    }

    static {
        avoidDB = false;
        sqlEnabled = false;
        playTimes = new HashMap<String, Integer>();
        joinTimes = new HashMap<String, Integer>();
        playerIPs = new HashMap<String, String>();
        minTimeFromLogout = 30;
        playTimesFlushTime = 180;
        onDisableFunctions = new ArrayList<String>();
        vaultPresent = false;
        vanishNoPacketPresent = false;
        loadedClasses = new ArrayList<String>();
        commandUses = new HashMap();
    }

    public static class DelayedIpRemoval
    implements Runnable {
        private String pName;

        public DelayedIpRemoval(String pName) {
            this.pName = pName;
        }

        @Override
        public void run() {
            if (Bukkit.getServer().getPlayer(this.pName) == null) {
                playerIPs.remove(this.pName.toLowerCase());
            }
        }
    }
}

