/*
 * Decompiled with CFR 0.152.
 */
package Objects;

import Managers.PlayerWarpManager;
import Objects.PlayerWarpObject;
import PlayerWarpGUI.PlayerWarpGUI;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class chestObject {
    public chestObject(PlayerWarpGUI playerWarpGUI) {
    }

    public static ItemStack parseString(String itemId) {
        String[] parts = itemId.split(":");
        int matId = Integer.parseInt(parts[0]);
        if (parts.length == 2) {
            short data = Short.parseShort(parts[1]);
            return new ItemStack(Material.getMaterial((int)matId), 1, data);
        }
        return new ItemStack(Material.getMaterial((int)matId));
    }

    public static ItemStack getNextPageItemStack(int pageNum) {
        ItemStack nextPageItemstack = chestObject.parseString(PlayerWarpGUI.nextPageIcon);
        ItemMeta nextPageMeta = nextPageItemstack.getItemMeta();
        nextPageMeta.setDisplayName(ChatColor.GREEN + "Next Page: " + pageNum);
        nextPageItemstack.setItemMeta(nextPageMeta);
        return nextPageItemstack;
    }

    public static String replaceColorVariables(String str) {
        str = ChatColor.translateAlternateColorCodes((char)'&', (String)str);
        return str;
    }

    public static int getWarpID(ItemStack itemStack) {
        List loreList = new ArrayList();
        loreList = itemStack.getItemMeta().getLore();
        int warpID = Integer.parseInt(ChatColor.stripColor((String)((String)loreList.get(3)).replace("Warp ID: ", "")));
        return warpID;
    }

    public static PlayerWarpObject getPlayerWarpObject(int uid) {
        for (PlayerWarpObject n : PlayerWarpGUI.playerWarpObjects) {
            if (n.getUid() != uid) continue;
            return n;
        }
        return null;
    }

    public static Location getWarpLocation(int uid) {
        PlayerWarpObject playerWarpObject = chestObject.getPlayerWarpObject(uid);
        return PlayerWarpManager.getPlayerWarpManager().str2loc(playerWarpObject.getWarpLocation());
    }

    public ItemStack setLore(ItemStack item, List<String> message) {
        ItemMeta meta = item.getItemMeta();
        if (meta.hasLore()) {
            message.addAll(meta.getLore());
        }
        meta.setLore(message);
        item.setItemMeta(meta);
        return item;
    }

    public static void openGUI(Player player, int page) {
        int pageNumber = page;
        int chestSize = PlayerWarpGUI.chestSize;
        int pageSize = PlayerWarpGUI.chestSize - 1;
        int startNum = 0;
        int pageNum = page;
        boolean showNext = true;
        String icon = null;
        Inventory inv = Bukkit.createInventory(null, (int)chestSize, (String)chestObject.replaceColorVariables(PlayerWarpGUI.chestText));
        startNum = pageNum * pageSize;
        int loopSize = startNum + pageSize;
        List<PlayerWarpObject> playerWarpObjects = PlayerWarpGUI.playerWarpObjects;
        if (loopSize > playerWarpObjects.size()) {
            loopSize = playerWarpObjects.size() - startNum;
            showNext = false;
        }
        int i = 0;
        while (i < loopSize && i < chestSize - 1) {
            ItemStack playerWarpItemStack;
            int objNum = startNum + i;
            PlayerWarpObject a = playerWarpObjects.get(objNum);
            int b = a.getUid();
            String playerWarpText = PlayerWarpGUI.playerWarpText;
            if (a.getTitle() != null && a.getTitle().length() != 0) {
                playerWarpText = a.getTitle();
            }
            String title = a.getTitle();
            boolean enabled = true;
            String playerIcon = PlayerWarpGUI.defaultWarpIcon;
            if (PlayerWarpGUI.usePlayerHead) {
                ItemStack Item_Skull = new ItemStack(Material.SKULL_ITEM, 1, 3);
                SkullMeta Meta_Skull = (SkullMeta)Item_Skull.getItemMeta();
                ArrayList Lore_Skull = new ArrayList();
                Meta_Skull.setOwningPlayer(Bukkit.getOfflinePlayer((UUID)a.getPlayerUUID()));
                Lore_Skull.clear();
                Lore_Skull.add(null);
                Item_Skull.setItemMeta((ItemMeta)Meta_Skull);
                playerWarpItemStack = Item_Skull;
            } else {
                icon = playerIcon;
                if (a.getIcon() != null && a.getIcon().length() != 0) {
                    playerIcon = a.getIcon();
                }
                playerWarpItemStack = chestObject.parseString(playerIcon);
            }
            ArrayList<String> lore = new ArrayList<String>();
            List<String> loreList = a.getLoreList();
            lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)loreList.get(0)));
            lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)loreList.get(1)));
            lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)loreList.get(2)));
            lore.add(ChatColor.DARK_GRAY + "Warp ID: " + b);
            ItemMeta playerWarpMeta = playerWarpItemStack.getItemMeta();
            playerWarpMeta.setDisplayName(playerWarpText);
            playerWarpMeta.setLore(lore);
            playerWarpMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
            playerWarpItemStack.setItemMeta(playerWarpMeta);
            inv.setItem(i, playerWarpItemStack);
            ++i;
        }
        if (showNext) {
            ItemStack nextPageItemStack = chestObject.getNextPageItemStack(page + 1);
            inv.setItem(pageSize, nextPageItemStack);
        }
        player.openInventory(inv);
    }
}

