/*
 * Decompiled with CFR 0.152.
 */
package Managers;

import FileHandlers.PlayerWarpHandler;
import Objects.PlayerWarpObject;
import Objects.chestObject;
import PlayerWarpGUI.PlayerWarpGUI;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;

public class PlayerWarpManager {
    static PlayerWarpManager plugin;
    private static PlayerWarpManager playerWarpManager;

    static {
        playerWarpManager = new PlayerWarpManager(plugin);
    }

    public PlayerWarpManager(PlayerWarpManager playerWarpManager) {
        plugin = playerWarpManager;
    }

    public PlayerWarpManager(PlayerWarpGUI playerWarpGUI) {
    }

    public static boolean isSafeLocation(Location location) {
        Block blockLandsOn;
        Block feet = location.getBlock();
        if (!feet.getType().isTransparent() && !feet.getLocation().add(0.0, 1.0, 0.0).getBlock().getType().isTransparent()) {
            return false;
        }
        Block head = feet.getRelative(BlockFace.UP);
        if (!head.getType().isTransparent()) {
            return false;
        }
        Block ground = feet.getRelative(BlockFace.DOWN);
        if (!ground.getType().isSolid()) {
            return false;
        }
        int i = 0;
        while (i < PlayerWarpGUI.unsafeBlocks.size()) {
            blockLandsOn = feet;
            if (blockLandsOn.getType().equals((Object)chestObject.parseString(PlayerWarpGUI.unsafeBlocks.get(i)).getType())) {
                return false;
            }
            ++i;
        }
        i = 0;
        while (i < PlayerWarpGUI.unsafeBlocks.size()) {
            if (feet.getLocation().add(0.0, -1.0, 0.0).getBlock().getRelative(BlockFace.UP).getType().equals((Object)chestObject.parseString(PlayerWarpGUI.unsafeBlocks.get(i)).getType())) {
                return false;
            }
            ++i;
        }
        i = 0;
        while (i < PlayerWarpGUI.unsafeBlocks.size()) {
            blockLandsOn = feet.getRelative(BlockFace.DOWN);
            if (blockLandsOn.getType().equals((Object)chestObject.parseString(PlayerWarpGUI.unsafeBlocks.get(i)).getType())) {
                return false;
            }
            ++i;
        }
        i = 0;
        while (i < PlayerWarpGUI.unsafeBlocks.size()) {
            blockLandsOn = feet.getLocation().add(0.0, 1.0, 0.0).getBlock().getType();
            if (blockLandsOn.equals((Object)chestObject.parseString(PlayerWarpGUI.unsafeBlocks.get(i)).getType())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static PlayerWarpManager getPlayerWarpManager() {
        return playerWarpManager;
    }

    public static void removePlayerObject(UUID playerUUID) {
        PlayerWarpObject playerWarpObject = PlayerWarpManager.getPlayerWarpObject(playerUUID);
        playerWarpObject.removePlayerWarpObject(playerUUID);
        playerWarpObject = null;
    }

    public void updatePlayerObjectIcon(UUID playerUUID, String icon) {
        if (PlayerWarpManager.getPlayerWarpObject(playerUUID) != null) {
            PlayerWarpObject a = PlayerWarpManager.getPlayerWarpObject(playerUUID);
            a.setIcon(icon);
            PlayerWarpHandler.updateIcon(playerUUID, icon);
        }
    }

    public void updatePlayerObjectTitle(UUID playerUUID, String title) {
        if (PlayerWarpManager.getPlayerWarpObject(playerUUID) != null) {
            PlayerWarpObject a = PlayerWarpManager.getPlayerWarpObject(playerUUID);
            a.setTitle(title);
            PlayerWarpHandler.updateTitle(playerUUID, title);
        }
    }

    public void updatePlayerObjectLore(UUID playerUUID, String loreText, int loreLine) {
        if (PlayerWarpManager.getPlayerWarpObject(playerUUID) != null) {
            PlayerWarpObject a = PlayerWarpManager.getPlayerWarpObject(playerUUID);
            List<String> loreList = a.getLoreList();
            loreList.set(loreLine, loreText);
            a.setLoreList(loreList);
            PlayerWarpHandler.updatelore(playerUUID, loreList);
        }
    }

    public static PlayerWarpObject getPlayerWarpObject(UUID playerUUID) {
        for (PlayerWarpObject n : PlayerWarpGUI.playerWarpObjects) {
            if (!n.getPlayerUUID().equals(playerUUID)) continue;
            return n;
        }
        return null;
    }

    public Location getPlayerWarplocation(int warpID) {
        for (PlayerWarpObject n : PlayerWarpGUI.playerWarpObjects) {
            if (n.getUid() != warpID) continue;
            n.getWarpLocation();
        }
        return null;
    }

    public boolean checkPlayerWarpObject(UUID playerUUID) {
        for (PlayerWarpObject n : PlayerWarpGUI.playerWarpObjects) {
            if (!n.getPlayerUUID().equals(playerUUID)) continue;
            return true;
        }
        return false;
    }

    public void createWarpObjects(UUID playerUUID, String warpLocation, String title, String icon, List<String> loreList) {
        new PlayerWarpObject(playerUUID, warpLocation, title, icon, loreList);
    }

    public Location parseLoc(String str) {
        String[] arg = str.split(",");
        double[] parsed = new double[5];
        int a = 0;
        while (a < 3) {
            parsed[a] = Double.parseDouble(arg[a + 1]);
            ++a;
        }
        Location location = new Location(Bukkit.getServer().getWorld(arg[0]), parsed[0], parsed[1], parsed[2], (float)parsed[3], (float)parsed[4]);
        return location;
    }

    public Location str2loc(String str) {
        String[] str2loc = str.split("\\:");
        Location loc = new Location(Bukkit.getServer().getWorld(str2loc[0]), 0.0, 0.0, 0.0, 0.0f, 0.0f);
        loc.setX(Double.parseDouble(str2loc[1]));
        loc.setY(Double.parseDouble(str2loc[2]));
        loc.setZ(Double.parseDouble(str2loc[3]));
        loc.setYaw((float)Double.parseDouble(str2loc[4]));
        loc.setPitch((float)Double.parseDouble(str2loc[5]));
        return loc;
    }

    public String loc2str(Location loc) {
        return String.valueOf(loc.getWorld().getName()) + ":" + loc.getBlockX() + ":" + loc.getBlockY() + ":" + loc.getBlockZ() + ":" + loc.getYaw() + ":" + loc.getPitch();
    }
}

