/*
 * Decompiled with CFR 0.152.
 */
package Listeners;

import Managers.PlayerWarpManager;
import Objects.chestObject;
import PlayerWarpGUI.PlayerWarpGUI;
import Utils.A;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class ChestListener
implements Listener {
    public static PlayerWarpGUI plugin;
    final Map<UUID, BukkitTask> tpQueue = new HashMap<UUID, BukkitTask>();
    final Map<UUID, BukkitTask> godModeQueue = new HashMap<UUID, BukkitTask>();

    public ChestListener(PlayerWarpGUI playerWarpGUI) {
        plugin = playerWarpGUI;
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onInventoryClick(InventoryClickEvent e) {
        if (e.getWhoClicked() instanceof Player && e.getInventory().getName().contains(chestObject.replaceColorVariables(PlayerWarpGUI.chestText))) {
            e.setCancelled(true);
            if (e.getSlot() < 0) {
                return;
            }
            if (e.getCurrentItem().getItemMeta() == null) {
                return;
            }
            if (e.getInventory().getType() != InventoryType.CHEST) {
                return;
            }
            if (e.getCurrentItem().getItemMeta().getDisplayName() == null) {
                return;
            }
            Player player = (Player)e.getWhoClicked();
            if (e.getCurrentItem().getItemMeta().getDisplayName().contains("Next")) {
                int nextPageNum;
                try (Scanner in = null;){
                    in = new Scanner(e.getCurrentItem().getItemMeta().getDisplayName()).useDelimiter("[^0-9]+");
                    nextPageNum = in.nextInt();
                }
                e.getWhoClicked().closeInventory();
                chestObject.openGUI(player, nextPageNum);
                return;
            }
            int warpID = chestObject.getWarpID(e.getCurrentItem());
            Location warpLocation = chestObject.getWarpLocation(warpID);
            if (PlayerWarpGUI.useSafeWarp && !PlayerWarpManager.isSafeLocation(warpLocation)) {
                player.sendMessage(A.b(" &7Teleport cancelled, location was unsafe to teleport to.", player.getDisplayName()));
                return;
            }
            String world = warpLocation.getWorld().getName().toString();
            int i = 0;
            while (i < PlayerWarpGUI.disabledWorlds.size()) {
                if (PlayerWarpGUI.disabledWorlds.get(i).equalsIgnoreCase(world)) {
                    player.sendMessage(A.b(" &7Teleport cancelled, you cannot teleport to that world.", player.getDisplayName()));
                    return;
                }
                ++i;
            }
            this.tpQueue.put(player.getUniqueId(), new Teleport(PlayerWarpGUI.cooldown, player.getUniqueId(), warpLocation).runTaskTimer(PlayerWarpGUI.getInstance(), 0L, 20L));
            e.getWhoClicked().closeInventory();
        }
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent e) {
        Player p = e.getPlayer();
        if (PlayerWarpGUI.cancelOnMovement && this.tpQueue.containsKey(p.getUniqueId())) {
            this.tpQueue.get(p.getUniqueId()).cancel();
            this.tpQueue.remove(p.getUniqueId());
            p.sendMessage(A.c("&7Teleport cancelled.", p.getName()));
        }
    }

    @EventHandler
    public void onPlayerDamage(EntityDamageEvent e) {
        if (e.getEntity() instanceof Player && this.godModeQueue.containsKey(e.getEntity().getUniqueId())) {
            e.setCancelled(true);
        }
    }

    private class GodMode
    extends BukkitRunnable {
        int count;
        UUID player;

        GodMode(int count, UUID player) {
            this.count = count;
            this.player = player;
            Bukkit.getPlayer((UUID)player).sendMessage(A.c("&7GodMode Ends In: &6" + count, Bukkit.getPlayer((UUID)player).getName()));
        }

        public void run() {
            if (this.count > 0) {
                --this.count;
            } else {
                ChestListener.this.godModeQueue.remove(this.player);
                this.cancel();
                Bukkit.getPlayer((UUID)this.player).sendMessage(A.c("&7GodMode has ended.", Bukkit.getPlayer((UUID)this.player).getName()));
            }
        }
    }

    private class Teleport
    extends BukkitRunnable {
        int count;
        UUID player;
        Location loc;

        Teleport(int count, UUID player, Location loc) {
            this.count = count;
            this.player = player;
            this.loc = loc;
        }

        public void run() {
            if (this.count > 0) {
                Bukkit.getPlayer((UUID)this.player).sendMessage(A.c("&7teleporting in: &6" + this.count, Bukkit.getPlayer((UUID)this.player).getName()));
                --this.count;
            } else {
                Bukkit.getPlayer((UUID)this.player).teleport(this.loc);
                ChestListener.this.tpQueue.remove(this.player);
                this.cancel();
                Bukkit.getPlayer((UUID)this.player).sendMessage(A.c("&7teleport Completed.", Bukkit.getPlayer((UUID)this.player).getName()));
                if (PlayerWarpGUI.godModeAfterTP > 0) {
                    ChestListener.this.godModeQueue.put(this.player, new GodMode(PlayerWarpGUI.godModeAfterTP, this.player).runTaskTimer(PlayerWarpGUI.getInstance(), 0L, 20L));
                }
            }
        }
    }
}

