/*
 * Decompiled with CFR 0.152.
 */
package FileHandlers;

import FileHandlers.ConfigHandler;
import Managers.PlayerWarpManager;
import Objects.PlayerWarpObject;
import PlayerWarpGUI.PlayerWarpGUI;
import Utils.A;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.configuration.file.YamlConfiguration;

public class PlayerWarpHandler {
    public static PlayerWarpGUI plugin;

    public PlayerWarpHandler(PlayerWarpGUI playerWarpGUI) {
        plugin = playerWarpGUI;
    }

    public static List<PlayerWarpObject> getPlayerWarpObjects() {
        return PlayerWarpGUI.playerWarpObjects;
    }

    public static boolean createPlayerWarpFile(UUID uuid) {
        File playerDataFile = new File(String.valueOf(PlayerWarpGUI.instance.warpsFolder) + File.separator + uuid.toString() + ".yml");
        playerDataFile.getParentFile().mkdirs();
        ConfigHandler.copy(plugin.getResource("defaultWarpConfig.yml"), playerDataFile);
        return true;
    }

    public static boolean deletePlayerWarpFile(UUID uuid) {
        File playerDataFile = new File(String.valueOf(PlayerWarpGUI.instance.warpsFolder) + File.separator + uuid.toString() + ".yml");
        playerDataFile.delete();
        return true;
    }

    public static File savePlayerWarpObject(UUID uuid, Location location) {
        File playerDataFile = new File(String.valueOf(PlayerWarpGUI.instance.warpsFolder) + File.separator + uuid.toString() + ".yml");
        YamlConfiguration config = new YamlConfiguration();
        try {
            config.load(playerDataFile);
            config.set("warpDetails.location", (Object)PlayerWarpManager.getPlayerWarpManager().loc2str(location));
            config.set("playerData.UUID", (Object)uuid.toString());
            config.set("warpDetails.title", (Object)"");
            config.save(playerDataFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return playerDataFile;
    }

    public static File updateIcon(UUID uuid, String icon) {
        File playerDataFile = new File(String.valueOf(PlayerWarpGUI.instance.warpsFolder) + File.separator + uuid.toString() + ".yml");
        YamlConfiguration config = new YamlConfiguration();
        try {
            config.load(playerDataFile);
            config.set("warpDetails.icon", (Object)icon);
            config.save(playerDataFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return playerDataFile;
    }

    public static File updateTitle(UUID uuid, String title) {
        File playerDataFile = new File(String.valueOf(PlayerWarpGUI.instance.warpsFolder) + File.separator + uuid.toString() + ".yml");
        YamlConfiguration config = new YamlConfiguration();
        try {
            config.load(playerDataFile);
            config.set("warpDetails.title", (Object)title);
            config.save(playerDataFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return playerDataFile;
    }

    public static File updatelore(UUID uuid, List<String> lore) {
        File playerDataFile = new File(String.valueOf(PlayerWarpGUI.instance.warpsFolder) + File.separator + uuid.toString() + ".yml");
        YamlConfiguration config = new YamlConfiguration();
        try {
            config.load(playerDataFile);
            config.set("warpDetails.lore", lore);
            config.save(playerDataFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return playerDataFile;
    }

    public static boolean createObjectFromWarpFile(File file) {
        ArrayList loreList;
        UUID playerUUID = null;
        String playerName = null;
        String warpLocation = null;
        String uuid = null;
        String icon = null;
        String title = null;
        boolean enbaled = true;
        try {
            playerUUID = UUID.fromString(file.getName().replace(".yml", ""));
        }
        catch (IllegalArgumentException exception) {
            return true;
        }
        if (PlayerWarpManager.getPlayerWarpManager().checkPlayerWarpObject(playerUUID)) {
            A.d("Cannot load PlayerWarp file: Warp object already exsists");
            return true;
        }
        YamlConfiguration config = new YamlConfiguration();
        try {
            config.load(file);
            A.d("LOADED PLAYERWARP FILE: " + playerUUID.toString());
            playerName = Bukkit.getServer().getOfflinePlayer(playerUUID).getName();
            A.d("   playerName: " + playerName);
            warpLocation = config.getString("warpDetails.location");
            A.d("   warpLocation: " + warpLocation);
            icon = config.getString("warpDetails.icon");
            A.d("   icon: " + icon);
            title = config.getString("warpDetails.title");
            A.d("   title: " + title);
            uuid = config.getString("playerData.UUID");
            A.d("   uuid: " + uuid);
            loreList = (ArrayList)config.getList("warpDetails.lore");
            int l = 0;
            for (String x : loreList) {
                A.d("   lore: " + x);
                ++l;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return true;
        }
        PlayerWarpManager.getPlayerWarpManager().createWarpObjects(playerUUID, warpLocation, title, icon, loreList);
        return true;
    }

    public void loadAllWarpObjects() {
        File warpsFolder;
        if (!PlayerWarpGUI.playerWarpHandler.checkWarpFolder()) {
            PlayerWarpGUI.playerWarpHandler.createWarpFolder();
        }
        if ((warpsFolder = new File(PlayerWarpHandler.plugin.warpsFolder)).listFiles() != null) {
            File[] fileArray = warpsFolder.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                PlayerWarpHandler.createObjectFromWarpFile(file);
                ++n2;
            }
        }
    }

    public void createWarpFolder() {
        File playerWarpFolder = new File(PlayerWarpHandler.plugin.warpsFolder);
        playerWarpFolder.mkdirs();
    }

    public boolean checkWarpFolder() {
        File playerWarpFolder = new File(PlayerWarpHandler.plugin.warpsFolder);
        return playerWarpFolder.exists();
    }
}

