/*
 * Decompiled with CFR 0.152.
 */
package FileHandlers;

import PlayerWarpGUI.PlayerWarpGUI;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigHandler {
    public static PlayerWarpGUI plugin;

    public ConfigHandler(PlayerWarpGUI playerWarpGUI) {
        plugin = playerWarpGUI;
    }

    public void loadConfigFile() {
        if (!this.checkConfigFile()) {
            this.createConfigFile();
        }
        YamlConfiguration config = new YamlConfiguration();
        try {
            config.load(ConfigHandler.plugin.configFile);
            if (config.getString("Metrics.enabled") == null) {
                File saveTo = new File(ConfigHandler.plugin.configFile);
                FileWriter fw = new FileWriter(saveTo, true);
                PrintWriter pw = new PrintWriter(fw);
                pw.println("Metrics:");
                pw.println("  enabled: true");
                pw.flush();
                pw.close();
            }
            PlayerWarpGUI.useSafeWarp = config.getBoolean("SafeWarp.enabled", false);
            PlayerWarpGUI.unsafeBlocks = config.getStringList("SafeWarp.unsafeBlocks");
            int theTotalNumberOfElements = PlayerWarpGUI.unsafeBlocks.size();
            int counter = 0;
            while (counter < theTotalNumberOfElements) {
                ++counter;
            }
            PlayerWarpGUI.cooldown = config.getInt("Teleport.cooldown", 3);
            PlayerWarpGUI.cancelOnMovement = config.getBoolean("Teleport.cancelOnMovement", true);
            PlayerWarpGUI.godModeAfterTP = config.getInt("Teleport.godModeAfterTP", 0);
            PlayerWarpGUI.defaultWarpIcon = config.getString("GUI.DefaultWarpIcon", "35:9");
            PlayerWarpGUI.nextPageIcon = config.getString("GUI.nextPageIcon", "35:8");
            PlayerWarpGUI.messagePrefix = config.getString("Messages.prefix", "[PlayerWarpGUI]");
            PlayerWarpGUI.chestSize = config.getInt("GUI.rows") * 9;
            PlayerWarpGUI.chestText = config.getString("GUI.chestText", "PlayerWarpGUI");
            PlayerWarpGUI.playerWarpText = config.getString("GUI.playerWarpText", "&6[username]");
            PlayerWarpGUI.setWarpCost = config.getInt("Settings.setWarpCost", 0);
            PlayerWarpGUI.disabledWorlds = config.getStringList("Settings.disabledWorlds");
            PlayerWarpGUI.enableGriefPrevetion = config.getBoolean("GriefPrevetion.enabled", false);
            PlayerWarpGUI.enableWorldGuard = config.getBoolean("WorldGuard.enabled", false);
            PlayerWarpGUI.useOwners = config.getBoolean("WorldGuard.enabled", false);
            PlayerWarpGUI.useMembers = config.getBoolean("WorldGuard.enabled", false);
            PlayerWarpGUI.enableRedProtect = config.getBoolean("RedProtect.enabled", false);
            PlayerWarpGUI.useRPAdmins = config.getBoolean("RedProtect.admins", false);
            PlayerWarpGUI.useRPLeaders = config.getBoolean("RedProtect.leaders", false);
            PlayerWarpGUI.useRPMembers = config.getBoolean("RedProtect.members", false);
            PlayerWarpGUI.DEBUG_MODE = config.getBoolean("Settings.debug_mode", false);
            PlayerWarpGUI.useMetrics = config.getBoolean("Metrics.enabled", false);
            PlayerWarpGUI.maxTitleSize = config.getInt("Settings.maxTitleSize", 25);
            PlayerWarpGUI.maxLoreSize = !config.isSet("Settings.maxLoreSize") ? 40 : config.getInt("Settings.maxLoreSize", 40);
            PlayerWarpGUI.usePlayerHead = config.getBoolean("GUI.usePlayerHead", false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void createConfigFile() {
        File configFile = new File(ConfigHandler.plugin.configFile);
        configFile.getParentFile().mkdirs();
        ConfigHandler.copy(plugin.getResource(ConfigHandler.plugin.defaultConfigFile), configFile);
    }

    public boolean checkConfigFile() {
        File playerWarpDataFile = new File(ConfigHandler.plugin.configFile);
        return playerWarpDataFile.exists();
    }

    public static void copy(InputStream in, File file) {
        try {
            int len;
            FileOutputStream out = new FileOutputStream(file);
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((OutputStream)out).close();
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

