/*
 * Decompiled with CFR 0.152.
 */
package me.smurfy129.tutorial;

import com.connorlinfoot.titleapi.TitleAPI;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import me.smurfy129.tutorial.Main;
import me.smurfy129.tutorial.Metrics;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class SubCommands {
    HashMap<String, String> playerSign = new HashMap();
    ArrayList<String> noMoveFlightPlayer = new ArrayList();
    Main plugin;

    public SubCommands(Main plugin) {
        this.plugin = plugin;
    }

    public void newCommand(Player player, String[] args) {
        String tutorialName = args[1];
        if (Main.plugin.getConfig().contains("Tutorials." + tutorialName)) {
            player.sendMessage(ChatColor.RED + "This tutorial already exists!");
        } else {
            player.getInventory().addItem(new ItemStack[]{new ItemStack(Material.SIGN, 1)});
            player.sendMessage(ChatColor.GRAY + "[EzTutorial] " + ChatColor.AQUA + "Place this sign to save your tutorial!");
            this.playerSign.put(player.getDisplayName(), tutorialName);
        }
    }

    public void setLocationCommand(Player player, String[] args) {
        String tutorialName = args[1];
        try {
            int locationNumber = Integer.parseInt(args[2]);
            Location loc = player.getLocation();
            if (Main.plugin.getConfig().contains("Tutorials." + tutorialName)) {
                if (Main.plugin.getConfig().contains("Tutorials." + tutorialName + "." + locationNumber)) {
                    player.sendMessage(ChatColor.RED + "The tutorial \"" + tutorialName + "\" already has a location " + locationNumber);
                } else {
                    double xLocation = loc.getX();
                    double yLocation = loc.getY();
                    double zLocation = loc.getZ();
                    float pitch = loc.getPitch();
                    float yaw = loc.getYaw();
                    Main.plugin.getConfig().set("Tutorials." + tutorialName + "." + locationNumber + ".Message" + ".Enabled", (Object)true);
                    Main.plugin.getConfig().set("Tutorials." + tutorialName + "." + locationNumber + ".Message" + ".Message", (Object)"Default Message");
                    if (Main.plugin.getServer().getPluginManager().getPlugin("TitleAPI") != null) {
                        Main.plugin.getConfig().set("Tutorials." + tutorialName + "." + locationNumber + ".Message" + ".TitleAsMessage", (Object)true);
                    } else {
                        Main.plugin.getConfig().set("Tutorials." + tutorialName + "." + locationNumber + ".Message" + ".TitleAsMessage", (Object)false);
                    }
                    Main.plugin.getConfig().set("Tutorials." + tutorialName + "." + locationNumber + ".Message" + ".Location Name", (Object)("" + locationNumber));
                    Main.plugin.getConfig().set("Tutorials." + tutorialName + "." + locationNumber + ".X", (Object)xLocation);
                    Main.plugin.getConfig().set("Tutorials." + tutorialName + "." + locationNumber + ".Y", (Object)yLocation);
                    Main.plugin.getConfig().set("Tutorials." + tutorialName + "." + locationNumber + ".Z", (Object)zLocation);
                    Main.plugin.getConfig().set("Tutorials." + tutorialName + "." + locationNumber + ".Pitch", (Object)Float.valueOf(pitch));
                    Main.plugin.getConfig().set("Tutorials." + tutorialName + "." + locationNumber + ".Yaw", (Object)Float.valueOf(yaw));
                    Main.plugin.getConfig().set("Tutorials." + tutorialName + "." + locationNumber + ".World", (Object)player.getWorld().getName());
                    Main.plugin.saveConfig();
                    player.sendMessage(ChatColor.GRAY + "[EzTutorial] " + ChatColor.AQUA + "Location " + ChatColor.GRAY + locationNumber + ChatColor.AQUA + " has been saved in tutorial " + ChatColor.GRAY + "\"" + tutorialName + "\"");
                }
            } else {
                player.sendMessage(ChatColor.RED + "Tutorial \"" + tutorialName + "\" does not exist, you have to create a tutorial before you set locations");
            }
        }
        catch (Exception ex) {
            player.sendMessage(ChatColor.RED + "The location number given is not a vaild integer number");
        }
    }

    public void delLocationCommand(Player player, String[] args) {
        String tutorialName = args[1];
        try {
            int locationNumber = Integer.parseInt(args[2]);
            if (Main.plugin.getConfig().contains("Tutorials." + tutorialName + "." + locationNumber)) {
                Main.plugin.getConfig().set("Tutorials." + tutorialName + "." + locationNumber, null);
                Main.plugin.saveConfig();
                player.sendMessage(ChatColor.GRAY + "[EzTutorial] " + ChatColor.AQUA + "Location " + ChatColor.GRAY + locationNumber + ChatColor.AQUA + " has been deleted from tutorial " + ChatColor.GRAY + "\"" + tutorialName + "\"");
            } else {
                player.sendMessage(ChatColor.RED + "Location " + locationNumber + " can not be deleted because it doesn't exist");
            }
        }
        catch (Exception ex) {
            player.sendMessage(ChatColor.RED + "The location number given is not a vaild integer number");
        }
    }

    public void delTutorial(Player player, String[] args) {
        String tutorialName = args[1];
        if (Main.plugin.getConfig().contains("Tutorials." + tutorialName)) {
            Main.plugin.getConfig().set("Tutorials." + tutorialName, null);
            Main.plugin.saveConfig();
            player.sendMessage(ChatColor.GRAY + "[EzTutorial] " + ChatColor.AQUA + "The tutorial " + ChatColor.GRAY + "\"" + tutorialName + "\"" + ChatColor.AQUA + " has been deleted");
        } else {
            player.sendMessage(ChatColor.RED + "Tutorial \"" + tutorialName + "\" can not be deleted because it doesn't exist");
        }
    }

    public void listCommand(Player player, String[] args) {
        try {
            Set tutorials = Main.plugin.getConfig().getConfigurationSection("Tutorials.").getKeys(false);
            if (tutorials.size() == 0) {
                if (player.hasPermission("tutorial.new")) {
                    player.sendMessage(ChatColor.RED + "No tutorials have been created so far, make a new one with /tutorial new <tutorial name>");
                } else {
                    player.sendMessage(ChatColor.RED + "There are no tutorials available");
                }
            } else {
                player.sendMessage("");
                player.sendMessage(ChatColor.GRAY + "---------- " + ChatColor.AQUA + "EzTutorial" + ChatColor.GRAY + " ----------");
                for (String s : tutorials) {
                    Set locs = Main.plugin.getConfig().getConfigurationSection("Tutorials." + s).getKeys(false);
                    String locationNames = "";
                    boolean first = true;
                    int nonLocs = 0;
                    for (String s2 : locs) {
                        if (s2.equalsIgnoreCase("Reward") || s2.equalsIgnoreCase("Delay In Seconds") || s2.equalsIgnoreCase("Move During Tutorial") || s2.equalsIgnoreCase("Fly During Tutorial") || s2.equalsIgnoreCase("End Message")) {
                            ++nonLocs;
                            continue;
                        }
                        String name = Main.plugin.getConfig().getString("Tutorials." + s + "." + s2 + ".Message.Location Name");
                        if (locs.size() - nonLocs == 1 || first) {
                            locationNames = name;
                            first = false;
                            continue;
                        }
                        locationNames = String.valueOf(locationNames) + ", " + name;
                    }
                    player.sendMessage(ChatColor.GRAY + "Name: " + ChatColor.AQUA + s + ChatColor.GRAY + "            Locations: " + ChatColor.AQUA + locationNames);
                }
            }
        }
        catch (Exception ex) {
            if (player.hasPermission("tutorial.new")) {
                player.sendMessage(ChatColor.RED + "No tutorials have been created so far, make a new one with /tutorial new <tutorial name>");
            }
            player.sendMessage(ChatColor.RED + "There are no tutorials available");
        }
    }

    public void startTutorial(final Player player, String tutName) {
        boolean titles;
        final String tutorialName = tutName;
        final HashMap<String, Location> tutorialLocations = new HashMap<String, Location>();
        Set data = Main.plugin.getConfig().getConfigurationSection("Tutorials." + tutorialName).getKeys(false);
        int dataTemp = 0;
        int i = 1;
        while (i < data.size()) {
            if (!Main.plugin.getConfig().contains("Tutorials." + tutorialName + "." + i)) break;
            ++dataTemp;
            ++i;
        }
        final int dataNum = dataTemp;
        final Location playerLocation = player.getLocation();
        final Long delay = Main.plugin.getConfig().getLong("Tutorials." + tutorialName + ".Delay In Seconds") * 20L;
        final boolean flyBefore = player.getAllowFlight();
        final boolean flyingBefore = player.isFlying();
        boolean canYouFly = false;
        boolean bl = titles = Main.plugin.getServer().getPluginManager().getPlugin("TitleAPI") != null;
        if (dataNum == 0) {
            player.sendMessage(ChatColor.RED + "There are no locations on this tutorial. Add one before trying to start again, /tutorial setlocation " + tutName + " 1");
            return;
        }
        int i2 = 1;
        while (i2 <= dataNum) {
            double x = Main.plugin.getConfig().getDouble("Tutorials." + tutorialName + "." + i2 + ".X");
            double y = Main.plugin.getConfig().getDouble("Tutorials." + tutorialName + "." + i2 + ".Y");
            double z = Main.plugin.getConfig().getDouble("Tutorials." + tutorialName + "." + i2 + ".Z");
            String name = Main.plugin.getConfig().getString("Tutorials." + tutorialName + "." + i2 + ".World") == null ? player.getWorld().getName() : Main.plugin.getConfig().getString("Tutorials." + tutorialName + "." + i2 + ".World");
            World w = Main.plugin.getServer().getWorld(name);
            Location loc = new Location(w, x, y, z);
            tutorialLocations.put("" + i2, loc);
            ++i2;
        }
        if (!Main.plugin.getConfig().getBoolean("Tutorials." + tutorialName + ".Move During Tutorial")) {
            player.setWalkSpeed(0.0f);
            player.addPotionEffect(new PotionEffect(PotionEffectType.JUMP, 10000, 128));
        }
        if (Main.plugin.getConfig().getBoolean("Tutorials." + tutorialName + ".Fly During Tutorial")) {
            if (!flyBefore) {
                player.setAllowFlight(true);
            }
            canYouFly = true;
            if (!Main.plugin.getConfig().getBoolean("Tutorials." + tutorialName + ".Move During Tutorial")) {
                player.setFlySpeed(0.0f);
                this.noMoveFlightPlayer.add(player.getDisplayName());
            }
        }
        final boolean canYouFlyFinal = canYouFly;
        new BukkitRunnable(){
            int counter = 1;

            public void run() {
                if (this.counter <= dataNum) {
                    float pitch = (float)Main.plugin.getConfig().getDouble("Tutorials." + tutorialName + "." + this.counter + ".Pitch");
                    float yaw = (float)Main.plugin.getConfig().getDouble("Tutorials." + tutorialName + "." + this.counter + ".Yaw");
                    Location tele = (Location)tutorialLocations.get("" + this.counter);
                    tele.setPitch(pitch);
                    tele.setYaw(yaw);
                    player.teleport(tele);
                    if (canYouFlyFinal) {
                        player.setFlying(true);
                    }
                    if (Main.plugin.getConfig().getBoolean("Tutorials." + tutorialName + "." + this.counter + ".Message" + ".Enabled")) {
                        String locationMsg = Main.plugin.getConfig().getString("Tutorials." + tutorialName + "." + this.counter + ".Message" + ".Message");
                        String locationName = Main.plugin.getConfig().getString("Tutorials." + tutorialName + "." + this.counter + ".Message" + ".Location Name");
                        if (titles && Main.plugin.getConfig().getBoolean("Tutorials." + tutorialName + "." + this.counter + ".Message" + ".TitleAsMessage")) {
                            TitleAPI.sendTitle((Player)player, (Integer)5, (Integer)((int)(delay - 10L)), (Integer)5, (String)locationName, (String)locationMsg);
                        } else {
                            player.sendMessage("-------------------(" + locationName + ")-------------------");
                            player.sendMessage(ChatColor.AQUA + locationMsg);
                        }
                    }
                    ++this.counter;
                } else {
                    this.cancel();
                    if (!Main.plugin.getConfig().getBoolean("Tutorials." + tutorialName + ".Move During Tutorial")) {
                        player.setWalkSpeed(0.2f);
                        player.removePotionEffect(PotionEffectType.JUMP);
                    }
                    if (Main.plugin.getConfig().getBoolean("Tutorials." + tutorialName + ".Fly During Tutorial")) {
                        if (!flyBefore) {
                            player.setAllowFlight(false);
                        }
                        if (flyingBefore && flyBefore) {
                            player.setFlying(true);
                        } else {
                            player.setFlying(false);
                        }
                        if (!Main.plugin.getConfig().getBoolean("Tutorials." + tutorialName + ".Move During Tutorial")) {
                            SubCommands.this.noMoveFlightPlayer.remove(player.getDisplayName());
                            player.setFlySpeed(0.1f);
                        }
                    }
                    if (Main.plugin.getConfig().getBoolean("Tutorials." + tutorialName + ".End Message" + ".Enabled")) {
                        String endMessage = Main.plugin.getConfig().getString("Tutorials." + tutorialName + ".End Message" + ".Message");
                        player.sendMessage(ChatColor.GRAY + endMessage);
                    }
                    if (Main.plugin.getConfig().getBoolean("Tutorials." + tutorialName + ".Reward" + ".Money" + ".Enabled")) {
                        if (Main.plugin.setupEconomy()) {
                            double moneyAmount = Main.plugin.getConfig().getDouble("Tutorials." + tutorialName + ".Reward" + ".Money" + ".Amount");
                            EconomyResponse r = Main.economy.depositPlayer((OfflinePlayer)player, moneyAmount);
                            if (r.transactionSuccess()) {
                                player.sendMessage(ChatColor.GRAY + "You are rewarded with " + ChatColor.AQUA + moneyAmount + ChatColor.GRAY + " for doing this tutorial");
                            } else {
                                player.sendMessage(ChatColor.RED + "Error transaction failed contact a server admin!");
                                Bukkit.getServer().getConsoleSender().sendMessage("[EzTutorial] " + ChatColor.RED + "Error, transaction failed on tutorial " + tutorialName + ". Player " + player.getDisplayName() + " did not receive their reward of " + moneyAmount + ". Something is wrong with your economy plugin or vault. If you can't resolve the issue check out the spigot page for help.");
                            }
                        } else {
                            Main.plugin.myLog.info("[EzTutorial] No economy plugin found, money rewards can't be given!");
                        }
                    }
                    if (Main.plugin.getConfig().getBoolean("Tutorials." + tutorialName + ".Reward" + ".Item" + ".Enabled")) {
                        String rewardType = Main.plugin.getConfig().getString("Tutorials." + tutorialName + ".Reward" + ".Item" + ".Item Name");
                        String upperReward = rewardType.toUpperCase();
                        int rewardQuantity = Main.plugin.getConfig().getInt("Tutorials." + tutorialName + ".Reward" + ".Item" + ".Amount");
                        try {
                            player.getInventory().addItem(new ItemStack[]{new ItemStack(Material.valueOf((String)upperReward), rewardQuantity)});
                            player.sendMessage(ChatColor.GRAY + "You are rewarded " + ChatColor.AQUA + rewardQuantity + " " + upperReward + ChatColor.GRAY + " for doing this tutorial!");
                        }
                        catch (IllegalArgumentException e) {
                            Bukkit.getServer().getConsoleSender().sendMessage("[EzTutorial] " + ChatColor.RED + "Error, invalid item set as a reward for tutorial " + tutorialName + ". Player " + player.getDisplayName() + " did not receive their reward of item " + rewardType + ". Check out the spigot page for how to set rewards correctly.");
                        }
                    }
                    player.teleport(playerLocation);
                    try {
                        Metrics metrics = new Metrics((Plugin)SubCommands.this.plugin);
                        Metrics.Graph tutorialsRun = metrics.createGraph("Tutorials Run");
                        tutorialsRun.addPlotter(new Metrics.Plotter("Number of Tutorials"){

                            @Override
                            public int getValue() {
                                return 1;
                            }
                        });
                        metrics.start();
                    }
                    catch (IOException e) {
                        Main.plugin.myLog.info("[EzTutorial] ran into a problem with Tutorials Run metrics. Please report to Smurfy129 on Spigot or Bukkit.");
                        Main.plugin.myLog.info(e.getMessage());
                    }
                }
            }
        }.runTaskTimer((Plugin)Main.plugin, 0L, delay.longValue());
    }
}

