/*
 * Decompiled with CFR 0.152.
 */
package me.smurfy129.tutorial;

import java.io.IOException;
import me.smurfy129.tutorial.Main;
import me.smurfy129.tutorial.Metrics;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.block.Sign;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerToggleFlightEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffectType;

public class PluginListener
implements Listener {
    @EventHandler
    public void onSignChange(SignChangeEvent e) {
        Player player = e.getPlayer();
        if (Main.plugin.subCmds.playerSign.containsKey(player.getDisplayName())) {
            String tutorialName = Main.plugin.subCmds.playerSign.get(player.getDisplayName());
            e.setLine(0, "[EzTutorial]");
            e.setLine(1, ChatColor.WHITE + "Start");
            e.setLine(2, ChatColor.AQUA + tutorialName);
            Main.plugin.getConfig().set("Tutorials." + tutorialName + ".Reward" + ".Item" + ".Enabled", (Object)false);
            Main.plugin.getConfig().set("Tutorials." + tutorialName + ".Reward" + ".Item" + ".Item Name", (Object)"DIAMOND");
            Main.plugin.getConfig().set("Tutorials." + tutorialName + ".Reward" + ".Item" + ".Amount", (Object)1);
            Main.plugin.getConfig().set("Tutorials." + tutorialName + ".Reward" + ".Money" + ".Enabled", (Object)false);
            Main.plugin.getConfig().set("Tutorials." + tutorialName + ".Reward" + ".Money" + ".Amount", (Object)1000);
            Main.plugin.getConfig().set("Tutorials." + tutorialName + ".Delay In Seconds", (Object)5);
            Main.plugin.getConfig().set("Tutorials." + tutorialName + ".Move During Tutorial", (Object)false);
            Main.plugin.getConfig().set("Tutorials." + tutorialName + ".Fly During Tutorial", (Object)false);
            Main.plugin.getConfig().set("Tutorials." + tutorialName + ".End Message" + ".Enabled", (Object)false);
            Main.plugin.getConfig().set("Tutorials." + tutorialName + ".End Message" + ".Message", (Object)"Thank you for learning more with EzTutorials");
            Main.plugin.saveConfig();
            Main.plugin.subCmds.playerSign.remove(player.getDisplayName());
            player.sendMessage(ChatColor.GRAY + "[EzTutorial] " + ChatColor.AQUA + "The tutorial " + ChatColor.GRAY + "\"" + tutorialName + "\"" + ChatColor.AQUA + " has been saved!");
            if (tutorialName.length() > 15) {
                player.sendMessage(ChatColor.GRAY + "[EzTutorial] " + ChatColor.AQUA + "The tutorial name is too long to work with start signs. However npcs and /tutorial startplayer will still work!");
            }
            try {
                Metrics metrics = new Metrics((Plugin)Main.plugin);
                Metrics.Graph weaponsUsedGraph = metrics.createGraph("Tutorials Created");
                weaponsUsedGraph.addPlotter(new Metrics.Plotter("Number of Tutorials"){

                    @Override
                    public int getValue() {
                        return 1;
                    }
                });
                metrics.start();
            }
            catch (IOException ex) {
                Main.plugin.myLog.info("[EzTutorial] ran into a problem with Tutorials Created metrics. Please report to Smurfy129 on Spigot or Bukkit.");
                Main.plugin.myLog.info(ex.getMessage());
            }
        }
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent e) {
        if (e.getAction() == Action.RIGHT_CLICK_BLOCK && e.getClickedBlock().getState() instanceof Sign) {
            Player player = e.getPlayer();
            Sign s = (Sign)e.getClickedBlock().getState();
            String firstLine = s.getLine(0);
            String secondLine = s.getLine(1);
            String tutorialName = ChatColor.stripColor((String)s.getLine(2));
            if (ChatColor.stripColor((String)firstLine).equalsIgnoreCase("[EzTutorial]") && ChatColor.stripColor((String)secondLine).equalsIgnoreCase("Start") && Main.plugin.getConfig().contains("Tutorials." + tutorialName)) {
                if (player.hasPermission("tutorial.start.sign")) {
                    Main.plugin.subCmds.startTutorial(player, tutorialName);
                } else {
                    player.sendMessage(ChatColor.RED + "You don't have permission to start this tutorial!");
                }
            }
        }
    }

    @EventHandler
    public void onEntityDamage(EntityDamageByEntityEvent e) {
        Entity attacker = e.getDamager();
        if (attacker instanceof Player) {
            Player p = (Player)e.getDamager();
            if (e.getEntity() instanceof LivingEntity) {
                LivingEntity ent = (LivingEntity)e.getEntity();
                String tutName = ent.getCustomName();
                if (Main.plugin.getConfig().contains("Tutorials." + tutName)) {
                    if (p.hasPermission("tutorial.start.npc")) {
                        e.setCancelled(true);
                        Main.plugin.subCmds.startTutorial(p, tutName);
                    } else {
                        p.sendMessage(ChatColor.RED + "You don't have permission to use this command!");
                    }
                }
            }
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent e) {
        Player player = e.getPlayer();
        player.setWalkSpeed(0.2f);
        player.removePotionEffect(PotionEffectType.JUMP);
        if (!player.hasPlayedBefore() && Main.plugin.getConfig().getBoolean("New Players Default Tutorial.Enabled")) {
            String tutorialName = Main.plugin.getConfig().getString("New Players Default Tutorial.Tutorial Name");
            if (Main.plugin.getConfig().getBoolean("New Players Default Tutorial.Join Message.Enabled")) {
                String joinMessage = Main.plugin.getConfig().getString("New Players Default Tutorial.Join Message.Message");
                player.sendMessage(ChatColor.AQUA + joinMessage);
            }
            Main.plugin.subCmds.startTutorial(player, tutorialName);
        }
    }

    @EventHandler
    public void onToggleFlight(PlayerToggleFlightEvent e) {
        Player player = e.getPlayer();
        Location pLoc = player.getLocation();
        if (Main.plugin.subCmds.noMoveFlightPlayer.contains(player.getDisplayName())) {
            e.setCancelled(true);
            player.teleport(pLoc);
        }
    }
}

