/*
 * Decompiled with CFR 0.152.
 */
package me.smurfy129.tutorial;

import java.io.IOException;
import java.util.logging.Logger;
import me.smurfy129.tutorial.Metrics;
import me.smurfy129.tutorial.PluginListener;
import me.smurfy129.tutorial.SubCommands;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;

public class Main
extends JavaPlugin {
    public static Main plugin;
    SubCommands subCmds;
    Logger myLog = Bukkit.getLogger();
    public static Economy economy;

    static {
        economy = null;
    }

    public void onEnable() {
        if (!this.setupEconomy()) {
            this.myLog.info("[EzTutorial] No economy plugin found, money rewards can't be given!");
        } else {
            this.myLog.info("[EzTutorial] Economy & Vault found, money rewards can be given!");
        }
        try {
            Metrics metrics = new Metrics((Plugin)this);
            metrics.start();
            this.myLog.info("[EzTutorial] Metrics are being reported");
        }
        catch (IOException e) {
            this.myLog.info("[EzTutorial] Failed to submit metrics");
        }
        plugin = this;
        this.subCmds = new SubCommands(this);
        this.getServer().getPluginManager().registerEvents((Listener)new PluginListener(), (Plugin)this);
        this.getConfig().options().copyDefaults(true);
        this.saveConfig();
        if (this.getServer().getPluginManager().getPlugin("TitleAPI") != null) {
            this.myLog.info("[EzTutorial] TitleAPI found, titles will be used for tutorials");
        } else {
            this.myLog.info("[EzTutorial] TitleAPI not found, messages will be used for tutorials");
        }
        this.myLog.info("[EzTutorial] has been enabled!");
    }

    public void onDisable() {
        this.myLog.info("[EzTutorial] has been disabled!");
    }

    boolean setupEconomy() {
        if (this.getServer().getPluginManager().getPlugin("Vault") != null) {
            RegisteredServiceProvider economyProvider = this.getServer().getServicesManager().getRegistration(Economy.class);
            if (economyProvider != null) {
                economy = (Economy)economyProvider.getProvider();
            }
            return economy != null;
        }
        this.myLog.info("[EzTutorial] Vault is not installed, money rewards can't be given!");
        return false;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String[] args) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if ((commandLabel.equalsIgnoreCase("tutorial") || commandLabel.equalsIgnoreCase("tut") || commandLabel.equalsIgnoreCase("t")) && !player.hasPermission("tutorial")) {
                player.sendMessage(ChatColor.RED + "You don't have permission to use this command!");
                return false;
            }
            if (args.length == 0) {
                sender.sendMessage(ChatColor.RED + "Missing arguments, try /tutorial help");
            }
            if (args.length == 1) {
                if (args[0].equalsIgnoreCase("help")) {
                    if (player.hasPermission("tutorial.help")) {
                        ChatColor g = ChatColor.GRAY;
                        ChatColor a = ChatColor.AQUA;
                        player.sendMessage("");
                        player.sendMessage(g + "---------- " + a + this.getDescription().getName() + g + " ----------");
                        player.sendMessage(g + "Author: " + a + "Smurfy129");
                        player.sendMessage(g + "Version: " + a + this.getDescription().getVersion());
                        player.sendMessage(g + "Aliases: " + a + "/tutorial /tut /t");
                        player.sendMessage(g + "Sub-Commands: " + a + "(Use an aliase above infront of one of the sub-commands below)");
                        sender.sendMessage(g + "- " + a + "help " + g + "Displays all commands and subcommands.");
                        sender.sendMessage(g + "- " + a + "list " + g + "Lists all the tutorials and their locations.");
                        sender.sendMessage(g + "- " + a + "reload " + g + "Reloads the configuration file.");
                        sender.sendMessage(g + "- " + a + "new <tutorial name> " + g + "Creates a new tutorial.");
                        sender.sendMessage(g + "- " + a + "start <tutorial name> " + g + "Puts you through a tutorial.");
                        sender.sendMessage(g + "- " + a + "deltutorial <tutorial name> " + g + "Deletes a specific tutorial and all it's locations.");
                        sender.sendMessage(g + "- " + a + "dellocation <tutorial name> <location number> " + g + "Deletes a specific location in a tutorial.");
                        sender.sendMessage(g + "- " + a + "setlocation <tutorial name> <location number> " + g + "Sets a specific location in a tutorial.");
                        sender.sendMessage(g + "- " + a + "start <tutorial name> <target player> " + g + "Puts a target player through a tutorial.");
                    } else {
                        player.sendMessage(ChatColor.RED + "You don't have permission to use this command!");
                    }
                } else if (args[0].equalsIgnoreCase("list")) {
                    if (player.hasPermission("tutorial.list")) {
                        this.subCmds.listCommand(player, args);
                    } else {
                        player.sendMessage(ChatColor.RED + "You don't have permission to use this command!");
                    }
                } else if (args[0].equalsIgnoreCase("reload")) {
                    if (player.hasPermission("tutorial.reload")) {
                        this.reloadConfig();
                        player.sendMessage(ChatColor.GRAY + "[EzTutorial] " + ChatColor.AQUA + "Config reloaded!");
                    } else {
                        player.sendMessage(ChatColor.RED + "You don't have permission to use this command!");
                    }
                } else {
                    sender.sendMessage(ChatColor.RED + "Wrong arguments, try /tutorial help");
                }
            }
            if (args.length == 2) {
                if (args[0].equalsIgnoreCase("start")) {
                    if (player.hasPermission("tutorial.start")) {
                        String tutorialName = args[1];
                        if (plugin.getConfig().contains("Tutorials." + tutorialName)) {
                            this.subCmds.startTutorial(player, tutorialName);
                        } else {
                            player.sendMessage(ChatColor.RED + "The tutorial \"" + tutorialName + "\" does not exist");
                        }
                    } else {
                        player.sendMessage("You don't have permission to use this command!");
                    }
                } else if (args[0].equalsIgnoreCase("deltutorial")) {
                    if (player.hasPermission("tutorial.deltutorial")) {
                        this.subCmds.delTutorial(player, args);
                    } else {
                        player.sendMessage(ChatColor.RED + "You don't have permission to use this command!");
                    }
                } else if (args[0].equalsIgnoreCase("new")) {
                    if (player.hasPermission("tutorial.new")) {
                        this.subCmds.newCommand(player, args);
                    } else {
                        player.sendMessage(ChatColor.RED + "You don't have permission to use this command!");
                    }
                } else {
                    player.sendMessage(ChatColor.RED + "Wrong arguments, try /tutorial help");
                }
            }
            if (args.length == 3) {
                if (args[0].equalsIgnoreCase("dellocation")) {
                    if (player.hasPermission("tutorial.dellocation")) {
                        this.subCmds.delLocationCommand(player, args);
                    } else {
                        player.sendMessage(ChatColor.RED + "You don't have permission to use this command!");
                    }
                } else if (args[0].equalsIgnoreCase("setlocation")) {
                    if (player.hasPermission("tutorial.setlocation")) {
                        this.subCmds.setLocationCommand(player, args);
                    } else {
                        player.sendMessage(ChatColor.RED + "You don't have permission to use this command!");
                    }
                } else if (args[0].equalsIgnoreCase("start")) {
                    if (!player.hasPermission("tutorial.start.player")) {
                        player.sendMessage(ChatColor.RED + "You don't have permission to use this command!");
                        return false;
                    }
                    Player targetPlayer = Bukkit.getPlayer((String)args[2]);
                    String tutorialName = args[1];
                    if (targetPlayer != null) {
                        if (plugin.getConfig().contains("Tutorials." + tutorialName)) {
                            targetPlayer.sendMessage(ChatColor.AQUA + "Attention " + targetPlayer.getDisplayName() + " a staff member is putting you through the tutorial \"" + tutorialName + "\"");
                            this.subCmds.startTutorial(targetPlayer, tutorialName);
                        } else {
                            player.sendMessage(ChatColor.RED + "The tutorial \"" + tutorialName + "\" does not exist");
                        }
                    } else {
                        player.sendMessage(ChatColor.RED + "The target player is not online!");
                    }
                } else {
                    sender.sendMessage(ChatColor.RED + "Wrong arguments, try /tutorial help");
                }
            }
        } else if (args.length == 0) {
            sender.sendMessage("[EzTutorial] " + ChatColor.RED + "Missing arguments!");
        } else if (args[0].equalsIgnoreCase("reload")) {
            this.reloadConfig();
            sender.sendMessage("[EzTutorial] " + ChatColor.GREEN + "Config reloaded!");
        } else {
            sender.sendMessage("[EzTutorial] " + ChatColor.RED + "Sorry this command can only be used in-game.");
        }
        return false;
    }
}

