/*
 * Decompiled with CFR 0.152.
 */
package ru.meloncode.xmas;

import java.text.SimpleDateFormat;
import java.util.HashSet;
import java.util.Random;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import ru.meloncode.xmas.LocaleManager;
import ru.meloncode.xmas.MagicTree;
import ru.meloncode.xmas.Main;
import ru.meloncode.xmas.XMas;

public class XMasCommand
implements CommandExecutor {
    private final Main plugin;

    private XMasCommand(Main plugin) {
        this.plugin = plugin;
    }

    public static void register(Main plugin) {
        plugin.getCommand("xmas").setExecutor((CommandExecutor)new XMasCommand(plugin));
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        block18: {
            block17: {
                String action;
                if (args.length <= 0) break block17;
                switch (action = args[0].toLowerCase()) {
                    case "help": {
                        for (String line : LocaleManager.COMMAND_HELP) {
                            sender.sendMessage(ChatColor.GREEN + line);
                        }
                        break block18;
                    }
                    case "give": {
                        if (args.length > 1) {
                            String name = args[1];
                            Player player = Bukkit.getPlayer((String)name);
                            if (player != null) {
                                player.getInventory().addItem(new ItemStack[]{XMas.XMAS_CRYSTAL});
                                break;
                            }
                            sender.sendMessage(LocaleManager.COMMAND_PLAYER_OFFLINE);
                            break;
                        }
                        sender.sendMessage(LocaleManager.COMMAND_NO_PLAYER_NAME);
                        break;
                    }
                    case "end": {
                        this.plugin.end();
                        break;
                    }
                    case "gifts": {
                        Random random = new Random();
                        for (MagicTree magicTree : XMas.getAllTrees()) {
                            for (int i = 0; i < 3 + random.nextInt(4); ++i) {
                                magicTree.spawnPresent();
                            }
                        }
                        Bukkit.broadcastMessage((String)LocaleManager.COMMAND_GIVEAWAY);
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                break block18;
            }
            this.sendStatus(sender);
        }
        return true;
    }

    private void sendStatus(CommandSender sender) {
        int treeCount = XMas.getAllTrees().size();
        HashSet<UUID> owners = new HashSet<UUID>();
        for (MagicTree magicTree : XMas.getAllTrees()) {
            owners.add(magicTree.getOwner());
        }
        SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy kk-mm-ss");
        sender.sendMessage(ChatColor.DARK_GREEN + LocaleManager.PLUGIN_NAME + " " + this.plugin.getDescription().getVersion() + " Plugin Status");
        sender.sendMessage("");
        sender.sendMessage(ChatColor.GRAY + "Event Status: " + (Main.inProgress ? ChatColor.DARK_GREEN + "In Progress" : ChatColor.RED + "Holidays End"));
        if (Main.inProgress) {
            sender.sendMessage(ChatColor.DARK_GREEN + "Current Time: " + ChatColor.GREEN + sdf.format(System.currentTimeMillis()));
            sender.sendMessage(ChatColor.DARK_GREEN + "Holidays end: " + ChatColor.RED + sdf.format(Main.endTime));
        }
        sender.sendMessage(ChatColor.GREEN + "Auto-End: " + (Main.autoEnd ? ChatColor.DARK_GREEN + "Yes" : ChatColor.RED + "No") + ChatColor.GREEN + "    |    Resource Back: " + (Main.resourceBack ? ChatColor.DARK_GREEN + "Yes" : "No"));
        sender.sendMessage("");
        sender.sendMessage(ChatColor.DARK_GREEN + "There are " + ChatColor.GREEN + treeCount + ChatColor.DARK_GREEN + " magic trees owned by " + ChatColor.RED + owners.size() + ChatColor.DARK_GREEN + " players");
        sender.sendMessage(ChatColor.DARK_GREEN + "Use " + ChatColor.RED + "/xmas help" + ChatColor.DARK_GREEN + " for command list");
    }
}

