/*
 * Decompiled with CFR 0.152.
 */
package ru.meloncode.xmas;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.java.JavaPlugin;
import ru.meloncode.xmas.MagicTree;
import ru.meloncode.xmas.Main;
import ru.meloncode.xmas.TreeLevel;
import ru.meloncode.xmas.XMas;
import ru.meloncode.xmas.utils.ConfigUtils;
import ru.meloncode.xmas.utils.TextUtils;

class TreeSerializer {
    private static final File treesFile = new File(Main.getInstance().getDataFolder() + "/trees.yml");
    private static final FileConfiguration trees = ConfigUtils.loadConfig(treesFile);

    TreeSerializer() {
    }

    public static void loadTrees(JavaPlugin plugin, World world) {
        try {
            if (trees.getConfigurationSection("trees") != null && trees.getConfigurationSection("trees").getKeys(false).size() > 0) {
                for (String cKey : trees.getConfigurationSection("trees").getKeys(false)) {
                    if (!world.getName().equals(trees.getString("trees." + cKey + ".loc.world"))) continue;
                    try {
                        UUID treeUID = UUID.fromString(cKey);
                        UUID owner = UUID.fromString(trees.getString("trees." + cKey + ".owner"));
                        TreeLevel level = TreeLevel.fromString(trees.getString("trees." + cKey + ".level"));
                        int x = trees.getInt("trees." + cKey + ".loc.x");
                        int y = trees.getInt("trees." + cKey + ".loc.y");
                        int z = trees.getInt("trees." + cKey + ".loc.z");
                        Location loc = new Location(world, (double)x, (double)y, (double)z);
                        Map<Object, Object> requirements = trees.getConfigurationSection("trees." + cKey + ".levelup") != null ? TreeSerializer.convertRequirementsMap(trees.getConfigurationSection("trees." + cKey + ".levelup").getValues(false)) : new HashMap();
                        long presentCounter = trees.getLong("trees." + cKey + ".present_counter", 0L);
                        int scheduledPresents = trees.getInt("trees." + cKey + ".scheduled_presents", 0);
                        XMas.addMagicTree(new MagicTree(owner, treeUID, level, loc, requirements, presentCounter, scheduledPresents));
                    }
                    catch (Exception e) {
                        plugin.getLogger().severe(String.format("Error while loading tree `%s`", cKey));
                        e.printStackTrace();
                        System.out.println("================================================");
                    }
                }
            }
        }
        catch (Exception e) {
            TextUtils.sendConsoleMessage(ChatColor.DARK_RED + "ERROR WHILE LOADING TREES");
            e.printStackTrace();
        }
    }

    public static void saveTree(MagicTree tree) {
        String cKey = tree.getTreeUID().toString();
        String owner = tree.getOwner().toString();
        trees.set("trees." + cKey + ".owner", (Object)owner);
        trees.set("trees." + cKey + ".level", (Object)tree.getLevel().getLevelName());
        trees.set("trees." + cKey + ".loc.world", (Object)tree.getLocation().getWorld().getName());
        trees.set("trees." + cKey + ".loc.x", (Object)tree.getLocation().getX());
        trees.set("trees." + cKey + ".loc.y", (Object)tree.getLocation().getY());
        trees.set("trees." + cKey + ".loc.z", (Object)tree.getLocation().getZ());
        if (tree.getLevelupRequirements() != null && tree.getLevelupRequirements().size() > 0) {
            trees.createSection("trees." + cKey + ".levelup", tree.getLevelupRequirements());
        }
        try {
            trees.save(treesFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        trees.set("trees." + cKey + ".present_counter", (Object)tree.getPresentCounter());
        trees.set("trees." + cKey + ".scheduled_presents", (Object)tree.getScheduledPresents());
    }

    public static void removeTree(MagicTree tree) {
        trees.set("trees." + tree.getTreeUID().toString(), null);
        try {
            trees.save(treesFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Map<Material, Integer> convertRequirementsMap(Map<String, Object> map) {
        HashMap<Material, Integer> levelupRequirements = new HashMap<Material, Integer>();
        if (map != null) {
            for (String sMaterial : map.keySet()) {
                try {
                    Material cMaterial = Material.valueOf((String)sMaterial);
                    int value = (Integer)map.get(sMaterial);
                    levelupRequirements.put(cMaterial, value);
                }
                catch (IllegalArgumentException e) {
                    TextUtils.sendConsoleMessage("Can't find material '" + sMaterial + "' for tree level.");
                    return null;
                }
            }
        }
        return levelupRequirements;
    }
}

