/*
 * Decompiled with CFR 0.152.
 */
package ru.meloncode.xmas;

import java.util.Map;
import org.bukkit.Material;
import org.bukkit.util.Vector;
import ru.meloncode.xmas.ParticleContainer;
import ru.meloncode.xmas.StructureTemplate;

public class TreeLevel {
    public static TreeLevel MAGIC_TREE;
    public static TreeLevel TREE;
    public static TreeLevel SMALL_TREE;
    public static TreeLevel SAPLING;
    final TreeLevel nextLevel;
    private final String levelName;
    private final long giftDelay;
    private final Map<Material, Integer> levelupRequirements;
    private final StructureTemplate structure;
    private final ParticleContainer ambientEffect;
    private final ParticleContainer swagEffect;
    private final ParticleContainer bodyEffect;
    private int height;

    public TreeLevel(String levelName, ParticleContainer ambientEffect, ParticleContainer swagEffect, ParticleContainer bodyEffect, TreeLevel nextLevel, long giftDelay, Map<Material, Integer> levelupRequirements, StructureTemplate structure) {
        this.levelName = levelName;
        this.nextLevel = nextLevel;
        this.giftDelay = giftDelay;
        this.levelupRequirements = levelupRequirements;
        this.structure = structure;
        this.ambientEffect = ambientEffect;
        this.swagEffect = swagEffect;
        this.bodyEffect = bodyEffect;
        this.height = -256;
        for (Vector vector : structure.getAllLocations()) {
            if (!(vector.getY() > (double)this.height)) continue;
            this.height = (int)vector.getY();
        }
    }

    public static TreeLevel fromString(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Level name cannot be null!");
        }
        switch (name.toLowerCase()) {
            case "sapling": {
                return SAPLING;
            }
            case "tree": {
                return TREE;
            }
            case "small_tree": {
                return SMALL_TREE;
            }
            case "magic_tree": {
                return MAGIC_TREE;
            }
        }
        throw new IllegalArgumentException("Wrong level '" + name + "'");
    }

    public String getLevelName() {
        return this.levelName;
    }

    public TreeLevel getNextLevel() {
        return this.nextLevel;
    }

    public ParticleContainer getAmbientEffect() {
        return this.ambientEffect;
    }

    public ParticleContainer getSwagEffect() {
        return this.swagEffect;
    }

    public ParticleContainer getBodyEffect() {
        return this.bodyEffect;
    }

    public Map<Material, Integer> getLevelupRequirements() {
        return this.levelupRequirements;
    }

    public StructureTemplate getStructureTemplate() {
        return this.structure;
    }

    public int getTreeHeight() {
        return this.height;
    }

    public long getGiftDelay() {
        return this.giftDelay;
    }

    public boolean hasNext() {
        return this.nextLevel != null;
    }
}

