/*
 * Decompiled with CFR 0.152.
 */
package ru.meloncode.xmas;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.util.Vector;

public class StructureTemplate {
    private final HashMap<Vector, Material> struct;

    public StructureTemplate(HashMap<Vector, Material> hashMap) {
        this.struct = hashMap;
    }

    public void set(Vector vector, Material material) {
        this.struct.put(vector, material);
    }

    private Material get(Vector vec) {
        return this.struct.get(vec);
    }

    public Set<Vector> getAllLocations() {
        return this.struct.keySet();
    }

    public Collection<Material> getAllMaterials() {
        return this.struct.values();
    }

    public boolean canGrow(Location start) {
        for (Vector cVec : this.getAllLocations()) {
            Vector nLoc = start.toVector().add(cVec);
            if (!start.getBlock().getType().isSolid() && !(nLoc.getY() > (double)start.getWorld().getMaxHeight())) continue;
            return !this.getAllLocations().contains(nLoc);
        }
        return true;
    }

    public Set<Block> build(Location start) {
        HashSet<Block> blocks = new HashSet<Block>();
        for (Vector cVec : this.getAllLocations()) {
            Location cLoc = start.clone().add(cVec);
            Block cBlock = cLoc.getBlock();
            cBlock.setType(this.get(cVec));
            blocks.add(cBlock);
        }
        return blocks;
    }
}

