/*
 * Decompiled with CFR 0.152.
 */
package ru.meloncode.xmas;

import com.google.common.collect.Lists;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.event.world.WorldUnloadEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.Vector;
import ru.meloncode.xmas.Effects;
import ru.meloncode.xmas.Events;
import ru.meloncode.xmas.ItemMaker;
import ru.meloncode.xmas.LocaleManager;
import ru.meloncode.xmas.MagicTask;
import ru.meloncode.xmas.MagicTree;
import ru.meloncode.xmas.PlayParticlesTask;
import ru.meloncode.xmas.StructureTemplate;
import ru.meloncode.xmas.TreeLevel;
import ru.meloncode.xmas.TreeSerializer;
import ru.meloncode.xmas.XMas;
import ru.meloncode.xmas.XMasCommand;
import ru.meloncode.xmas.utils.TextUtils;

public class Main
extends JavaPlugin
implements Listener {
    static final Random RANDOM = new Random(Calendar.getInstance().get(1));
    static List<ItemStack> gifts;
    static float LUCK_CHANCE;
    static boolean LUCK_CHANCE_ENABLED;
    static boolean resourceBack;
    static int MAX_TREE_COUNT;
    static boolean autoEnd;
    static long endTime;
    static boolean inProgress;
    private static int UPDATE_SPEED;
    private static int PARTICLES_DELAY;
    private static List<String> heads;
    private static Plugin plugin;
    private FileConfiguration config;
    private String locale;

    public static Plugin getInstance() {
        return plugin;
    }

    public static List<String> getHeads() {
        return heads;
    }

    public void onLoad() {
        plugin = this;
    }

    public void onEnable() {
        this.saveDefaults();
        this.config = this.getConfig();
        this.locale = this.config.getString("core.locale");
        SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy kk-mm-ss");
        inProgress = this.config.getBoolean("core.plugin-enabled", true);
        UPDATE_SPEED = this.config.getInt("core.update-speed");
        if (UPDATE_SPEED <= 0) {
            TextUtils.sendConsoleMessage("Update speed must be > 0");
            TextUtils.sendConsoleMessage("Setting value to default");
            this.config.set("core.update-speed", (Object)7);
            UPDATE_SPEED = 7;
        }
        if ((PARTICLES_DELAY = this.config.getInt("core.particles-delay")) <= 0) {
            this.config.set("particles-delay", (Object)35);
        }
        autoEnd = this.config.getBoolean("core.holiday-ends.enabled");
        resourceBack = this.config.getBoolean("core.holiday-ends.resource-back");
        MAX_TREE_COUNT = this.config.getInt("core.tree-limit");
        try {
            Date date = sdf.parse(this.config.getString("core.holiday-ends.date"));
            endTime = date.getTime();
        }
        catch (ParseException e1) {
            TextUtils.sendConsoleMessage("Unable to load date");
        }
        this.defineTreeLevels();
        for (World world : this.getServer().getWorlds()) {
            TreeSerializer.loadTrees(this, world);
        }
        LocaleManager.loadLocale(this.locale);
        heads = this.config.getStringList("xmas.presents");
        if (heads.size() == 0) {
            this.getLogger().warning(ChatColor.RED + "Warning! No heads loaded! Presents can't spawn without box!");
            return;
        }
        gifts = new ArrayList<ItemStack>();
        for (String cItem : this.config.getStringList("xmas.gifts")) {
            try {
                if (cItem.contains(":")) {
                    String[] split = cItem.split(":");
                    if (split.length == 0) {
                        throw new IllegalArgumentException();
                    }
                    int amount = 1;
                    Material material = Material.valueOf((String)split[0]);
                    if (split.length > 1) {
                        amount = Integer.parseInt(split[1]);
                    }
                    gifts.add(new ItemStack(material, amount));
                    continue;
                }
                gifts.add(new ItemStack(Material.valueOf((String)cItem)));
            }
            catch (IllegalArgumentException e) {
                this.getLogger().severe(ChatColor.RED + "[X-Mas] Unable to get load gift from  '" + cItem + "'");
                this.getLogger().warning(ChatColor.RED + "[X-Mas] For gifts - use format MATERIAL:AMOUNT:DATA. Amount and data are optional");
            }
        }
        if (gifts.size() == 0) {
            this.getLogger().warning(ChatColor.RED + "[X-Mas] Warning! No gifts loaded! No X-Mas without gifts!");
            return;
        }
        LUCK_CHANCE_ENABLED = this.config.getBoolean("xmas.luck.enabled");
        LUCK_CHANCE = (float)this.config.getInt("xmas.luck.chance") / 100.0f;
        new Events().registerListener();
        new MagicTask(this).runTaskTimer((Plugin)this, 5L, UPDATE_SPEED);
        new PlayParticlesTask(this).runTaskTimerAsynchronously((Plugin)this, 5L, PARTICLES_DELAY);
        XMas.XMAS_CRYSTAL = new ItemMaker(Material.EMERALD, LocaleManager.CRYSTAL_NAME, LocaleManager.CRYSTAL_LORE).make();
        ShapedRecipe grinderRecipe = new ShapedRecipe(new NamespacedKey((Plugin)this, "xmas"), XMas.XMAS_CRYSTAL).shape(new String[]{"#d#", "ded", "#d#"}).setIngredient('d', Material.DIAMOND).setIngredient('e', Material.EMERALD);
        Iterator recipes = this.getServer().recipeIterator();
        boolean registered = false;
        while (recipes.hasNext()) {
            Recipe recipe = (Recipe)recipes.next();
            if (!recipe.equals(grinderRecipe)) continue;
            registered = true;
            break;
        }
        try {
            if (!registered) {
                this.getServer().addRecipe((Recipe)grinderRecipe);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        XMasCommand.register(this);
        TextUtils.sendConsoleMessage(LocaleManager.PLUGIN_ENABLED);
    }

    @EventHandler
    public void onWorldLoad(WorldLoadEvent event) {
        TreeSerializer.loadTrees(this, event.getWorld());
    }

    @EventHandler
    public void onWorldUnload(WorldUnloadEvent event) {
        for (MagicTree magicTree : XMas.getAllTrees()) {
            if (magicTree.getLocation().getWorld() != event.getWorld()) continue;
            magicTree.unbuild();
        }
    }

    public void onDisable() {
        if (XMas.getAllTrees().size() > 0) {
            for (MagicTree tree : XMas.getAllTrees()) {
                tree.unbuild();
            }
        }
    }

    public void end() {
        Bukkit.broadcastMessage((String)(ChatColor.GREEN + LocaleManager.HAPPY_NEW_YEAR));
        inProgress = false;
        this.config.set("core.plugin-enabled", (Object)false);
        this.saveConfig();
    }

    private void saveDefaults() {
        this.saveDefaultConfig();
        plugin.saveResource("locales/default.yml", true);
        ArrayList defaults = Lists.newArrayList((Object[])new String[]{"locales/en.yml", "locales/ru.yml", "locales/ru_santa.yml", "trees.yml"});
        for (String path : defaults) {
            if (new File(this.getDataFolder(), '/' + path).exists()) continue;
            plugin.saveResource(path, false);
        }
    }

    private void defineTreeLevels() {
        long sapling_delay = this.config.getInt("xmas.tree-lvl.sapling.gift-cooldown") * 20 / UPDATE_SPEED;
        long small_delay = this.config.getInt("xmas.tree-lvl.small_tree.gift-cooldown") * 20 / UPDATE_SPEED;
        long tree_delay = this.config.getInt("xmas.tree-lvl.tree.gift-cooldown") * 20 / UPDATE_SPEED;
        long magic_delay = this.config.getInt("xmas.tree-lvl.magic_tree.gift-cooldown") * 20 / UPDATE_SPEED;
        ConfigurationSection lvlups = this.config.getConfigurationSection("xmas.tree-lvl");
        Map<Material, Integer> saplingLevelUp = TreeSerializer.convertRequirementsMap(lvlups.getConfigurationSection("sapling.lvlup").getValues(false));
        Map<Material, Integer> smallLevelUp = TreeSerializer.convertRequirementsMap(lvlups.getConfigurationSection("small_tree.lvlup").getValues(false));
        Map<Material, Integer> treeLevelUp = TreeSerializer.convertRequirementsMap(lvlups.getConfigurationSection("tree.lvlup").getValues(false));
        TreeLevel.MAGIC_TREE = new TreeLevel("magic_tree", Effects.TREE_WHITE_AMBIENT, Effects.TREE_SWAG, null, null, magic_delay, Collections.emptyMap(), new StructureTemplate(new HashMap<Vector, Material>(){
            private static final long serialVersionUID = 1L;
            {
                this.put(new Vector(0, -1, 0), Material.GRASS_BLOCK);
                for (int i = 0; i <= 5; ++i) {
                    this.put(new Vector(0, i, 0), Material.SPRUCE_LOG);
                    if (i < 2) continue;
                    this.put(new Vector(1, i, 0), Material.SPRUCE_LEAVES);
                    this.put(new Vector(-1, i, 0), Material.SPRUCE_LEAVES);
                    this.put(new Vector(0, i, 1), Material.SPRUCE_LEAVES);
                    this.put(new Vector(0, i, -1), Material.SPRUCE_LEAVES);
                }
                this.put(new Vector(0, 6, 0), Material.SPRUCE_LEAVES);
                this.put(new Vector(0, 7, 0), Material.GLOWSTONE);
                this.put(new Vector(1, 4, 0), Material.SPRUCE_LEAVES);
                this.put(new Vector(1, 4, 1), Material.SPRUCE_LEAVES);
                this.put(new Vector(1, 4, -1), Material.SPRUCE_LEAVES);
                this.put(new Vector(-1, 4, -1), Material.SPRUCE_LEAVES);
                this.put(new Vector(-1, 4, 1), Material.SPRUCE_LEAVES);
                this.put(new Vector(1, 2, 1), Material.SPRUCE_LEAVES);
                this.put(new Vector(-1, 2, -1), Material.SPRUCE_LEAVES);
                this.put(new Vector(1, 2, -1), Material.SPRUCE_LEAVES);
                this.put(new Vector(-1, 2, 1), Material.SPRUCE_LEAVES);
                this.put(new Vector(2, 2, 0), Material.SPRUCE_LEAVES);
                this.put(new Vector(0, 2, 2), Material.SPRUCE_LEAVES);
                this.put(new Vector(-2, 2, 0), Material.SPRUCE_LEAVES);
                this.put(new Vector(0, 2, -2), Material.SPRUCE_LEAVES);
            }
        }));
        TreeLevel.TREE = new TreeLevel("tree", Effects.AMBIENT_SNOW, Effects.TREE_GOLD_SWAG, null, TreeLevel.MAGIC_TREE, tree_delay, treeLevelUp, new StructureTemplate(new HashMap<Vector, Material>(){
            private static final long serialVersionUID = 1L;
            {
                this.put(new Vector(0, -1, 0), Material.GRASS_BLOCK);
                this.put(new Vector(0, 0, 0), Material.SPRUCE_LOG);
                this.put(new Vector(0, 1, 0), Material.SPRUCE_LOG);
                this.put(new Vector(0, 2, 0), Material.SPRUCE_LOG);
                this.put(new Vector(0, 3, 0), Material.SPRUCE_LOG);
                this.put(new Vector(0, 4, 0), Material.SPRUCE_LOG);
                this.put(new Vector(0, 5, 0), Material.SPRUCE_LEAVES);
                this.put(new Vector(1, 4, 0), Material.SPRUCE_LEAVES);
                this.put(new Vector(0, 4, 1), Material.SPRUCE_LEAVES);
                this.put(new Vector(-1, 4, 0), Material.SPRUCE_LEAVES);
                this.put(new Vector(0, 4, -1), Material.SPRUCE_LEAVES);
                this.put(new Vector(1, 1, 0), Material.SPRUCE_LEAVES);
                this.put(new Vector(0, 1, 1), Material.SPRUCE_LEAVES);
                this.put(new Vector(1, 1, 1), Material.SPRUCE_LEAVES);
                this.put(new Vector(-1, 1, 0), Material.SPRUCE_LEAVES);
                this.put(new Vector(0, 1, -1), Material.SPRUCE_LEAVES);
                this.put(new Vector(-1, 1, -1), Material.SPRUCE_LEAVES);
                this.put(new Vector(-1, 1, 1), Material.SPRUCE_LEAVES);
                this.put(new Vector(1, 1, -1), Material.SPRUCE_LEAVES);
                this.put(new Vector(1, 2, 0), Material.SPRUCE_LEAVES);
                this.put(new Vector(0, 2, 1), Material.SPRUCE_LEAVES);
                this.put(new Vector(-1, 2, 0), Material.SPRUCE_LEAVES);
                this.put(new Vector(0, 2, -1), Material.SPRUCE_LEAVES);
            }
        }));
        TreeLevel.SMALL_TREE = new TreeLevel("small_tree", Effects.AMBIENT_PORTAL, Effects.TREE_RED_SWAG, null, TreeLevel.TREE, small_delay, smallLevelUp, new StructureTemplate(new HashMap<Vector, Material>(){
            private static final long serialVersionUID = 1L;
            {
                this.put(new Vector(0, -1, 0), Material.GRASS_BLOCK);
                this.put(new Vector(0, 0, 0), Material.SPRUCE_LOG);
                this.put(new Vector(0, 1, 0), Material.SPRUCE_LOG);
                this.put(new Vector(0, 2, 0), Material.SPRUCE_LEAVES);
                this.put(new Vector(0, 3, 0), Material.SPRUCE_LEAVES);
                this.put(new Vector(1, 1, 0), Material.SPRUCE_LEAVES);
                this.put(new Vector(0, 1, 1), Material.SPRUCE_LEAVES);
                this.put(new Vector(1, 1, 1), Material.SPRUCE_LEAVES);
                this.put(new Vector(-1, 1, 0), Material.SPRUCE_LEAVES);
                this.put(new Vector(0, 1, -1), Material.SPRUCE_LEAVES);
                this.put(new Vector(-1, 1, -1), Material.SPRUCE_LEAVES);
                this.put(new Vector(-1, 1, 1), Material.SPRUCE_LEAVES);
                this.put(new Vector(1, 1, -1), Material.SPRUCE_LEAVES);
                this.put(new Vector(1, 2, 0), Material.SPRUCE_LEAVES);
                this.put(new Vector(0, 2, 1), Material.SPRUCE_LEAVES);
                this.put(new Vector(-1, 2, 0), Material.SPRUCE_LEAVES);
                this.put(new Vector(0, 2, -1), Material.SPRUCE_LEAVES);
            }
        }));
        TreeLevel.SAPLING = new TreeLevel("sapling", Effects.AMBIENT_SAPLING, null, null, TreeLevel.SMALL_TREE, sapling_delay, saplingLevelUp, new StructureTemplate(new HashMap<Vector, Material>(){
            private static final long serialVersionUID = 1L;
            {
                this.put(new Vector(0, -1, 0), Material.GRASS_BLOCK);
                this.put(new Vector(0, 0, 0), Material.SPRUCE_SAPLING);
            }
        }));
    }
}

