/*
 * Decompiled with CFR 0.152.
 */
package ru.meloncode.xmas;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Effect;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.block.Skull;
import org.bukkit.block.data.Rotatable;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.util.Vector;
import ru.meloncode.xmas.Effects;
import ru.meloncode.xmas.Main;
import ru.meloncode.xmas.TreeLevel;
import ru.meloncode.xmas.TreeSerializer;
import ru.meloncode.xmas.XMas;

public class MagicTree {
    private static final ConcurrentHashMap<Block, UUID> blockAssociation = new ConcurrentHashMap();
    private final UUID owner;
    private final Location location;
    private final UUID treeuid;
    TreeLevel level;
    private Map<Material, Integer> levelupRequirements;
    private Set<Block> blocks;
    private long presentCounter;
    private int scheduledPresents;

    public MagicTree(UUID owner, TreeLevel level, Location location) {
        this.treeuid = UUID.randomUUID();
        this.owner = owner;
        this.level = level;
        this.location = location;
        this.levelupRequirements = new HashMap<Material, Integer>(level.getLevelupRequirements());
        if (Main.inProgress) {
            this.build();
        }
        this.presentCounter = 0L;
        this.scheduledPresents = 0;
    }

    public MagicTree(UUID owner, UUID uid, TreeLevel level, Location location, Map<Material, Integer> levelupRequirements, long presentCounter, int scheduledPresents) {
        this.owner = owner;
        this.treeuid = uid;
        this.level = level;
        this.location = location;
        this.levelupRequirements = new HashMap<Material, Integer>(levelupRequirements);
        this.presentCounter = 0L;
        this.presentCounter = presentCounter;
        if (Main.inProgress) {
            this.build();
        }
        this.scheduledPresents = scheduledPresents;
    }

    public static MagicTree getTreeByBlock(Block block) {
        return XMas.getTree(blockAssociation.get(block));
    }

    public static boolean isBlockBelongs(Block block) {
        return blockAssociation.containsKey(block);
    }

    public UUID getOwner() {
        return this.owner;
    }

    public Player getPlayerOwner() {
        if (Bukkit.getPlayer((UUID)this.owner) != null) {
            return Bukkit.getPlayer((UUID)this.owner);
        }
        return null;
    }

    public TreeLevel getLevel() {
        return this.level;
    }

    public Location getLocation() {
        return this.location;
    }

    public Map<Material, Integer> getLevelupRequirements() {
        return this.levelupRequirements;
    }

    public boolean grow(Material material) {
        if (this.levelupRequirements.containsKey(material)) {
            if (this.levelupRequirements.get(material) <= 1) {
                this.levelupRequirements.remove(material);
            } else {
                this.levelupRequirements.put(material, this.levelupRequirements.get(material) - 1);
            }
            for (Block block : this.blocks) {
                if (block.getType() != Material.SPRUCE_LEAVES && block.getType() != Material.SPRUCE_SAPLING) continue;
                Effects.GROW.playEffect(block.getLocation());
                for (int i = 0; i <= 3; ++i) {
                    this.location.getWorld().playSound(this.location, Sound.ENTITY_PLAYER_LEVELUP, 1.0f, Main.RANDOM.nextFloat() + 0.2f);
                }
            }
            this.save();
            return true;
        }
        return false;
    }

    public void update() {
        if (Main.inProgress && this.level.getGiftDelay() > 0L) {
            if (this.presentCounter == 0L) {
                this.spawnPresent();
                this.presentCounter = (long)((double)this.level.getGiftDelay() * 1.25 - (double)this.level.getGiftDelay() * 0.75 + (double)this.level.getGiftDelay() * 0.75);
            }
            --this.presentCounter;
        }
    }

    public void playParticles() {
        if (this.blocks != null && this.blocks.size() > 0) {
            for (Block block : this.blocks) {
                if (!block.getWorld().isChunkLoaded(block.getX() / 16, block.getZ() / 16)) continue;
                if (block.getType() == Material.SPRUCE_LEAVES && this.level.getSwagEffect() != null) {
                    this.level.getSwagEffect().playEffect(block.getLocation());
                }
                if (block.getType() == Material.SPRUCE_LOG && this.level.getBodyEffect() != null) {
                    this.level.getBodyEffect().playEffect(block.getLocation());
                }
                if (this.level.getAmbientEffect() == null) continue;
                this.level.getAmbientEffect().playEffect(this.location.clone().add(0.0, (double)this.level.getTreeHeight(), 0.0));
            }
        }
    }

    public boolean tryLevelUp() {
        if (this.level.hasNext() && this.level.nextLevel.getStructureTemplate().canGrow(this.location)) {
            this.levelUp();
            return true;
        }
        return false;
    }

    private void levelUp() {
        this.unbuild();
        this.level = this.level.nextLevel;
        this.levelupRequirements = new HashMap<Material, Integer>(this.level.getLevelupRequirements());
        for (int i = 0; i <= 3; ++i) {
            Firework fw = (Firework)this.location.getWorld().spawn(this.location.clone().add(new Vector(-3 + Main.RANDOM.nextInt(6), 3, -3 + Main.RANDOM.nextInt(6))), Firework.class);
            FireworkMeta meta = fw.getFireworkMeta();
            meta.addEffect(FireworkEffect.builder().trail(true).withColor(Color.RED).withFade(Color.LIME).withFlicker().with(FireworkEffect.Type.BURST).build());
            fw.setFireworkMeta(meta);
            fw.setMetadata("nodamage", (MetadataValue)new FixedMetadataValue(Main.getInstance(), (Object)true));
        }
        this.build();
        this.save();
    }

    public void unbuild() {
        for (Map.Entry<Block, UUID> cBlock : blockAssociation.entrySet()) {
            if (!cBlock.getValue().equals(this.treeuid)) continue;
            Block block = cBlock.getKey();
            Location loc = block.getLocation();
            loc.getWorld().playEffect(loc, Effect.STEP_SOUND, (Object)block.getType());
            block.setType(Material.AIR);
            blockAssociation.remove(block);
        }
        this.location.clone().add(0.0, -1.0, 0.0).getBlock().setType(Material.GRASS_BLOCK);
    }

    public void build() {
        if (this.level.getStructureTemplate().canGrow(this.location)) {
            this.blocks = this.level.getStructureTemplate().build(this.location);
            for (Block block : this.blocks) {
                blockAssociation.put(block, this.getTreeUID());
            }
        }
    }

    public void spawnPresent() {
        if (!this.location.getWorld().isChunkLoaded((int)this.location.getX() / 16, (int)this.location.getZ() / 16)) {
            if (this.scheduledPresents + 1 <= 8) {
                ++this.scheduledPresents;
            }
            return;
        }
        Location presentLoc = this.location.clone().add((double)(-1 + Main.RANDOM.nextInt(3)), 0.0, (double)(-1 + Main.RANDOM.nextInt(3)));
        Block pBlock = presentLoc.getBlock();
        if (!pBlock.getType().isSolid() && pBlock.getType() != Material.SPRUCE_SAPLING) {
            pBlock.setType(Material.PLAYER_HEAD);
            BlockState state = pBlock.getState();
            if (state instanceof Skull) {
                BlockFace face;
                Skull skull = (Skull)state;
                while ((face = BlockFace.values()[Main.RANDOM.nextInt(BlockFace.values().length)]) == BlockFace.DOWN || face == BlockFace.UP || face == BlockFace.SELF) {
                }
                Rotatable skullRotatable = (Rotatable)skull.getBlockData();
                skullRotatable.setRotation(face);
                skull.setType(Material.PLAYER_HEAD);
                skull.setOwningPlayer(Bukkit.getOfflinePlayer((String)Main.getHeads().get(Main.RANDOM.nextInt(Main.getHeads().size()))));
                skull.update(true);
            }
        }
    }

    public boolean canLevelUp() {
        return this.getLevelupRequirements().size() == 0;
    }

    public UUID getTreeUID() {
        return this.treeuid;
    }

    public void save() {
        TreeSerializer.saveTree(this);
    }

    public void end() {
        this.unbuild();
        Block bl = this.location.clone().add(1.0, 0.0, 0.0).getBlock();
        if (bl.getType() == Material.PLAYER_HEAD) {
            bl.setType(Material.AIR);
        }
        if ((bl = this.location.clone().add(-1.0, 0.0, 0.0).getBlock()).getType() == Material.PLAYER_HEAD) {
            bl.setType(Material.AIR);
        }
        if ((bl = this.location.clone().add(0.0, 0.0, 1.0).getBlock()).getType() == Material.PLAYER_HEAD) {
            bl.setType(Material.AIR);
        }
        if ((bl = this.location.clone().add(0.0, 0.0, -1.0).getBlock()).getType() == Material.PLAYER_HEAD) {
            bl.setType(Material.AIR);
        }
        if ((bl = this.location.clone().add(1.0, 0.0, 1.0).getBlock()).getType() == Material.PLAYER_HEAD) {
            bl.setType(Material.AIR);
        }
        if ((bl = this.location.clone().add(-1.0, 0.0, -1.0).getBlock()).getType() == Material.PLAYER_HEAD) {
            bl.setType(Material.AIR);
        }
        if ((bl = this.location.clone().add(-1.0, 0.0, 1.0).getBlock()).getType() == Material.PLAYER_HEAD) {
            bl.setType(Material.AIR);
        }
        if ((bl = this.location.clone().add(1.0, 0.0, -1.0).getBlock()).getType() == Material.PLAYER_HEAD) {
            bl.setType(Material.AIR);
        }
        if (Main.resourceBack) {
            bl = this.location.getBlock();
            bl.setType(Material.CHEST);
            Chest chest = (Chest)bl.getState();
            Inventory inv = chest.getInventory();
            inv.addItem(new ItemStack[]{new ItemStack(Material.DIAMOND, 4)});
            inv.addItem(new ItemStack[]{new ItemStack(Material.EMERALD, 1)});
            TreeLevel cLevel = TreeLevel.SAPLING;
            while (cLevel != this.level) {
                if (cLevel.getLevelupRequirements() != null && cLevel.getLevelupRequirements().size() > 0) {
                    for (Map.Entry<Material, Integer> currItem : cLevel.getLevelupRequirements().entrySet()) {
                        inv.addItem(new ItemStack[]{new ItemStack(currItem.getKey(), currItem.getValue().intValue())});
                    }
                }
                if (cLevel.nextLevel == null) break;
                cLevel = cLevel.nextLevel;
            }
            int count = 0;
            for (Map.Entry<Material, Integer> currItem : this.level.getLevelupRequirements().entrySet()) {
                if (this.getLevelupRequirements().containsKey(currItem.getKey())) {
                    count = this.getLevelupRequirements().get(currItem.getKey());
                }
                if (currItem.getValue() - count > 0) {
                    inv.addItem(new ItemStack[]{new ItemStack(currItem.getKey(), currItem.getValue() - count)});
                }
                count = 0;
            }
        }
        XMas.removeTree(this);
    }

    public long getPresentCounter() {
        return this.presentCounter;
    }

    public int getScheduledPresents() {
        return this.scheduledPresents;
    }

    public boolean hasScheduledPresents() {
        return this.scheduledPresents > 0;
    }

    public void spawnScheduledPresents() {
        for (int i = this.scheduledPresents; i > 0; --i) {
            this.spawnPresent();
        }
        this.scheduledPresents = 0;
    }
}

