/*
 * Decompiled with CFR 0.152.
 */
package ru.meloncode.xmas;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.FileConfiguration;
import ru.meloncode.xmas.Main;
import ru.meloncode.xmas.utils.ConfigUtils;
import ru.meloncode.xmas.utils.TextUtils;

public class LocaleManager {
    private static final FileConfiguration def_locale = ConfigUtils.loadConfig(new File(Main.getInstance().getDataFolder() + "/locales/default.yml"));
    public static String PLUGIN_NAME;
    public static String PLUGIN_ENABLED;
    public static String GROW_LVL_PROGRESS;
    public static String GROW_LVL_READY;
    public static String GROW_LEVEL_MAX;
    public static String GROW_REQ_LIST_TITLE;
    public static String GROW_NOT_ENOUGH_PLACE;
    public static String TREE_LIMIT;
    public static String DESTROY_SAPLING;
    public static String DESTROY_LEAVES_SANTA;
    public static String DESTROY_LEAVES_TUT;
    public static String DESTROY_WARNING;
    public static String DESTROY_FAIL_OWNER;
    public static String DESTROY_TUT;
    public static String CRYSTAL_NAME;
    public static List<String> CRYSTAL_LORE;
    public static String GIFT_LUCK;
    public static String GIFT_FAIL;
    public static String MONSTER;
    public static String TIMEOUT;
    public static String HAPPY_NEW_YEAR;
    public static List<String> COMMAND_HELP;
    public static String COMMAND_PLAYER_OFFLINE;
    public static String COMMAND_NO_PLAYER_NAME;
    public static String COMMAND_GIVEAWAY;
    private static FileConfiguration locale;

    public static void loadLocale(String lang) {
        File file = new File(Main.getInstance().getDataFolder() + "/locales/" + lang + ".yml");
        if (!file.exists()) {
            TextUtils.sendConsoleMessage("Can't load locale '" + lang + "'");
            TextUtils.sendConsoleMessage("Switching to default locale 'en'");
            locale = def_locale;
        } else {
            locale = ConfigUtils.loadConfig(file);
            TextUtils.sendConsoleMessage("Locale '" + lang + "' successfuly loaded");
        }
        LocaleManager.loadStrings();
    }

    private static void loadStrings() {
        PLUGIN_NAME = LocaleManager.getString("plugin-name");
        PLUGIN_ENABLED = LocaleManager.getString("messages.plugin-enabled");
        GROW_LVL_PROGRESS = LocaleManager.getString("messages.tree.grow-lvl-progress");
        GROW_LVL_READY = LocaleManager.getString("messages.tree.grow-lvl-ready");
        GROW_LEVEL_MAX = LocaleManager.getString("messages.tree.grow-lvl-max");
        GROW_REQ_LIST_TITLE = LocaleManager.getString("messages.tree.grow-req-list-title");
        GROW_NOT_ENOUGH_PLACE = LocaleManager.getString("messages.tree.grow-not-enough-place");
        TREE_LIMIT = LocaleManager.getString("messages.tree.tree-limit");
        DESTROY_SAPLING = LocaleManager.getString("messages.tree.destroy-sapling");
        DESTROY_LEAVES_SANTA = LocaleManager.getString("messages.tree.destroy-leaves-santa");
        DESTROY_LEAVES_TUT = LocaleManager.getString("messages.tree.destroy-leaves-tut");
        MONSTER = LocaleManager.getString("messages.tree.destroy-complete");
        DESTROY_WARNING = LocaleManager.getString("messages.tree.destroy-warning");
        DESTROY_TUT = LocaleManager.getString("messages.tree.destroy-tut");
        DESTROY_FAIL_OWNER = LocaleManager.getString("messages.tree.destroy-fail-owner");
        CRYSTAL_NAME = ChatColor.GREEN + LocaleManager.getString("crystal.name");
        CRYSTAL_LORE = LocaleManager.getStringList("crystal.lore");
        GIFT_LUCK = LocaleManager.getString("messages.gift.luck-message");
        GIFT_FAIL = LocaleManager.getString("messages.gift.unluck-message");
        TIMEOUT = LocaleManager.getString("messages.timeout");
        HAPPY_NEW_YEAR = LocaleManager.getString("messages.final-wish");
        COMMAND_HELP = LocaleManager.getStringList("command.help");
        COMMAND_PLAYER_OFFLINE = LocaleManager.getString("command.player-offline");
        COMMAND_NO_PLAYER_NAME = LocaleManager.getString("command.no-player-name");
        COMMAND_GIVEAWAY = LocaleManager.getString("command.giveaway");
    }

    private static String getString(String path) {
        if (locale == null) {
            throw new NullPointerException("Locale not loaded");
        }
        try {
            String message = ChatColor.translateAlternateColorCodes((char)'&', (String)locale.getString(path));
            return message.contains("_UNUSED") ? null : message;
        }
        catch (NullPointerException e) {
            TextUtils.sendConsoleMessage(ChatColor.DARK_RED + "Unable to find '" + path + "' in locale " + Main.getInstance().getConfig().getString("core.locale") + ". Bad File?");
            TextUtils.sendConsoleMessage(ChatColor.DARK_RED + "Using default locale to get value");
            return def_locale.getString(path);
        }
    }

    private static List<String> getStringList(String path) {
        if (locale == null) {
            throw new NullPointerException("Locale not loaded");
        }
        try {
            List raw = locale.getStringList(path);
            ArrayList<String> list = new ArrayList<String>();
            for (String s : raw) {
                list.add(ChatColor.translateAlternateColorCodes((char)'&', (String)s));
            }
            return list;
        }
        catch (IllegalArgumentException e) {
            TextUtils.sendConsoleMessage(ChatColor.DARK_RED + "Unable to find '" + path + "' in locale " + Main.getInstance().getConfig().getString("core.locale") + ". Bad File?");
            TextUtils.sendConsoleMessage(ChatColor.DARK_RED + "Using default locale to get value");
            return def_locale.getStringList(path);
        }
    }
}

