/*
 * Decompiled with CFR 0.152.
 */
package ru.meloncode.xmas;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemMaker {
    private final ItemStack is;
    private ItemMeta im;

    public ItemMaker(Material material) {
        this.is = new ItemStack(material);
        this.im = this.is.getItemMeta();
    }

    public ItemMaker(Material material, String name) {
        this.is = new ItemStack(material);
        this.im = this.is.getItemMeta();
        this.im.setDisplayName(name);
    }

    public ItemMaker(Material material, String name, List<String> lore) {
        this.is = new ItemStack(material);
        this.im = this.is.getItemMeta();
        this.im.setDisplayName(name);
        this.im.setLore(lore);
    }

    public ItemMaker(Material material, int amount, short durability) {
        this.is = new ItemStack(material, amount);
        this.im = this.is.getItemMeta();
    }

    public ItemMaker(Material material, int amount, short durability, String name) {
        this.is = new ItemStack(material, amount);
        this.im = this.is.getItemMeta();
        this.im.setDisplayName(name);
    }

    public ItemMaker(Material material, int amount, short durability, String name, List<String> lore) {
        this.is = new ItemStack(material, amount);
        this.im = this.is.getItemMeta();
        this.im.setDisplayName(name);
        this.im.setLore(lore);
    }

    public ItemMaker setAmount(int amount) {
        this.is.setAmount(amount);
        return this;
    }

    public ItemMaker setDurability(short data) {
        ((Damageable)this.is).setDamage((int)data);
        return this;
    }

    public ItemMaker setName(String name) {
        this.im.setDisplayName(ChatColor.RESET + name);
        return this;
    }

    public ItemMaker setLore(List<String> lore) {
        this.im.setLore(lore);
        return this;
    }

    public ItemMaker addLoreLine(String line) {
        ArrayList<String> lore = this.im.getLore() != null ? this.im.getLore() : new ArrayList<String>();
        lore.add(line);
        this.im.setLore(lore);
        return this;
    }

    public ItemMaker addEnchant(Enchantment enchantment) {
        this.im.addEnchant(enchantment, 1, true);
        return this;
    }

    public ItemMaker addEnchant(Enchantment enchantment, int level) {
        this.im.addEnchant(enchantment, level, true);
        return this;
    }

    public ItemStack make() {
        this.is.setItemMeta(this.im);
        this.im = null;
        return this.is;
    }
}

