/*
 * Decompiled with CFR 0.152.
 */
package ru.meloncode.xmas;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.TreeType;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.block.BlockSpreadEvent;
import org.bukkit.event.block.LeavesDecayEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.ItemSpawnEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.event.world.StructureGrowEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import ru.meloncode.xmas.LocaleManager;
import ru.meloncode.xmas.MagicTree;
import ru.meloncode.xmas.Main;
import ru.meloncode.xmas.XMas;
import ru.meloncode.xmas.utils.TextUtils;

class Events
implements Listener {
    private final Map<UUID, Long> destroyers = new HashMap<UUID, Long>();

    Events() {
    }

    public void registerListener() {
        Bukkit.getPluginManager().registerEvents((Listener)this, Main.getInstance());
    }

    @EventHandler
    public void onPlayerOpenPresent(PlayerInteractEvent event) {
        Block block;
        if (event.getHand() == EquipmentSlot.OFF_HAND) {
            return;
        }
        if (event.getAction() == Action.RIGHT_CLICK_BLOCK && (block = event.getClickedBlock()) != null && block.getType() == Material.PLAYER_HEAD) {
            XMas.processPresent(block, event.getPlayer());
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onPlayerOpenPresent(BlockBreakEvent event) {
        Block block = event.getBlock();
        if (block != null && block.getType() == Material.PLAYER_HEAD) {
            XMas.processPresent(block, event.getPlayer());
        }
    }

    @EventHandler
    public void onPlayerUseBonemeal(PlayerInteractEvent event) {
        if (event.getAction() == Action.RIGHT_CLICK_BLOCK && MagicTree.isBlockBelongs(event.getClickedBlock()) && event.getItem() != null && event.getItem().getType() == Material.BONE_MEAL) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerClickBlock(PlayerInteractEvent event) {
        if (event.getHand() == EquipmentSlot.OFF_HAND) {
            return;
        }
        Player player = event.getPlayer();
        if (event.getAction() == Action.RIGHT_CLICK_BLOCK) {
            ItemStack is;
            Block block = event.getClickedBlock();
            if (MagicTree.isBlockBelongs(block)) {
                event.setCancelled(true);
                MagicTree tree = MagicTree.getTreeByBlock(block);
                if (Main.inProgress) {
                    if (tree.getLevel().hasNext()) {
                        if (tree.canLevelUp()) {
                            if (!tree.tryLevelUp()) {
                                TextUtils.sendMessage(player, LocaleManager.GROW_NOT_ENOUGH_PLACE);
                            }
                        } else {
                            Object is2;
                            if (event.getItem() != null && tree.grow((is2 = event.getItem()).getType())) {
                                TextUtils.sendMessage(player, LocaleManager.GROW_LVL_PROGRESS);
                                if (player.getGameMode() != GameMode.CREATIVE) {
                                    if (is2.getAmount() > 1) {
                                        is2.setAmount(is2.getAmount() - 1);
                                    } else {
                                        event.getPlayer().getInventory().setItemInMainHand(new ItemStack(Material.AIR));
                                    }
                                }
                            }
                            if (tree.level.nextLevel != null) {
                                TextUtils.sendMessage(player, LocaleManager.GROW_LVL_PROGRESS);
                                for (String line : TextUtils.generateChatReqList(tree)) {
                                    TextUtils.sendMessage(player, line);
                                }
                                if (tree.getLevelupRequirements().size() == 0) {
                                    TextUtils.sendMessage(player, LocaleManager.GROW_LVL_READY);
                                }
                            }
                        }
                    } else {
                        TextUtils.sendMessage(player, LocaleManager.GROW_LEVEL_MAX);
                    }
                } else if (player.getUniqueId().equals(tree.getOwner())) {
                    tree.end();
                    TextUtils.sendMessage(player, LocaleManager.TIMEOUT);
                } else {
                    TextUtils.sendMessage(player, LocaleManager.DESTROY_FAIL_OWNER);
                }
            } else if (block.getType() == Material.SPRUCE_SAPLING && (is = event.getItem()) != null) {
                if (Main.inProgress) {
                    if (XMas.getTreesPlayerOwn(player).size() < Main.MAX_TREE_COUNT) {
                        ItemMeta im;
                        if (is.getType() == XMas.XMAS_CRYSTAL.getType() && is.hasItemMeta() && is.getItemMeta().hasLore() && (im = is.getItemMeta()).getLore().equals(XMas.XMAS_CRYSTAL.getItemMeta().getLore())) {
                            if (player.getGameMode() != GameMode.CREATIVE) {
                                if (is.getAmount() > 1) {
                                    is.setAmount(is.getAmount() - 1);
                                } else {
                                    event.getPlayer().getInventory().setItemInMainHand(new ItemStack(Material.AIR));
                                }
                            }
                            XMas.createMagicTree(player, block.getLocation());
                        }
                    } else {
                        TextUtils.sendMessage(player, LocaleManager.TREE_LIMIT);
                    }
                } else {
                    TextUtils.sendMessage(player, LocaleManager.TIMEOUT);
                }
            }
        }
    }

    @EventHandler
    public void onPistonExtend(BlockPistonExtendEvent event) {
        for (Block block : event.getBlocks()) {
            if (!MagicTree.isBlockBelongs(block)) continue;
            event.setCancelled(true);
            break;
        }
    }

    @EventHandler
    public void onBlockBreakByExplosion(EntityExplodeEvent event) {
        for (Block block : event.blockList()) {
            if (!MagicTree.isBlockBelongs(block)) continue;
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onItemSpawn(ItemSpawnEvent event) {
        SkullMeta meta;
        ItemStack item = event.getEntity().getItemStack();
        if (item.getType() == Material.PLAYER_HEAD && (meta = (SkullMeta)item.getItemMeta()).getOwner() != null && Main.getHeads().contains(meta.getOwner())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPistonRetract(BlockPistonRetractEvent event) {
        if (MagicTree.isBlockBelongs(event.getBlock())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onBlockBurn(BlockBurnEvent event) {
        if (MagicTree.isBlockBelongs(event.getBlock())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onBlockSpread(BlockSpreadEvent event) {
        if (MagicTree.isBlockBelongs(event.getBlock())) {
            event.setCancelled(true);
        }
        for (BlockFace face : BlockFace.values()) {
            if (!MagicTree.isBlockBelongs(event.getBlock().getRelative(face))) continue;
            event.setCancelled(true);
            break;
        }
    }

    @EventHandler
    public void onPlayerBreakBlock(BlockBreakEvent event) {
        Player player = event.getPlayer();
        Block block = event.getBlock();
        if (MagicTree.isBlockBelongs(block)) {
            event.setCancelled(true);
            MagicTree tree = MagicTree.getTreeByBlock(block);
            switch (block.getType()) {
                case SPRUCE_LOG: {
                    if (player.getUniqueId().equals(tree.getOwner()) || player.hasPermission("xmas.admin")) {
                        if (Main.inProgress) {
                            if (this.destroyers.containsKey(player.getUniqueId()) && System.currentTimeMillis() - this.destroyers.get(player.getUniqueId()) <= 10000L) {
                                XMas.removeTree(tree);
                                if (!Main.inProgress) break;
                                TextUtils.sendMessage(player, ChatColor.DARK_RED + LocaleManager.MONSTER);
                                break;
                            }
                            this.destroyers.put(player.getUniqueId(), System.currentTimeMillis());
                            if (Main.inProgress) {
                                TextUtils.sendMessage(player, ChatColor.RED + LocaleManager.DESTROY_WARNING);
                            }
                            TextUtils.sendMessage(player, ChatColor.DARK_RED + LocaleManager.DESTROY_TUT);
                            break;
                        }
                        tree.end();
                        break;
                    }
                    TextUtils.sendMessage(player, LocaleManager.DESTROY_FAIL_OWNER);
                    break;
                }
                case SPRUCE_LEAVES: 
                case GLOWSTONE: {
                    if (Main.inProgress) {
                        TextUtils.sendMessage(player, ChatColor.DARK_GREEN + LocaleManager.DESTROY_LEAVES_SANTA);
                    }
                    if (player.getUniqueId().equals(tree.getOwner()) || player.hasPermission("xmas.admin")) {
                        TextUtils.sendMessage(player, ChatColor.RED + LocaleManager.DESTROY_LEAVES_TUT);
                        break;
                    }
                    TextUtils.sendMessage(player, LocaleManager.DESTROY_FAIL_OWNER);
                    break;
                }
                case SPRUCE_SAPLING: {
                    if (player.getUniqueId().equals(tree.getOwner()) || player.hasPermission("xmas.admin")) {
                        if (Main.inProgress) {
                            if (this.destroyers.containsKey(player.getUniqueId()) && System.currentTimeMillis() - this.destroyers.get(player.getUniqueId()) <= 10000L) {
                                XMas.removeTree(tree);
                                TextUtils.sendMessage(player, ChatColor.RED + LocaleManager.MONSTER);
                                break;
                            }
                            this.destroyers.put(player.getUniqueId(), System.currentTimeMillis());
                            if (Main.inProgress) {
                                TextUtils.sendMessage(player, ChatColor.RED + LocaleManager.DESTROY_SAPLING);
                            }
                            TextUtils.sendMessage(player, ChatColor.DARK_RED + LocaleManager.DESTROY_TUT);
                            break;
                        }
                        tree.end();
                        break;
                    }
                    TextUtils.sendMessage(player, LocaleManager.DESTROY_FAIL_OWNER);
                    break;
                }
            }
        }
    }

    @EventHandler
    public void onSaplingGrow(StructureGrowEvent event) {
        if (event.getSpecies() == TreeType.REDWOOD && MagicTree.isBlockBelongs(event.getLocation().getBlock())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void disableDecay(LeavesDecayEvent e) {
        if (e.isCancelled()) {
            return;
        }
        if (e.getBlock().getType() != Material.SPRUCE_LEAVES) {
            return;
        }
        if (MagicTree.isBlockBelongs(e.getBlock().getLocation().getBlock())) {
            e.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    private void disableFireworkDamage(EntityDamageByEntityEvent e) {
        if (e.getDamager().getType() == EntityType.FIREWORK && e.getDamager().hasMetadata("nodamage")) {
            e.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    private void chunkLoad(ChunkLoadEvent e) {
        Collection<MagicTree> trees = XMas.getAllTreesInChunk(e.getChunk());
        if (trees == null) {
            return;
        }
        for (MagicTree tree : trees) {
            if (!tree.hasScheduledPresents()) continue;
            tree.spawnScheduledPresents();
        }
    }
}

