/*
 * Decompiled with CFR 0.152.
 */
package me.ghose.report;

import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permission;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class Report
extends JavaPlugin
implements CommandExecutor {
    private Map<Player, Long> reportTimer = new HashMap<Player, Long>();

    public void onEnable() {
        this.registerPermissions();
    }

    public void onDisable() {
    }

    public void registerPermissions() {
        PluginManager pm = this.getServer().getPluginManager();
        Permission alerts = new Permission("report.alerts");
        pm.addPermission(alerts);
    }

    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String[] args) {
        if (commandLabel.equalsIgnoreCase("report")) {
            if (!(sender instanceof Player)) {
                sender.sendMessage("Only players ingame can use this command.");
                return false;
            }
            Player player = (Player)sender;
            if (args.length <= 1) {
                player.sendMessage(ChatColor.RED + "Correct usage: /report <player> <reason>");
            } else if (args.length >= 2) {
                Player target = Bukkit.getServer().getPlayer(args[0]);
                if (target != null) {
                    if (this.reportTimer.containsKey(player)) {
                        long diff = System.currentTimeMillis() - this.reportTimer.get(player);
                        if (diff > 0L) {
                            StringBuilder builder = new StringBuilder();
                            int i = 1;
                            while (i < args.length) {
                                builder.append(String.valueOf(args[i]) + " ");
                                ++i;
                            }
                            this.reportTimer.put(player, System.currentTimeMillis() + 180000L);
                            player.sendMessage(ChatColor.GREEN + "Your report has been sent to all online staff members.");
                            this.alertstaff(ChatColor.AQUA + "[Report] " + ChatColor.YELLOW + target.getName() + ChatColor.BLUE + " has been reported by " + ChatColor.RED + player.getName() + ChatColor.BLUE + " for " + ChatColor.YELLOW + builder.toString());
                        } else {
                            long timeRemaining = this.reportTimer.get(player) - System.currentTimeMillis();
                            player.sendMessage(ChatColor.RED + "You must wait " + timeRemaining / 60000L + " minutes before reporting someone again");
                        }
                    } else {
                        StringBuilder builder = new StringBuilder();
                        int i = 1;
                        while (i < args.length) {
                            builder.append(String.valueOf(args[i]) + " ");
                            ++i;
                        }
                        this.reportTimer.put(player, System.currentTimeMillis() + 180000L);
                        player.sendMessage(ChatColor.GREEN + "Your report has been sent to all online staff members.");
                        this.alertstaff(ChatColor.AQUA + "[Report] " + ChatColor.YELLOW + target.getName() + ChatColor.BLUE + " has been reported by " + ChatColor.RED + player.getName() + ChatColor.BLUE + " for " + ChatColor.YELLOW + builder.toString());
                    }
                } else {
                    player.sendMessage(ChatColor.RED + "Player not found/offline");
                }
            }
        }
        return false;
    }

    public void alertstaff(String string) {
        Player[] playerArray = this.getServer().getOnlinePlayers();
        int n = playerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Player staff = playerArray[n2];
            if (staff.hasPermission("report.alerts")) {
                staff.sendMessage(string);
            }
            ++n2;
        }
    }
}

