/*
 * Decompiled with CFR 0.152.
 */
package net.tmxx.signops.sign;

import java.util.function.Function;
import net.tmxx.signops.util.URLUtil;

public enum OperationSignAction {
    OPEN_LINK(new Function<String, Boolean>(){

        @Override
        public Boolean apply(String input) {
            return URLUtil.containsURL(input);
        }
    }, "<URL>"),
    EXECUTE_COMMAND(new Function<String, Boolean>(){

        @Override
        public Boolean apply(String input) {
            return true;
        }
    }, "<Command> [Arguments]"),
    VECTOR(new Function<String, Boolean>(){

        @Override
        public Boolean apply(String input) {
            String[] split = input.split(";");
            if (split.length != 3) {
                return false;
            }
            for (String string : split) {
                try {
                    Double.parseDouble(string);
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
            return true;
        }
    }, "<X>;<Y>;<Z>");

    private final Function<String, Boolean> checkFunction;
    private final String valueTemplate;

    public boolean check(String input) {
        return this.checkFunction.apply(input);
    }

    private OperationSignAction(Function<String, Boolean> checkFunction, String valueTemplate) {
        this.checkFunction = checkFunction;
        this.valueTemplate = valueTemplate;
    }

    public String getValueTemplate() {
        return this.valueTemplate;
    }
}

