/*
 * Decompiled with CFR 0.152.
 */
package net.tmxx.signops.sign;

import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.tmxx.signops.sign.OperationSignAction;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class OperationSign {
    private String world;
    private int x;
    private int y;
    private int z;
    private OperationSignAction operationSignAction;
    private String value;

    public boolean equalsLocation(Location location) {
        return location.getWorld().getName().equals(this.world) && location.getBlockX() == this.x && location.getBlockY() == this.y && location.getBlockZ() == this.z;
    }

    public void performAction(Player player) {
        switch (this.operationSignAction) {
            case OPEN_LINK: {
                TextComponent textComponent = new TextComponent("\u00a7e\u00a7lClick here to open link!");
                textComponent.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, this.value.startsWith("http://") || this.value.startsWith("https://") ? this.value : "http://" + this.value));
                textComponent.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (BaseComponent[])new TextComponent[]{new TextComponent("\u00a7e\u00a7l" + this.value)}));
                player.spigot().sendMessage((BaseComponent)textComponent);
                break;
            }
            case EXECUTE_COMMAND: {
                player.performCommand(this.value);
                break;
            }
            case VECTOR: {
                String[] split = this.value.split(";");
                double x = Double.parseDouble(split[0]);
                double y = Double.parseDouble(split[1]);
                double z = Double.parseDouble(split[2]);
                player.setVelocity(new Vector(x, y, z));
            }
        }
    }

    public String getWorld() {
        return this.world;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public OperationSignAction getOperationSignAction() {
        return this.operationSignAction;
    }

    public String getValue() {
        return this.value;
    }

    public void setWorld(String world) {
        this.world = world;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public void setZ(int z) {
        this.z = z;
    }

    public void setOperationSignAction(OperationSignAction operationSignAction) {
        this.operationSignAction = operationSignAction;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OperationSign)) {
            return false;
        }
        OperationSign other = (OperationSign)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$world = this.getWorld();
        String other$world = other.getWorld();
        if (this$world == null ? other$world != null : !this$world.equals(other$world)) {
            return false;
        }
        if (this.getX() != other.getX()) {
            return false;
        }
        if (this.getY() != other.getY()) {
            return false;
        }
        if (this.getZ() != other.getZ()) {
            return false;
        }
        OperationSignAction this$operationSignAction = this.getOperationSignAction();
        OperationSignAction other$operationSignAction = other.getOperationSignAction();
        if (this$operationSignAction == null ? other$operationSignAction != null : !((Object)((Object)this$operationSignAction)).equals((Object)other$operationSignAction)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OperationSign;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $world = this.getWorld();
        result = result * 59 + ($world == null ? 43 : $world.hashCode());
        result = result * 59 + this.getX();
        result = result * 59 + this.getY();
        result = result * 59 + this.getZ();
        OperationSignAction $operationSignAction = this.getOperationSignAction();
        result = result * 59 + ($operationSignAction == null ? 43 : ((Object)((Object)$operationSignAction)).hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    public String toString() {
        return "OperationSign(world=" + this.getWorld() + ", x=" + this.getX() + ", y=" + this.getY() + ", z=" + this.getZ() + ", operationSignAction=" + (Object)((Object)this.getOperationSignAction()) + ", value=" + this.getValue() + ")";
    }
}

