/*
 * Decompiled with CFR 0.152.
 */
package net.tmxx.signops.listener.player;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.tmxx.signops.SignOps;
import net.tmxx.signops.sign.OperationSign;
import net.tmxx.signops.util.URLUtil;
import org.bukkit.ChatColor;
import org.bukkit.block.Sign;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;

public class PlayerInteractListener
implements Listener {
    private final SignOps signOps;

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK)) {
            if (event.getClickedBlock().getState() instanceof Sign) {
                for (OperationSign operationSign : this.signOps.getMainConfig().getOperationSigns()) {
                    if (!operationSign.equalsLocation(event.getClickedBlock().getLocation())) continue;
                    operationSign.performAction(event.getPlayer());
                }
                Sign sign = (Sign)event.getClickedBlock().getState();
                StringBuilder stringBuilder = new StringBuilder();
                for (int i = 0; i < 4; ++i) {
                    stringBuilder.append(ChatColor.stripColor((String)sign.getLine(i)));
                }
                String url = URLUtil.extractURL(stringBuilder.toString());
                if (url != null) {
                    url = url.trim();
                    TextComponent textComponent = new TextComponent("\u00a7e\u00a7lClick here to open link!");
                    textComponent.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, url.startsWith("http://") || url.startsWith("https://") ? url : "http://" + url));
                    textComponent.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (BaseComponent[])new TextComponent[]{new TextComponent("\u00a7e\u00a7l" + url)}));
                    event.getPlayer().spigot().sendMessage((BaseComponent)textComponent);
                }
            }
        } else if (event.getAction().equals((Object)Action.LEFT_CLICK_BLOCK) && event.getClickedBlock().getState() instanceof Sign) {
            if (this.signOps.getCurrentRemovals().contains(event.getPlayer().getUniqueId())) {
                ArrayList<OperationSign> operationSignList = new ArrayList<OperationSign>();
                for (OperationSign operationSign : this.signOps.getMainConfig().getOperationSigns()) {
                    if (!operationSign.equalsLocation(event.getClickedBlock().getLocation())) continue;
                    operationSignList.add(operationSign);
                }
                if (operationSignList.isEmpty()) {
                    event.getPlayer().sendMessage("\u00a7c\u00a7lNo operations to remove here");
                    this.signOps.getCurrentRemovals().remove(event.getPlayer().getUniqueId());
                    event.setCancelled(true);
                } else {
                    for (OperationSign operationSign : operationSignList) {
                        this.signOps.getMainConfig().getOperationSigns().remove(operationSign);
                    }
                    this.signOps.getMainConfig().saveConfig();
                    this.signOps.getCurrentRemovals().remove(event.getPlayer().getUniqueId());
                    event.getPlayer().sendMessage("\u00a7e\u00a7lRemoved sign operations");
                    event.setCancelled(true);
                }
            } else {
                OperationSign operationSign = this.signOps.getCurrentSetups().get(event.getPlayer().getUniqueId());
                if (operationSign != null) {
                    operationSign.setWorld(event.getClickedBlock().getWorld().getName());
                    operationSign.setX(event.getClickedBlock().getX());
                    operationSign.setY(event.getClickedBlock().getY());
                    operationSign.setZ(event.getClickedBlock().getZ());
                    this.signOps.getMainConfig().getOperationSigns().add(operationSign);
                    this.signOps.getMainConfig().saveConfig();
                    this.signOps.getCurrentSetups().remove(event.getPlayer().getUniqueId());
                    event.getPlayer().sendMessage("\u00a7e\u00a7lSuccessfully applied values to operation sign");
                    event.setCancelled(true);
                }
            }
        }
    }

    @ConstructorProperties(value={"signOps"})
    public PlayerInteractListener(SignOps signOps) {
        this.signOps = signOps;
    }
}

