/*
 * Decompiled with CFR 0.152.
 */
package net.tmxx.signops;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.cubespace.Yamler.Config.InvalidConfigurationException;
import net.tmxx.signops.command.SignOpsCommand;
import net.tmxx.signops.command.sub.Add;
import net.tmxx.signops.command.sub.Remove;
import net.tmxx.signops.command.sub.SetLine;
import net.tmxx.signops.config.MainConfig;
import net.tmxx.signops.listener.block.BlockBreakListener;
import net.tmxx.signops.listener.block.SignChangeListener;
import net.tmxx.signops.listener.player.PlayerInteractListener;
import net.tmxx.signops.sign.OperationSign;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class SignOps
extends JavaPlugin {
    private MainConfig mainConfig;
    private Map<UUID, OperationSign> currentSetups = new HashMap<UUID, OperationSign>();
    private List<UUID> currentRemovals = new ArrayList<UUID>();

    public void onEnable() {
        this.mainConfig = new MainConfig(this);
        try {
            this.mainConfig.init();
        }
        catch (InvalidConfigurationException e) {
            e.printStackTrace();
        }
        this.setupCommands();
        this.setupListeners();
        this.getLogger().info("SignOps adds new sign operations to the game.\n    Copyright (C) 2016  tmxx\n\n    This program is free software: you can redistribute it and/or modify\n    it under the terms of the GNU General Public License as published by\n    the Free Software Foundation, either version 3 of the License, or\n    (at your option) any later version.\n\n    This program is distributed in the hope that it will be useful,\n    but WITHOUT ANY WARRANTY; without even the implied warranty of\n    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n    GNU General Public License for more details.\n\n    You should have received a copy of the GNU General Public License\n    along with this program.  If not, see <http://www.gnu.org/licenses/>.");
    }

    private void setupCommands() {
        SignOpsCommand signOpsCommand = new SignOpsCommand();
        signOpsCommand.addCommand(new SetLine());
        signOpsCommand.addCommand(new Add(this));
        signOpsCommand.addCommand(new Remove(this));
        this.getCommand("signops").setExecutor((CommandExecutor)signOpsCommand);
    }

    private void setupListeners() {
        PluginManager pluginManager = this.getServer().getPluginManager();
        pluginManager.registerEvents((Listener)new PlayerInteractListener(this), (Plugin)this);
        pluginManager.registerEvents((Listener)new BlockBreakListener(this), (Plugin)this);
        pluginManager.registerEvents((Listener)new SignChangeListener(), (Plugin)this);
    }

    public MainConfig getMainConfig() {
        return this.mainConfig;
    }

    public Map<UUID, OperationSign> getCurrentSetups() {
        return this.currentSetups;
    }

    public List<UUID> getCurrentRemovals() {
        return this.currentRemovals;
    }
}

