/*
 * Decompiled with CFR 0.152.
 */
package net.cubespace.Yamler.Config.Converter;

import java.lang.reflect.ParameterizedType;
import java.util.HashSet;
import net.cubespace.Yamler.Config.Converter.Converter;
import net.cubespace.Yamler.Config.InternalConverter;

public class Primitive
implements Converter {
    private HashSet<String> types = new HashSet<String>(){
        {
            this.add("boolean");
            this.add("char");
            this.add("byte");
            this.add("short");
            this.add("int");
            this.add("long");
            this.add("float");
            this.add("double");
        }
    };
    private InternalConverter internalConverter;

    public Primitive(InternalConverter internalConverter) {
        this.internalConverter = internalConverter;
    }

    @Override
    public Object toConfig(Class<?> type, Object obj, ParameterizedType parameterizedType) throws Exception {
        return obj;
    }

    public Object fromConfig(Class type, Object section, ParameterizedType genericType) throws Exception {
        switch (type.getSimpleName()) {
            case "short": {
                return section instanceof Short ? section : Short.valueOf(new Integer((Integer)section).shortValue());
            }
            case "byte": {
                return section instanceof Byte ? section : Byte.valueOf(new Integer((Integer)section).byteValue());
            }
            case "float": {
                if (section instanceof Integer) {
                    return Float.valueOf(new Double(((Integer)section).intValue()).floatValue());
                }
                return section instanceof Float ? section : Float.valueOf(new Double((Double)section).floatValue());
            }
            case "char": {
                return section instanceof Character ? section : Character.valueOf(((String)section).charAt(0));
            }
        }
        return section;
    }

    @Override
    public boolean supports(Class<?> type) {
        return this.types.contains(type.getName());
    }
}

