/*
 * Decompiled with CFR 0.152.
 */
package org.polushin.mobs_to_eggs;

import java.util.HashMap;
import java.util.Map;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerEggThrowEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.material.SpawnEgg;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.projectiles.ProjectileSource;

public class Main
extends JavaPlugin
implements Listener {
    private double eggPrice;
    private String eggName;
    private String eggPurchased;
    private String noMoney;
    private String eggReturn;
    private String noPlaceInInventory;
    private String noEggInInventory;
    private Economy economy;
    private final Map<Entity, Player> launchedEggs = new HashMap<Entity, Player>();

    public void onEnable() {
        if (!this.setupEconomy()) {
            System.out.println("Need Vault and Economy plugins!");
            return;
        }
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.saveDefaultConfig();
        this.eggName = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("eggName", "\u041b\u043e\u0432\u0443\u0448\u043a\u0430 \u0434\u043b\u044f \u043c\u043e\u0431\u0430"));
        this.eggPurchased = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("eggPurchased", "\u0412\u044b \u043a\u0443\u043f\u0438\u043b\u0438 \u044f\u0439\u0446\u043e!"));
        this.noMoney = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("noMoney", "\u041d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043e\u0447\u043d\u043e \u0441\u0440\u0435\u0434\u0441\u0442\u0432."));
        this.eggReturn = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("eggReturn", "\u042f\u0439\u0446\u043e \u0432\u043e\u0437\u0432\u0440\u0430\u0449\u0435\u043d\u043e."));
        this.noPlaceInInventory = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("noPlaceInInventory", "\u0412 \u0432\u0430\u0448\u0435\u043c \u0438\u043d\u0432\u0435\u043d\u0442\u0430\u0440\u0435 \u043d\u0435\u0442 \u043c\u0435\u0441\u0442\u0430!"));
        this.noEggInInventory = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("noEggInInventory", "\u0412 \u0432\u0430\u0448\u0435\u043c \u0438\u043d\u0432\u0435\u043d\u0442\u0430\u0440\u0435 \u043d\u0435\u0442 \u044f\u0439\u0446\u0430 \u043d\u0430 \u043f\u0440\u043e\u0434\u0430\u0436\u0443."));
        this.eggPrice = this.getConfig().getDouble("eggPrice", 5.5);
    }

    private boolean setupEconomy() {
        RegisteredServiceProvider economyProvider = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (economyProvider != null) {
            this.economy = (Economy)economyProvider.getProvider();
        }
        return this.economy != null;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        Player player = null;
        if (sender instanceof Player) {
            player = (Player)sender;
        }
        if (player == null) {
            sender.sendMessage(ChatColor.RED + "This command only for player.");
            return true;
        }
        if (args.length < 1) {
            return false;
        }
        switch (args[0].toLowerCase()) {
            case "catch": {
                this.commandCatch(player);
                break;
            }
            case "return": {
                this.commandReturn(player);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private void commandCatch(Player player) {
        if (this.economy.getBalance((OfflinePlayer)player) < this.eggPrice) {
            player.sendMessage(this.noMoney);
            return;
        }
        ItemStack item = new ItemStack(Material.EGG);
        ItemMeta meta = Bukkit.getItemFactory().getItemMeta(Material.EGG);
        meta.setDisplayName(this.eggName);
        item.setItemMeta(meta);
        HashMap items = player.getInventory().addItem(new ItemStack[]{item});
        if (!items.isEmpty()) {
            player.sendMessage(this.noPlaceInInventory);
            return;
        }
        this.economy.withdrawPlayer((OfflinePlayer)player, this.eggPrice);
        player.sendMessage(this.eggPurchased);
    }

    private void commandReturn(Player player) {
        PlayerInventory inventory = player.getInventory();
        ItemStack egg = null;
        for (ItemStack item : inventory) {
            if (!this.isEgg(item) || item.getAmount() <= 0) continue;
            egg = item;
            break;
        }
        if (egg == null) {
            player.sendMessage(this.noEggInInventory);
            return;
        }
        egg.setAmount(egg.getAmount() - 1);
        this.economy.depositPlayer((OfflinePlayer)player, this.eggPrice);
        player.sendMessage(this.eggReturn);
    }

    @EventHandler(ignoreCancelled=true)
    public void onLaunch(ProjectileLaunchEvent event) {
        ProjectileSource source = event.getEntity().getShooter();
        if (!(source instanceof Player)) {
            return;
        }
        Player player = (Player)source;
        if (this.isEgg(player.getItemInHand())) {
            this.launchedEggs.put((Entity)event.getEntity(), player);
        }
    }

    @EventHandler
    public void onHit(PlayerEggThrowEvent event) {
        if (this.launchedEggs.remove(event.getEgg()) != null) {
            event.setHatching(false);
        }
    }

    @EventHandler
    public void onDamage(EntityDamageByEntityEvent event) {
        Player player = this.launchedEggs.remove(event.getDamager());
        if (player != null) {
            event.setCancelled(true);
            HashMap items = player.getInventory().addItem(new ItemStack[]{new SpawnEgg(event.getEntityType()).toItemStack(1)});
            for (ItemStack item : items.values()) {
                player.getWorld().dropItemNaturally(player.getLocation(), item);
            }
            event.getEntity().remove();
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onDrop(PlayerDropItemEvent event) {
        if (this.isEgg(event.getItemDrop().getItemStack())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void inventoryClick(InventoryClickEvent event) {
        if (event.getInventory().getType() == InventoryType.CRAFTING || event.getInventory().getType() == InventoryType.PLAYER) {
            return;
        }
        if (event.getAction() == InventoryAction.PLACE_ONE || event.getAction() == InventoryAction.SWAP_WITH_CURSOR || event.getAction() == InventoryAction.PLACE_SOME || event.getAction() == InventoryAction.PLACE_ALL) {
            if (event.getRawSlot() - event.getSlot() == 0 && this.isEgg(event.getCursor())) {
                event.setCancelled(true);
            }
        } else if (event.getAction() == InventoryAction.MOVE_TO_OTHER_INVENTORY && event.getRawSlot() - event.getSlot() != 0 && this.isEgg(event.getCurrentItem())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void inventoryDrag(InventoryDragEvent event) {
        if (this.isEgg(event.getCursor())) {
            event.setCancelled(true);
            return;
        }
        for (ItemStack item : event.getNewItems().values()) {
            if (!this.isEgg(item)) continue;
            event.setCancelled(true);
            return;
        }
    }

    private boolean isEgg(ItemStack item) {
        if (item == null) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        return meta != null && item.getType() == Material.EGG && meta.getDisplayName() != null && meta.getDisplayName().equals(this.eggName);
    }
}

