/*
 * Decompiled with CFR 0.152.
 */
package eu.leopoldhauptman.mobcash;

import eu.leopoldhauptman.mobcash.Configuration;
import eu.leopoldhauptman.mobcash.Metrics.Metrics;
import eu.leopoldhauptman.mobcash.commands.MobCash;
import eu.leopoldhauptman.mobcash.listeners.KilledPlayer;
import eu.leopoldhauptman.mobcash.listeners.MobKillAndSpawn;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;

public class Main
extends JavaPlugin {
    public static Main plugin;
    public static Economy economy;
    public static List<UUID> spawnedMobs;

    public void onEnable() {
        try {
            plugin = this;
            this.getLogger().info(" has been enabled!");
            this.getConfig().options().copyDefaults();
            this.saveDefaultConfig();
            new Configuration().configVersionCheck(8.2);
            this.setupEconomy();
            PluginManager pm = Bukkit.getPluginManager();
            pm.registerEvents((Listener)new KilledPlayer(), (Plugin)plugin);
            pm.registerEvents((Listener)new MobKillAndSpawn(), (Plugin)plugin);
            this.getCommand("mobcash").setExecutor((CommandExecutor)new MobCash());
            new Metrics((Plugin)plugin, 9714);
        }
        catch (NullPointerException e) {
            this.getLogger().warning("Something went wrong :( !");
            this.getLogger().warning("Disabling...");
        }
    }

    public void onDisable() {
        plugin = null;
    }

    private boolean setupEconomy() {
        RegisteredServiceProvider economyProvider = plugin.getServer().getServicesManager().getRegistration(Economy.class);
        if (economyProvider != null) {
            economy = (Economy)economyProvider.getProvider();
            if (economy == null) {
                this.getLogger().warning("Vault doesn't have an economy plugin connected.");
                this.getServer().getPluginManager().disablePlugin((Plugin)this);
            } else {
                this.getLogger().info("Vault has made economy available for this plugin.");
            }
            return economy != null;
        }
        this.getLogger().warning("Vault doesn't have an economy plugin connected.");
        this.getServer().getPluginManager().disablePlugin((Plugin)this);
        return economy == null;
    }

    static {
        spawnedMobs = new ArrayList<UUID>();
    }
}

