/*
 * Decompiled with CFR 0.152.
 */
package me.purox.scenarios.scenarios;

import java.util.HashMap;
import me.purox.scenarios.Main;
import me.purox.scenarios.listener.scenarios.BareBonesListener;
import me.purox.scenarios.listener.scenarios.BowLessListener;
import me.purox.scenarios.listener.scenarios.CutCleanListener;
import me.purox.scenarios.listener.scenarios.DiamondLessListener;
import me.purox.scenarios.listener.scenarios.FireLessListener;
import me.purox.scenarios.listener.scenarios.GoldLessListener;
import me.purox.scenarios.listener.scenarios.HorseLessListener;
import me.purox.scenarios.listener.scenarios.LimitationsListener;
import me.purox.scenarios.listener.scenarios.LuckOresListener;
import me.purox.scenarios.listener.scenarios.NoFallListener;
import me.purox.scenarios.listener.scenarios.RiskyRetrievalListener;
import me.purox.scenarios.listener.scenarios.RodLessListener;
import me.purox.scenarios.listener.scenarios.SoupListener;
import me.purox.scenarios.listener.scenarios.TimberListener;
import me.purox.scenarios.listener.scenarios.TimeBombListener;
import me.purox.scenarios.listener.scenarios.TripleOresListener;
import me.purox.scenarios.listener.scenarios.VanillaPlusListener;
import me.purox.scenarios.scenarios.Scenario;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class ScenarioManager {
    static ScenarioManager instance;
    public HashMap<String, Scenario> scenarioMap = new HashMap();

    public static ScenarioManager getInstance() {
        return instance;
    }

    public static void initialize() {
        instance = new ScenarioManager();
        ScenarioManager.registerScenarios();
    }

    private static void registerScenarios() {
        new Scenario(SCENARIO_NAMES.CutClean.name(), Material.IRON_INGOT, Main.getPlugin().cutcleanDescription, new CutCleanListener());
        new Scenario(SCENARIO_NAMES.TimeBomb.name(), Material.TNT, Main.getPlugin().timebombDescription, new TimeBombListener());
        new Scenario(SCENARIO_NAMES.Bowless.name(), Material.BOW, Main.getPlugin().bowlessDescription, new BowLessListener());
        new Scenario(SCENARIO_NAMES.Rodless.name(), Material.FISHING_ROD, Main.getPlugin().rodlessDescription, new RodLessListener());
        new Scenario(SCENARIO_NAMES.Fireless.name(), Material.FIRE, Main.getPlugin().firelessDescription, new FireLessListener());
        new Scenario(SCENARIO_NAMES.Nofall.name(), Material.DIAMOND_BOOTS, Main.getPlugin().nofallDescription, new NoFallListener());
        new Scenario(SCENARIO_NAMES.Diamondless.name(), Material.DIAMOND, Main.getPlugin().diamondlessDescription, new DiamondLessListener());
        new Scenario(SCENARIO_NAMES.Goldless.name(), Material.GOLD_INGOT, Main.getPlugin().goldlessDescription, new GoldLessListener());
        new Scenario(SCENARIO_NAMES.Timber.name(), Material.IRON_AXE, Main.getPlugin().timberDescription, new TimberListener());
        new Scenario(SCENARIO_NAMES.Horseless.name(), Material.SADDLE, Main.getPlugin().horselessDescription, new HorseLessListener());
        new Scenario(SCENARIO_NAMES.RiskyRetrieval.name(), Material.ENDER_CHEST, Main.getPlugin().riskyretrievalDescription, new RiskyRetrievalListener());
        new Scenario(SCENARIO_NAMES.VanillaPlus.name(), Material.FLINT, Main.getPlugin().vanillaplusDescription, new VanillaPlusListener());
        new Scenario(SCENARIO_NAMES.TripleOres.name(), Material.DIAMOND, Main.getPlugin().tripleoresDescription, new TripleOresListener());
        new Scenario(SCENARIO_NAMES.LuckyOres.name(), Material.GOLD_ORE, Main.getPlugin().luckyoresDescription, new LuckOresListener());
        new Scenario(SCENARIO_NAMES.Limitations.name(), Material.STICK, Main.getPlugin().limitationsDescription, new LimitationsListener());
        new Scenario(SCENARIO_NAMES.Soup.name(), Material.MUSHROOM_SOUP, Main.getPlugin().soupDescription, new SoupListener());
        new Scenario(SCENARIO_NAMES.Barebones.name(), Material.STRING, Main.getPlugin().barebonesDescription, new BareBonesListener());
    }

    public Inventory getScenarioInventory() {
        Inventory inventory = Bukkit.createInventory(null, (int)(this.getEnabledSize() > 18 ? 18 : (this.getEnabledSize() > 27 ? 27 : 36)), (String)(ChatColor.AQUA.toString() + ChatColor.BOLD + "Currently enabled scenarios"));
        for (Scenario scenario : this.scenarioMap.values()) {
            if (!scenario.isEnabled()) continue;
            inventory.addItem(new ItemStack[]{scenario.getExplanationItem()});
        }
        return inventory;
    }

    public int getEnabledSize() {
        int enabled = 0;
        for (Scenario scenario : this.scenarioMap.values()) {
            if (!scenario.isEnabled()) continue;
            ++enabled;
        }
        return enabled;
    }

    public Inventory getEditorInventory() {
        Inventory inventory = Bukkit.createInventory(null, (int)(this.scenarioMap.size() > 18 ? 18 : (this.scenarioMap.size() > 27 ? 27 : 36)), (String)(ChatColor.GOLD.toString() + ChatColor.BOLD + "Scenario Editor"));
        for (Scenario scenario : this.scenarioMap.values()) {
            inventory.addItem(new ItemStack[]{scenario.getEditorItem()});
        }
        return inventory;
    }

    public Scenario getScenario(String name) {
        for (String scenName : this.scenarioMap.keySet()) {
            if (!scenName.toLowerCase().equalsIgnoreCase(name)) continue;
            return this.scenarioMap.get(scenName);
        }
        return null;
    }

    public static enum SCENARIO_NAMES {
        CutClean,
        TimeBomb,
        Bowless,
        Rodless,
        Fireless,
        Nofall,
        Diamondless,
        Goldless,
        Timber,
        Horseless,
        RiskyRetrieval,
        VanillaPlus,
        TripleOres,
        LuckyOres,
        Limitations,
        Soup,
        Barebones;

    }
}

